/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.util.view.fv.IViewCommand;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewCommand;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewPortGraphic;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupException;
import ilog.views.prototypes.IlvGroupFrame;
import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;

public class ViewMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    private ViewManager viewManager = null;
    private boolean mouseDragging = false;

    public ViewMouseAdapter(ViewManager viewManager) {
        this.viewManager = viewManager;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ViewManager.addToLog(this, "ViewMouseAdapter mousePressed");
        this.updateDestGraph(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            if (ViewMouseAdapter.isCtrlShiftPressed(mouseEvent)) {
                this.doMouseCmd(mouseEvent, 8);
            } else {
                this.doMouseCmd(mouseEvent, 5);
            }
        }
    }

    public static boolean isCtrlShiftPressed(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)aWTEvent;
            int n = 3;
            int n2 = actionEvent.getModifiers() & n;
            if (n2 == n) {
                return true;
            }
        } else if (aWTEvent instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)aWTEvent;
            int n = 3;
            int n3 = inputEvent.getModifiers() & n;
            if (n3 == n) {
                return true;
            }
        }
        return false;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            ViewManager.addToLog(this, "ViewMouseAdapter VIEW_MOUSE_SHOW_POPUP");
            this.doMouseCmd(mouseEvent, 5);
        } else {
            try {
                if (!this.mouseDragging) {
                    ViewManager.addToLog(this, "ViewMouseAdapter VIEW_MOUSE_UPDATE");
                    this.doMouseCmd(mouseEvent, 7);
                } else {
                    ViewManager.addToLog(this, "ViewMouseAdapter VIEW_MOUSE_DRAGGED");
                    this.mouseDragging = false;
                    this.doMouseCmd(mouseEvent, 6);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        ViewManager.addToLog(this, "ViewMouseAdapter mouseClicked");
        if (mouseEvent.getClickCount() == 2) {
            this.doMouseCmd(mouseEvent, 4);
        } else {
            this.doMouseCmd(mouseEvent, 3);
        }
    }

    private void updateDestGraph(MouseEvent mouseEvent) {
        IViewCommand iViewCommand = this.viewManager.getViewTk().getSelectedGrapher(mouseEvent);
        if (!(iViewCommand instanceof ViewCompositeGraphic || iViewCommand instanceof IViewLink || iViewCommand instanceof ViewPortGraphic)) {
            this.viewManager.setActualView((ViewGrapher)iViewCommand);
        } else if (iViewCommand == null) {
            this.viewManager.setActualView(null);
        }
    }

    private IViewCommand getSelectedGrapher(MouseEvent mouseEvent) {
        return this.viewManager.getViewTk().getSelectedGrapher(mouseEvent);
    }

    private void doMouseCmd(MouseEvent mouseEvent, int n) {
        Object object;
        IViewCommand iViewCommand = this.getSelectedGrapher(mouseEvent);
        if (iViewCommand == null) {
            iViewCommand = this.viewManager.getViewTk();
            this.viewManager.getViewTk().disableButton("Go To Selected Object View");
        } else if (iViewCommand instanceof ViewDomainGrapher) {
            object = (ViewDomainGrapher)iViewCommand;
            this.viewManager.getViewTk().enableButton("Go To Selected Object View");
            IlvGraphicEnumeration ilvGraphicEnumeration = object.getSelectedObjects(true);
            iViewCommand = this.getSelectedGrapher(mouseEvent);
            if (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                if (ilvGraphic instanceof IlvGroupFrame) {
                    List<ViewCardGrapher> list = ((ViewDomainGrapher)object).getDomainCards();
                    IlvGroupFrame ilvGroupFrame = (IlvGroupFrame)ilvGraphic;
                    IlvGroup ilvGroup = ilvGroupFrame.getGroup();
                    for (int i = 0; i < list.size(); ++i) {
                        ViewCardGrapher viewCardGrapher = list.get(i);
                        String string = viewCardGrapher.getcardName();
                        try {
                            if (ilvGroup.findElement(string) == null) continue;
                            iViewCommand = viewCardGrapher;
                            break;
                        }
                        catch (IlvGroupException ilvGroupException) {
                            // empty catch block
                        }
                    }
                }
                if (ilvGraphic instanceof IViewCommand) {
                    iViewCommand = (IViewCommand)ilvGraphic;
                }
            }
        }
        object = new MouseViewCommand(this.viewManager, iViewCommand, n, mouseEvent);
        this.viewManager.doCommand((ViewCommand)object);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        ViewManager.addToLog(this, "ViewMouseAdapter mouseDragged");
        this.mouseDragging = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        ViewManager.addToLog(this, "ViewMouseAdapter mouseMoved");
        this.toggleCursor(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ViewManager.addToLog(this, "ViewMouseAdapter mouseExited");
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ViewManager.addToLog(this, "ViewMouseAdapter mouseEntered");
    }

    private void toggleCursor(MouseEvent mouseEvent) {
    }

    public void dispose() {
        this.viewManager = null;
    }
}

