/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc;

import cerent.util.KDebug;
import com.cisco.ctc.RemoteEleConstants;
import com.cisco.ctc.RemoteEleModeEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingletonBootstrapper {
    private static final RemoteEleModeEnum mode = RemoteEleConstants.MODE;
    protected static final KDebug db = new KDebug("SingletonBootstrapper");

    protected AbstractSingletonBootstrapper() {
    }

    protected <T, U extends T> U init(ClassLoader classLoader, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("ifType must be non-null");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("ifType: " + clazz.getName() + "  must be an interface type");
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        Object object = null;
        String string2 = null;
        Class<?> clazz2 = null;
        Method method = null;
        try {
            string2 = this.getBootstrapClassname();
            clazz2 = classLoader.loadClass(string2);
            method = clazz2.getMethod("getInstance", new Class[0]);
            object = method.invoke(null, new Object[0]);
            db.println(string + " static instance: " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            db.println(string + " bootstrapping failed!");
            db.println("class " + string2 + " could not be found");
            KDebug.printStackTrace((Throwable)classNotFoundException);
            throw new RuntimeException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            db.println(string + " bootstrapping failed!");
            db.println("a static getInstance() method could not be found in class: " + string2);
            KDebug.printStackTrace((Throwable)noSuchMethodException);
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            db.println(string + " bootstrapping failed!");
            db.println("The static getInstance() method must be public in class: " + string2);
            KDebug.printStackTrace((Throwable)illegalAccessException);
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            db.println(string + " bootstrapping failed!");
            KDebug.printStackTrace((Throwable)invocationTargetException);
            throw new RuntimeException(invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            db.println(string + " bootstrapping failed!");
            KDebug.printStackTrace((Throwable)runtimeException);
            throw runtimeException;
        }
        return (U)object;
    }

    protected abstract String getBootstrapClassname();
}

