/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChartPrintContext;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvScaleAnnotation;
import ilog.views.chart.IlvScaleConfiguration;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.IlvSelectionUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

abstract class IlvDefaultScaleConfiguration
extends IlvScaleConfiguration {
    static final boolean a = true;
    protected IlvScale scale;

    IlvDefaultScaleConfiguration() {
    }

    void a(IlvScale ilvScale) {
        this.scale = ilvScale;
        if (ilvScale != null) {
            ilvScale.a(this.createSteps());
        }
    }

    abstract IlvAxis.Crossing a();

    abstract double a(double var1);

    abstract Rectangle2D getAxisBounds(Rectangle2D var1);

    protected IlvScale.Steps createSteps() {
        return new IlvScale.Steps(this.scale);
    }

    protected int getScaleLength() {
        return Math.min(this.scale.q().width, this.scale.q().height);
    }

    void a(Rectangle2D rectangle2D) {
    }

    abstract int a(int var1, int var2, int var3);

    abstract int t();

    int a(boolean bl) {
        return bl ? this.scale.getMajorTickSize() : this.scale.getMinorTickSize();
    }

    protected void computeTitleLocation(IlvDoublePoint ilvDoublePoint) {
        IlvDataInterval ilvDataInterval = this.scale.getAxis().getVisibleRange();
        double d2 = ilvDataInterval.getMin() + ilvDataInterval.getLength() * (double)this.scale.e().getPlacement() / 100.0;
        this.scale.a(d2, ilvDoublePoint);
        Dimension2D dimension2D = this.scale.e().getSize2D(true);
        IlvGraphicUtil.computeTextLocation(ilvDoublePoint, this.a(d2), this.t(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    void b() {
    }

    boolean c() {
        return true;
    }

    void d() {
    }

    void e() {
    }

    protected void draw(Graphics graphics) {
        this.scale.x();
        if (this.scale.isAxisVisible()) {
            this.drawAxis(graphics);
        }
        if (this.scale.isMajorTickVisible()) {
            this.drawTicks(graphics, true);
        }
        if (this.scale.isMinorTickVisible() && !this.scale.g() && !this.scale.h()) {
            this.drawTicks(graphics, false);
        }
        if (this.scale.isLabelVisible()) {
            this.drawLabels(graphics);
        }
        this.a(graphics);
        IlvChartPrintContext ilvChartPrintContext = this.scale.getChart().getPrintContext();
        if (this.scale.y() && (ilvChartPrintContext == null || ilvChartPrintContext.isTitleVisible(this.scale))) {
            this.scale.e().a(graphics);
        }
        if (this.scale.l()) {
            this.scale.i().draw(graphics);
        }
    }

    protected abstract void drawAxis(Graphics var1);

    void a(Graphics graphics) {
        if (this.scale.ad() == null) {
            return;
        }
        IlvDataInterval ilvDataInterval = this.scale.getAxis().getVisibleRange();
        for (IlvScaleAnnotation ilvScaleAnnotation : this.scale.ad()) {
            if (!ilvDataInterval.isInside(ilvScaleAnnotation.getValue())) continue;
            ilvScaleAnnotation.draw(graphics);
        }
    }

    protected void drawTicks(Graphics graphics, boolean bl) {
        IlvDoublePoints ilvDoublePoints = bl ? this.scale.s() : this.scale.t();
        int n2 = ilvDoublePoints.size();
        if (n2 == 0) {
            return;
        }
        double[] dArray = bl ? this.scale.m().d().data() : this.scale.m().e().data();
        int n3 = this.a(bl);
        int[] nArray = new int[4];
        this.scale.b().applyStroke(graphics);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.scale.a(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2), n3, this.scale.a(dArray[i2]), nArray);
            graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        this.scale.b().restoreStroke(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLabels(Graphics graphics) {
        IlvDoublePoints ilvDoublePoints = this.scale.u();
        int n2 = ilvDoublePoints.size();
        if (n2 == 0) {
            return;
        }
        int n3 = this.scale.z();
        int n4 = this.scale.a(ilvDoublePoints, n3);
        double[] dArray = this.scale.m().f().data();
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        try {
            Color color2 = this.scale.getLabelColor();
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint();
            Rectangle2D rectangle2D = null;
            Rectangle2D rectangle2D2 = null;
            Rectangle rectangle = graphics.getClipBounds();
            boolean bl = this.scale.isSkippingLabel() && this.scale.getSkipLabelMode() == 2;
            boolean bl2 = rectangle != null || bl;
            for (int i2 = 0; i2 < n2; i2 += n4) {
                ilvDoublePoint.setLocation(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2));
                Rectangle2D rectangle2D3 = this.scale.a(i2);
                double d2 = rectangle2D3.getWidth();
                double d3 = rectangle2D3.getHeight();
                ilvDoublePoint = this.scale.computeLabelLocation(ilvDoublePoint, this.a(dArray[i2]), n3, d2, d3);
                if (bl2) {
                    rectangle2D = IlvScale.a(ilvDoublePoint, d2, d3, rectangle2D);
                    if (bl) {
                        if (rectangle2D2 != null) {
                            if (rectangle2D2.intersects(rectangle2D)) continue;
                            Rectangle2D rectangle2D4 = rectangle2D2;
                            rectangle2D2 = rectangle2D;
                            rectangle2D = rectangle2D4;
                        } else {
                            rectangle2D2 = rectangle2D;
                            rectangle2D = null;
                        }
                        if (!rectangle.intersects(rectangle2D2)) continue;
                    }
                }
                this.scale.m().a(i2).draw(graphics, color2, null, ilvDoublePoint.x, ilvDoublePoint.y);
            }
        }
        finally {
            graphics.setColor(color);
            graphics.setFont(font);
        }
    }

    public void drawSelection(Graphics graphics) {
        Rectangle2D rectangle2D = this.scale.getBounds(null);
        IlvSelectionUtil.drawGenericSelection(graphics, rectangle2D.getBounds());
    }

    public boolean contains(Point2D point2D) {
        return this.scale.getBounds(null).contains(point2D);
    }
}

