/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.util.IlvResourceUtil;
import ilog.views.util.time.IlvCalendarUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class IlvTimeUnit
implements Serializable {
    private static ResourceBundle a = null;
    public static final IlvTimeUnit MILLISECOND = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.MILLISECOND.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(14, 1);
            return calendar;
        }

        public double getMillis() {
            return 1.0;
        }

        public String getFormatString() {
            return this.a == null ? "HH:mm:ss.SSS" : this.a;
        }

        public String toString() {
            return "MILLISECOND UNIT";
        }
    };
    public static final IlvTimeUnit SECOND = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.SECOND.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.secondFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(13, 1);
            return calendar;
        }

        public double getMillis() {
            return 1000.0;
        }

        public String getFormatString() {
            return this.a == null ? "HH:mm:ss" : this.a;
        }

        public String toString() {
            return "SECOND UNIT";
        }
    };
    public static final IlvTimeUnit MINUTE = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.MINUTE.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.minuteFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(12, 1);
            return calendar;
        }

        public double getMillis() {
            return 60000.0;
        }

        public String getFormatString() {
            return this.a == null ? "HH:mm" : this.a;
        }

        public String toString() {
            return "MINUTE UNIT";
        }
    };
    public static final IlvTimeUnit HOUR = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.HOUR.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.hourFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(11, 1);
            return calendar;
        }

        public double getMillis() {
            return 3600000.0;
        }

        public String getFormatString() {
            return this.a == null ? "HH:mm" : this.a;
        }

        public String toString() {
            return "HOUR UNIT";
        }
    };
    public static final IlvTimeUnit DAY = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.DAY.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.dayFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(6, 1);
            return calendar;
        }

        public double getMillis() {
            return 8.64E7;
        }

        public String getFormatString() {
            return this.a == null ? "E dd" : this.a;
        }

        public String toString() {
            return "DAY UNIT";
        }
    };
    public static final IlvTimeUnit WEEK = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.WEEK.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.weekFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(3, 1);
            return calendar;
        }

        public double getMillis() {
            return 6.048E8;
        }

        public String getFormatString() {
            return this.a == null ? "'W'w" : this.a;
        }

        public String toString() {
            return "WEEK UNIT";
        }
    };
    public static final IlvTimeUnit MONTH = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.MONTH.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.monthFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(2, 1);
            return calendar;
        }

        public double getMillis() {
            return 2.592E9;
        }

        public String getFormatString() {
            return this.a == null ? "MMM yy" : this.a;
        }

        public String toString() {
            return "MONTH UNIT";
        }
    };
    public static final IlvTimeUnit QUARTER = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.QUARTER.String");
        private String b = IlvTimeUnit.a("TimeUnit.QUARTER.Format");
        private int[] c = new int[]{0, 3, 6, 9, 12};

        public Calendar previousUnitTime(Calendar calendar) {
            int n2 = calendar.get(2);
            IlvCalendarUtil.monthFloor(calendar);
            for (int i2 = 0; i2 < 4; ++i2) {
                if (n2 >= this.c[i2 + 1]) continue;
                calendar.set(2, this.c[i2]);
                break;
            }
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(2, 3);
            return calendar;
        }

        public double getMillis() {
            return 7.776E9;
        }

        public String getFormatString() {
            return this.b == null ? "yy" : this.b;
        }

        public String format(DateFormat dateFormat, Calendar calendar) {
            String string = this.a == null ? "Q" : this.a;
            for (int i2 = 0; i2 < 4; ++i2) {
                if (calendar.get(2) >= this.c[i2 + 1]) continue;
                return string + (i2 + 1) + " " + super.format(dateFormat, calendar);
            }
            return super.format(dateFormat, calendar);
        }

        public String toString() {
            return "QUARTER UNIT";
        }
    };
    public static final IlvTimeUnit YEAR = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.YEAR.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            IlvCalendarUtil.yearFloor(calendar);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(1, 1);
            return calendar;
        }

        public double getMillis() {
            return 3.1536E10;
        }

        public String getFormatString() {
            return this.a == null ? "yyyy" : this.a;
        }

        public String toString() {
            return "YEAR UNIT";
        }
    };
    public static final IlvTimeUnit DECADE = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.DECADE.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            int n2 = calendar.get(1) / 10 * 10;
            IlvCalendarUtil.yearFloor(calendar);
            calendar.set(1, n2);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(1, 10);
            return calendar;
        }

        public double getMillis() {
            return 3.1536E11;
        }

        public String getFormatString() {
            return this.a == null ? "yyyy" : this.a;
        }

        public String toString() {
            return "DECADE UNIT";
        }
    };
    public static final IlvTimeUnit CENTURY = new IlvTimeUnit(){
        private String a = IlvTimeUnit.a("TimeUnit.CENTURY.Format");

        public Calendar previousUnitTime(Calendar calendar) {
            int n2 = calendar.get(1) / 100 * 100;
            IlvCalendarUtil.yearFloor(calendar);
            calendar.set(1, n2);
            return calendar;
        }

        public Calendar incrementTime(Calendar calendar) {
            calendar.add(1, 100);
            return calendar;
        }

        public double getMillis() {
            return 3.1536E12;
        }

        public String getFormatString() {
            return this.a == null ? "yyyy" : this.a;
        }

        public String toString() {
            return "CENTURY UNIT";
        }
    };

    protected IlvTimeUnit() {
    }

    public abstract Calendar previousUnitTime(Calendar var1);

    public abstract Calendar incrementTime(Calendar var1);

    public abstract double getMillis();

    public abstract String getFormatString();

    public String format(DateFormat dateFormat, Calendar calendar) {
        return dateFormat.format(calendar.getTime());
    }

    private static String b(String string) {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = IlvTimeUnit.a();
            string2 = resourceBundle == null ? null : resourceBundle.getString(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static ResourceBundle a() {
        if (a != null) {
            return a;
        }
        try {
            a = IlvResourceUtil.getBundle("resources.timeunit", IlvTimeUnit.class, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        return a;
    }

    static /* synthetic */ String a(String string) {
        return IlvTimeUnit.b(string);
    }
}

