/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.renderer;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvColor;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDataWindow;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvLegendItem;
import ilog.views.chart.IlvPieRendererLegendItem;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvAbstractDataSet;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.event.DataSetPropertyEvent;
import ilog.views.chart.graphic.IlvDataRenderingHint;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.renderer.internal.IlvDataSetRendererProperty;
import ilog.views.chart.renderer.internal.IlvPieSliceInfo;
import ilog.views.chart.renderer.internal.IlvVirtualDataSet;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.styling.IlvDataPointStyle;
import ilog.views.chart.styling.IlvDataSetStyle;
import ilog.views.chart.util.IlvDoubleArray;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvChart3DSlice;
import ilog.views.util.IlvColorUtil;
import ilog.views.util.collections.internal.IlvIntToObjectHashMap;
import ilog.views.util.collections.internal.IlvIntToObjectMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;

public class IlvSinglePieRenderer
extends IlvSingleChartRenderer {
    static final double a = 0.0;
    static final double b = 100.0;
    static final double c = 0.0;
    static final double d = 100.0;
    public static final int DEFAULT_EXPLODE_RATIO = 20;
    private boolean e = true;
    private IlvDataInterval f;
    private IlvPieDataSet g;
    private IlvIntToObjectMap<IlvPieSliceInfo> h;
    private int i;

    public boolean has3DSupport() {
        return this.getChart() != null && this.getChart().getType() == 3;
    }

    void a(IlvSingleChartRenderer.Points points, boolean bl) {
        double d2 = this.getChart().getStartingAngle();
        double d3 = this.getChart().getAngleRange();
        IlvChart3DScene ilvChart3DScene = this.getChart().get3DView().getScene();
        IlvPieDataSet ilvPieDataSet = (IlvPieDataSet)points.getDataSet();
        Double d4 = ilvPieDataSet.getUndefValue();
        double d5 = d4 != null ? d4 : 0.0;
        double[] dArray = this.getDepths();
        IlvDataInterval ilvDataInterval = new IlvDataInterval();
        int n2 = points.size();
        Point2D point2D = this.v();
        Point2D.Double double_ = null;
        double d6 = this.w();
        IlvIntToObjectMap<IlvChart3DObject> ilvIntToObjectMap = this.l();
        ilvIntToObjectMap.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2D point2D2;
            double d7;
            double d8;
            double d9 = points.getXData(i2);
            int n3 = points.getDataIndex(i2);
            if (d4 != null && d9 == d5 || Double.isNaN(d9)) continue;
            if (n3 == 0) {
                d8 = d2;
                d7 = d2 + d3 * d9 / 100.0;
            } else {
                double d10 = ilvPieDataSet.getPreviousXData(n3);
                d8 = d2 + d3 * d10 / 100.0;
                d7 = d2 + d3 * d9 / 100.0;
            }
            if (d8 == d7) continue;
            ilvDataInterval = this.getYRange(i2, ilvDataInterval);
            int n4 = this.getExplodeRatio(n3);
            double d11 = (ilvDataInterval.getMin() - 0.0) / 100.0 * d6;
            double d12 = (ilvDataInterval.getMax() - 0.0) / 100.0 * d6;
            if (n4 > 0) {
                if (double_ == null) {
                    double_ = new Point2D.Double();
                }
                double d13 = Math.toRadians((d8 + d7) / 2.0);
                ((Point2D)double_).setLocation(point2D.getX() + Math.cos(d13) * d6 * (double)n4 / 100.0, point2D.getY() - Math.sin(d13) * d6 * (double)n4 / 100.0);
                point2D2 = double_;
            } else {
                point2D2 = point2D;
            }
            IlvChart3DSlice ilvChart3DSlice = new IlvChart3DSlice(ilvChart3DScene, point2D2, d11, d12, d8, d7, dArray, this, n3);
            ilvChart3DScene.addObject(ilvChart3DSlice);
            if (ilvChart3DSlice.getNextSlice() != null) {
                ilvChart3DScene.addObject(ilvChart3DSlice.getNextSlice());
            }
            ilvIntToObjectMap.put(n3, ilvChart3DSlice);
        }
    }

    private Point2D v() {
        Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
        return new Point2D.Double((double)rectangle.x + (double)rectangle.width / 2.0, rectangle.y + rectangle.height / 2);
    }

    private double w() {
        Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
        return Math.min((double)rectangle.width / 2.0, (double)rectangle.height / 2.0);
    }

    public IlvSinglePieRenderer() {
        this(null);
    }

    public IlvSinglePieRenderer(IlvStyle ilvStyle) {
        this(ilvStyle, 0.0, 100.0);
    }

    IlvSinglePieRenderer(IlvStyle ilvStyle, double d2, double d3) {
        super(ilvStyle);
        this.f = new IlvDataInterval(d2, d3);
    }

    int c() {
        return 1;
    }

    int d() {
        return 0;
    }

    boolean f() {
        return true;
    }

    int b() {
        return 1;
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
        super.chartConnected(ilvChart, ilvChart2);
        if (ilvChart2 != null) {
            this.x();
        }
    }

    private void x() {
        Color[] colorArray;
        if (this.getDataSource().getDataSetCount() == 0) {
            return;
        }
        int n2 = this.getDataSource().getDataSet(0).getDataCount();
        boolean bl = n2 > 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            colorArray = this.a(i2, false);
            if (colorArray == null || colorArray.getStyle() == null) continue;
            bl = false;
            break;
        }
        if (bl) {
            Color[] colorArray2 = this.getDefaultColors();
            if (colorArray2 == null) {
                this.setSliceColors(IlvColor.generateColors(n2));
            } else {
                int n3;
                colorArray = new Color[n2];
                for (n3 = 0; n3 < n2 && n3 < colorArray2.length; ++n3) {
                    colorArray[n3] = colorArray2[n3];
                }
                while (n3 < n2) {
                    colorArray[n3] = IlvColorUtil.getRandomColor();
                    ++n3;
                }
                this.setSliceColors(colorArray);
            }
        }
    }

    private IlvPieSliceInfo a(int n2, boolean bl) {
        IlvPieSliceInfo ilvPieSliceInfo = null;
        if (this.h == null) {
            if (bl) {
                ilvPieSliceInfo = new IlvPieSliceInfo();
                this.h = new IlvIntToObjectHashMap<IlvPieSliceInfo>();
                this.h.put(n2, ilvPieSliceInfo);
            }
        } else {
            ilvPieSliceInfo = this.h.get(n2);
            if (bl && ilvPieSliceInfo == null) {
                ilvPieSliceInfo = new IlvPieSliceInfo();
                this.h.put(n2, ilvPieSliceInfo);
            }
        }
        return ilvPieSliceInfo;
    }

    public void setSliceStyle(int n2, IlvStyle ilvStyle) {
        this.a(n2, true).setStyle(ilvStyle);
    }

    public final IlvStyle getSliceStyle(int n2) {
        IlvPieSliceInfo ilvPieSliceInfo = this.a(n2, false);
        return ilvPieSliceInfo == null ? this.getStyle() : ilvPieSliceInfo.getStyle();
    }

    IlvStyle b(IlvDataSet ilvDataSet, int n2) {
        return this.getSliceStyle(n2).setStrokeOn(this.isStrokeOn());
    }

    public void applyDataSetStyle(IlvDataSetStyle ilvDataSetStyle) {
        super.applyDataSetStyle(ilvDataSetStyle);
        int n2 = this.getDataSource().getDataSet(0).getDataCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvDataPointStyle ilvDataPointStyle = ilvDataSetStyle.getPointStyle(i2);
            if (ilvDataPointStyle == null) continue;
            IlvStyle ilvStyle = this.getSliceStyle(i2);
            IlvStyle ilvStyle2 = ilvDataPointStyle.getStyle(this, ilvStyle);
            this.setSliceStyle(i2, ilvStyle2);
        }
    }

    public void setSliceColors(Color[] colorArray) {
        IlvStyle ilvStyle = this.getStyle();
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            IlvStyle ilvStyle2 = ilvStyle == null ? new IlvStyle(Color.black, (Paint)colorArray[i2]) : (ilvStyle.isStrokeOn() ? new IlvStyle(ilvStyle.getStrokePaint(), (Paint)colorArray[i2]) : new IlvStyle(colorArray[i2]));
            this.setSliceStyle(i2, ilvStyle2);
        }
    }

    public final boolean isStrokeOn() {
        return this.e;
    }

    public void setStrokeOn(boolean bl) {
        if (this.e == bl) {
            return;
        }
        this.e = bl;
        this.triggerChange(4);
    }

    public final boolean isExploded(int n2) {
        return this.getExplodeRatio(n2) != 0;
    }

    public final void setExploded(int n2, boolean bl) {
        this.setExplodeRatio(n2, bl ? 20 : 0);
    }

    public final int getExplodeRatio(int n2) {
        IlvPieSliceInfo ilvPieSliceInfo = this.a(n2, false);
        return ilvPieSliceInfo == null ? 0 : ilvPieSliceInfo.explodeRatio;
    }

    public void setExplodeRatio(int n2, int n3) {
        boolean bl = this.b(n2, n3);
        if (bl) {
            if (n3 >= this.i) {
                this.i = n3;
            } else {
                this.y();
            }
            if (this.getChart() != null) {
                if (this.k()) {
                    this.getChart().get3DView().getScene().invalidateAll();
                }
                this.getChart().getChartArea().revalidateLayout();
            }
        }
    }

    private boolean b(int n2, int n3) {
        if (n3 < 0 || n3 > 100) {
            throw new IllegalArgumentException("Value must be in [0..100]");
        }
        IlvPieSliceInfo ilvPieSliceInfo = this.a(n2, true);
        boolean bl = ilvPieSliceInfo.explodeRatio != n3;
        ilvPieSliceInfo.explodeRatio = n3;
        return bl;
    }

    public void setExplodeRatio(int n2) {
        if (this.getDataSource().getDataSetCount() == 0) {
            return;
        }
        boolean bl = false;
        int n3 = this.getDataSource().getDataSet(0).getDataCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.b(i2, n2)) continue;
            bl = true;
        }
        if (bl) {
            this.y();
            if (this.getChart() != null) {
                this.getChart().getChartArea().revalidateLayout();
            }
        }
    }

    public double getSlicePercent(int n2) {
        return this.t().a(n2);
    }

    public double getPartialSum(int n2) {
        return this.t().b(n2);
    }

    void a(int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException("First slice must be before last slice");
        }
        if (this.getChart() != null) {
            if (n3 >= this.t().getDataCount()) {
                throw new IllegalArgumentException("No such slice: " + n3);
            }
            double d2 = n2 == 0 ? 0.0 : this.t().getXData(n2 - 1);
            this.j().setVisibleRange(d2, this.t().getXData(n3));
        }
    }

    private void y() {
        int n2 = 0;
        if (this.h != null) {
            Iterator<IlvPieSliceInfo> iterator = this.h.values().iterator();
            while (iterator.hasNext()) {
                n2 = Math.max(iterator.next().explodeRatio, n2);
            }
        }
        this.i = n2;
    }

    public Insets getPreferredMargins() {
        IlvDataPoints ilvDataPoints;
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.r() && (ilvDataPoints = this.a((Rectangle)null)) != null) {
            IlvSingleChartRenderer.Points points = this.a(ilvDataPoints);
            if (points.size() > 0) {
                Rectangle2D.Double double_ = new Rectangle2D.Double();
                this.a(points, double_);
                Rectangle rectangle = this.getPlotRect();
                Rectangle rectangle2 = IlvGraphicUtil.toRectangle(double_, null);
                if (!rectangle2.isEmpty()) {
                    insets.left = Math.max(0, rectangle.x - rectangle2.x + 1);
                    insets.right = Math.max(0, rectangle2.x + rectangle2.width - rectangle.width - rectangle.x + 1);
                    insets.top = Math.max(0, rectangle.y - rectangle2.y + 1);
                    insets.bottom = Math.max(0, rectangle2.y + rectangle2.height - rectangle.height - rectangle.y + 1);
                }
            }
            this.a(points);
        }
        return insets;
    }

    protected void dataSetsRemoved(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        super.dataSetsRemoved(n2, n3, ilvDataSetArray);
        if (this.getDataSource().getDataSetCount() == 0) {
            this.h.clear();
        }
    }

    protected void dataSetsAdded(int n2, int n3, IlvDataSet[] ilvDataSetArray) {
        super.dataSetsAdded(n2, n3, ilvDataSetArray);
        if (this.getDataSource().getDataSetCount() == 1) {
            this.e();
            this.x();
        }
    }

    void e() {
        IlvDataSet ilvDataSet = this.u();
        this.g = new IlvPieDataSet(ilvDataSet);
        if (this.a(ilvDataSet, this.g) && this.getChart() != null) {
            this.getChart().updateDataRange();
        }
    }

    final IlvPieDataSet t() {
        return (IlvPieDataSet)this.d(0);
    }

    final IlvDataSet u() {
        return this.getDataSource().getDataSet(0);
    }

    void a(IlvSingleChartRenderer.Points points, IlvSingleChartRenderer.ItemAction itemAction) {
        int n2 = points.size();
        IlvChartProjector ilvChartProjector = this.getChart().getProjector();
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        IlvDataWindow ilvDataWindow = new IlvDataWindow(0.0, 0.0, 0.0, 0.0);
        PieItem pieItem = new PieItem();
        boolean bl = this.s();
        int[] nArray = points.getIndices();
        double[] dArray = points.getXData();
        IlvPieDataSet ilvPieDataSet = (IlvPieDataSet)points.getDataSet();
        IlvDisplayPoint ilvDisplayPoint = new IlvDisplayPoint(this, ilvPieDataSet);
        Double d2 = ilvPieDataSet.getUndefValue();
        double d3 = d2 != null ? d2 : 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            double d4 = dArray[i2];
            if (d2 != null && d4 == d3 || Double.isNaN(d4)) continue;
            if (n3 == 0) {
                ilvDataWindow.xRange.set(0.0, d4);
            } else {
                double d5 = ilvPieDataSet.getPreviousXData(n3);
                ilvDataWindow.xRange.set(d5, d4);
            }
            if (ilvDataWindow.xRange.isEmpty()) continue;
            ilvDataWindow.yRange = this.getYRange(i2, ilvDataWindow.yRange);
            Rectangle rectangle = this.a(n3, ilvDataWindow.xRange.getMiddle(), ilvDataWindow.yRange);
            pieItem.a = ilvChartProjector.getShape(ilvDataWindow, rectangle, ilvCoordinateSystem);
            IlvStyle ilvStyle = this.getSliceStyle(n3);
            if (bl) {
                ilvDisplayPoint.dataSet = ilvPieDataSet;
                ilvDisplayPoint.set(n3, 0.0, 0.0);
                IlvDataRenderingHint ilvDataRenderingHint = this.b(ilvDisplayPoint);
                if (ilvDataRenderingHint != null) {
                    ilvStyle = ilvDataRenderingHint.getStyle(ilvDisplayPoint, ilvStyle);
                }
            }
            if (ilvStyle == null) continue;
            itemAction.processItem(points, i2, pieItem, ilvStyle);
        }
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        IlvDataSet ilvDataSet = ilvDisplayPoint.getDataSet();
        IlvVirtualDataSet ilvVirtualDataSet = IlvDataSetRendererProperty.getVirtualDataSet(this, ilvDataSet);
        if (ilvVirtualDataSet != null) {
            ilvDisplayPoint = (IlvDisplayPoint)ilvDisplayPoint.clone();
            ilvVirtualDataSet.map(ilvDisplayPoint);
            ilvDataSet = ilvVirtualDataSet;
        }
        if (this.k()) {
            IlvChart3DObject ilvChart3DObject = this.e(ilvDisplayPoint.getIndex());
            if (ilvChart3DObject != null) {
                return ilvChart3DObject.computeDataLabelLocation(ilvDisplayPoint, dimension);
            }
            return new Point(IlvGraphicUtil.toInt(ilvDisplayPoint.getXCoord()), IlvGraphicUtil.toInt(ilvDisplayPoint.getYCoord()));
        }
        IlvChartProjector ilvChartProjector = this.getChart().getProjector();
        IlvDataInterval ilvDataInterval = new IlvDataInterval();
        this.getYRange(ilvDisplayPoint.getIndex(), ilvDataInterval);
        double d2 = ilvDisplayPoint.getIndex() == 0 ? 0.0 : ilvDataSet.getXData(ilvDisplayPoint.getIndex() - 1);
        d2 = (d2 + ilvDataSet.getXData(ilvDisplayPoint.getIndex())) / 2.0;
        Rectangle rectangle = this.a(ilvDisplayPoint.getIndex(), d2, ilvDataInterval);
        if (this.getDataLabelLayout() == 2) {
            IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(d2, ilvDataInterval.getMax());
            ilvChartProjector.toDisplay(ilvDoublePoints, rectangle, this.getCoordinateSystem());
            double d3 = ilvDoublePoints.getX(0);
            double d4 = ilvDoublePoints.getY(0);
            ilvDoublePoints.dispose();
            IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(d3, d4);
            ilvChartProjector.shiftAlongAxis(rectangle, this.i(), ilvDoublePoint, 4.0);
            double d5 = IlvGraphicUtil.pointAngleDeg(d3, d4, ilvDoublePoint.x, ilvDoublePoint.y);
            ilvDoublePoint = IlvGraphicUtil.computeTextLocation(ilvDoublePoint, d5, 6, dimension.width, dimension.height);
            return new Point(ilvDoublePoint.xFloor(), ilvDoublePoint.yFloor());
        }
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(d2, ilvDataInterval.getMiddle());
        this.getChart().getProjector().toDisplay(ilvDoublePoints, rectangle, this.getCoordinateSystem());
        double d6 = ilvDoublePoints.getX(0);
        double d7 = ilvDoublePoints.getY(0);
        ilvDoublePoints.dispose();
        return new Point(IlvGraphicUtil.toInt(d6), IlvGraphicUtil.toInt(d7));
    }

    public String computeDataLabel(IlvDataSetPoint ilvDataSetPoint) {
        if (this.getDataLabeling() == 5) {
            double d2 = this.t().a(ilvDataSetPoint.getIndex());
            if (this.getChart() != null) {
                String string = this.getChart().formatYValue(0, d2);
                return string == null ? null : string + "%";
            }
            return NumberFormat.getInstance().format(d2) + "%";
        }
        return super.computeDataLabel(ilvDataSetPoint);
    }

    Rectangle a(int n2, double d2, IlvDataInterval ilvDataInterval) {
        Rectangle rectangle = this.getPlotRect();
        int n3 = this.getExplodeRatio(n2);
        if (n3 != 0) {
            IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(2);
            ilvDoublePoints.add(d2, ilvDataInterval.getMin());
            ilvDoublePoints.add(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0) + ilvDataInterval.getLength() * (double)n3 / 100.0);
            this.getChart().getProjector().toDisplay(ilvDoublePoints, rectangle, this.getCoordinateSystem());
            rectangle = (Rectangle)rectangle.clone();
            rectangle.translate(IlvGraphicUtil.toInt(ilvDoublePoints.getX(1) - ilvDoublePoints.getX(0)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(1) - ilvDoublePoints.getY(0)));
            ilvDoublePoints.dispose();
        }
        return rectangle;
    }

    public IlvDataInterval getYRange(int n2, IlvDataInterval ilvDataInterval) {
        if (ilvDataInterval == null) {
            ilvDataInterval = new IlvDataInterval();
        }
        if (this.i == 0) {
            ilvDataInterval.set(this.f.getMin(), this.f.getMax());
        } else {
            double d2 = 1.0 / (1.0 + (double)this.i / 100.0);
            ilvDataInterval.set(this.f.getMin(), this.f.getMin() + this.f.getLength() * d2);
        }
        return ilvDataInterval;
    }

    void a(IlvDataInterval ilvDataInterval) {
        this.f = new IlvDataInterval(ilvDataInterval);
    }

    double b(int n2) {
        return this.f.getMax();
    }

    public String getLegendText(IlvLegendItem ilvLegendItem) {
        String string;
        if (ilvLegendItem instanceof IlvPieRendererLegendItem) {
            int n2 = ((IlvPieRendererLegendItem)ilvLegendItem).getDataIndex();
            IlvPieSliceInfo ilvPieSliceInfo = this.a(n2, false);
            String string2 = string = ilvPieSliceInfo == null ? null : ilvPieSliceInfo.getText();
            if (string == null && n2 < this.u().getDataCount()) {
                string = this.u().getDataLabel(n2);
            }
        } else {
            string = super.getLegendText(ilvLegendItem);
        }
        return string;
    }

    public IlvLegendItem[] createLegendItems() {
        if (!this.isViewable() || !this.isVisibleInLegend()) {
            return null;
        }
        int n2 = this.getDataSource().getDataSet(0).getDataCount();
        if (n2 == 0) {
            return null;
        }
        IlvLegendItem[] ilvLegendItemArray = new IlvLegendItem[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ilvLegendItemArray[i2] = new IlvPieRendererLegendItem(i2, this);
        }
        return ilvLegendItemArray;
    }

    public void drawLegendSymbol(IlvLegendItem ilvLegendItem, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (ilvLegendItem instanceof IlvPieRendererLegendItem) {
            IlvStyle ilvStyle = this.getSliceStyle(((IlvPieRendererLegendItem)ilvLegendItem).getDataIndex());
            int n6 = Math.min(n4, n5);
            ilvStyle.renderRect(graphics, n2 + (n4 - n6) / 2, n3 + (n5 - n6) / 2, n6, n6);
            if (!ilvStyle.isStrokeOn()) {
                this.getLegendStyle().drawRect(graphics, n2 + (n4 - n6) / 2, n3 + (n5 - n6) / 2, n6, n6);
            }
        } else {
            super.drawLegendSymbol(ilvLegendItem, graphics, n2, n3, n4, n5);
        }
    }

    class IlvPieDataSet
    extends IlvVirtualDataSet {
        private double a;
        private IlvDoubleArray b = new IlvDoubleArray();

        IlvPieDataSet(IlvDataSet ilvDataSet) {
            this.setMaxDataSetCount(1);
            this.addDataSet(ilvDataSet);
        }

        public String getName() {
            if (this.getDataSetCount() == 1) {
                return this.getDataSet(0).getName();
            }
            return null;
        }

        public boolean isXValuesSorted() {
            return true;
        }

        public double getPreviousXData(int n2) {
            if (n2 == 0) {
                return 0.0;
            }
            double d2 = this.getXData(n2 - 1);
            Double d3 = this.getUndefValue();
            if (d3 != null) {
                double d4 = d3;
                int n3 = n2 - 1;
                while (d2 == d4 || Double.isNaN(d2)) {
                    if (n3 == 0) {
                        d2 = 0.0;
                        break;
                    }
                    d2 = this.getXData(--n3);
                }
            } else {
                int n4 = n2 - 1;
                while (Double.isNaN(d2)) {
                    if (n4 == 0) {
                        d2 = 0.0;
                        break;
                    }
                    d2 = this.getXData(--n4);
                }
            }
            return d2;
        }

        public void map(IlvDataSetPoint ilvDataSetPoint) {
            ilvDataSetPoint.dataSet = this;
        }

        public boolean mapsMonotonically() {
            return true;
        }

        public void unmap(IlvDataSetPoint ilvDataSetPoint) {
            if (this.getDataSetCount() == 1) {
                ilvDataSetPoint.dataSet = this.getDataSet(0);
            }
        }

        public void unmap(IlvDataSetPoint ilvDataSetPoint, IlvDoublePoint ilvDoublePoint) {
            this.unmap(ilvDataSetPoint);
            IlvDataSet ilvDataSet = ilvDataSetPoint.dataSet;
            ilvDoublePoint.x = ilvDataSetPoint.getXData();
            if (ilvDoublePoint.x > 100.0) {
                ilvDoublePoint.y = ilvDataSetPoint.getYData();
                return;
            }
            int n2 = ilvDataSet.getDataCount();
            double d2 = this.getXData(ilvDataSetPoint.index - 1);
            double d3 = ilvDoublePoint.x - d2;
            if (d3 <= 0.0) {
                ilvDoublePoint.y = 0.0;
            } else {
                double d4 = 0.0;
                double d5 = 0.0;
                Double d6 = ilvDataSet.getUndefValue();
                if (d6 != null) {
                    double d7;
                    int n3;
                    double d8 = d6;
                    for (n3 = 0; n3 < ilvDataSetPoint.index; ++n3) {
                        d7 = ilvDataSet.getYData(n3);
                        if (d7 == d8 || Double.isNaN(d7)) continue;
                        d4 += d7;
                    }
                    ++n3;
                    while (n3 < n2) {
                        d7 = ilvDataSet.getYData(n3);
                        if (d7 != d8 && !Double.isNaN(d7)) {
                            d5 += d7;
                        }
                        ++n3;
                    }
                } else {
                    double d9;
                    int n4;
                    for (n4 = 0; n4 < ilvDataSetPoint.index; ++n4) {
                        d9 = ilvDataSet.getYData(n4);
                        if (Double.isNaN(d9)) continue;
                        d4 += d9;
                    }
                    ++n4;
                    while (n4 < n2) {
                        d9 = ilvDataSet.getYData(n4);
                        if (!Double.isNaN(d9)) {
                            d5 += d9;
                        }
                        ++n4;
                    }
                }
                ilvDoublePoint.y = d3 * (d4 + d5) / (100.0 - d3);
            }
        }

        public Double getUndefValue() {
            if (this.getDataSetCount() == 0) {
                return null;
            }
            IlvDataSet ilvDataSet = this.getDataSet(0);
            return ilvDataSet != null && ilvDataSet.getUndefValue() != null ? IlvAbstractDataSet.DEFAULT_UNDEF_VALUE : null;
        }

        double a(int n2) {
            if (this.getDataSetCount() == 0) {
                return 0.0;
            }
            IlvDataSet ilvDataSet = this.getDataSet(0);
            double d2 = ilvDataSet.getYData(n2);
            Double d3 = ilvDataSet.getUndefValue();
            if (d3 != null && d2 == d3) {
                d2 = Double.NaN;
            }
            return d2 * 100.0 / this.a;
        }

        double b(int n2) {
            if (this.getDataSetCount() == 0) {
                return 0.0;
            }
            IlvDataSet ilvDataSet = this.getDataSet(0);
            double d2 = 0.0;
            for (int i2 = 0; i2 <= n2; ++i2) {
                d2 += ilvDataSet.getYData(i2);
            }
            return d2;
        }

        public double getXData(int n2) {
            return this.b.get(n2);
        }

        public double getYData(int n2) {
            return IlvSinglePieRenderer.this.f.getMax();
        }

        public void dataSetContentsChanged(DataSetContentsEvent dataSetContentsEvent) {
            super.dataSetContentsChanged(dataSetContentsEvent);
            if (dataSetContentsEvent.getType() != 1 && dataSetContentsEvent.getType() != 5) {
                boolean bl = false;
                if (dataSetContentsEvent.getType() == 6) {
                    bl = true;
                }
                this.a(0, this.getDataCount() - 1, bl);
                this.fireDataSetContentsEvent(new DataSetContentsEvent(this));
            }
            if (dataSetContentsEvent.getType() == 6 || dataSetContentsEvent.getType() == 4 || dataSetContentsEvent.getType() == 5) {
                IlvSinglePieRenderer.this.triggerChange(6);
            }
        }

        protected void dataSetPropertyChanged(DataSetPropertyEvent dataSetPropertyEvent) {
            if (dataSetPropertyEvent.getDataSet() == this.getDataSet(0)) {
                this.fireDataSetPropertyEvent(new DataSetPropertyEvent(this, dataSetPropertyEvent));
            }
        }

        protected void dataSetsChanged() {
            super.dataSetsChanged();
            int n2 = this.getDataCount();
            if (n2 > 0) {
                this.a(0, n2 - 1, true);
            }
        }

        private void a(int n2, int n3, boolean bl) {
            if (bl) {
                this.b.clear();
            }
            this.a = this.computePieData(this.b, n2, n3);
        }

        protected double computePieData(IlvDoubleArray ilvDoubleArray, int n2, int n3) {
            double d2;
            int n4;
            IlvDataSet ilvDataSet = this.getDataSet(0);
            Double d3 = ilvDataSet.getUndefValue();
            double d4 = d3 != null ? d3 : 0.0;
            int n5 = ilvDataSet.getDataCount();
            int n6 = ilvDoubleArray.size();
            double d5 = 0.0;
            double d6 = 0.0;
            for (n4 = 0; n4 < n5; ++n4) {
                d2 = ilvDataSet.getYData(n4);
                if (d3 != null && d2 == d4 || Double.isNaN(d2)) continue;
                if (n4 < n2) {
                    d6 += d2;
                }
                d5 += d2;
            }
            for (n4 = n2; n4 <= n3; ++n4) {
                d2 = ilvDataSet.getYData(n4);
                if (d3 != null && d2 == d4 || Double.isNaN(d2)) {
                    d2 = IlvAbstractDataSet.DEFAULT_UNDEF_VALUE;
                } else if (n4 == n5 - 1) {
                    d2 = 100.0;
                } else {
                    d6 += d2;
                    d2 = IlvMathUtil.clamp(d6 * (100.0 / d5), 0.0, 100.0);
                }
                if (n4 >= n6) {
                    ilvDoubleArray.add(d2);
                    continue;
                }
                ilvDoubleArray.set(n4, d2);
            }
            return d5;
        }

        protected void computeLimits(IlvDataInterval ilvDataInterval, IlvDataInterval ilvDataInterval2) {
            if (this.getDataCount() > 0) {
                ilvDataInterval.set(0.0, 100.0);
            } else {
                ilvDataInterval.empty();
            }
            ilvDataInterval2.set(IlvSinglePieRenderer.this.f.getMin(), IlvSinglePieRenderer.this.f.getMax());
        }
    }

    class PieItem
    implements IlvSingleChartRenderer.Item {
        Shape a;

        PieItem() {
        }

        public void draw(Graphics graphics, IlvStyle ilvStyle) {
            if (IlvSinglePieRenderer.this.isStrokeOn()) {
                ilvStyle.renderShape(graphics, this.a);
                if (!ilvStyle.isStrokeOn()) {
                    IlvSinglePieRenderer.this.getStyle().draw(graphics, this.a);
                }
            } else if (ilvStyle.isFillOn()) {
                ilvStyle.fill(graphics, this.a);
            }
        }

        public Rectangle2D getBounds(IlvStyle ilvStyle, Rectangle2D rectangle2D) {
            return ilvStyle.getShapeBounds(this.a);
        }

        public boolean contains(IlvStyle ilvStyle, double d2, double d3) {
            return ilvStyle.shapeContains(this.a, d2, d3);
        }

        public IlvIMapArea getMapArea(IlvIMapDefinition ilvIMapDefinition, IlvStyle ilvStyle, IlvIMapAttributes ilvIMapAttributes) {
            int n2 = 0;
            int n3 = 0;
            if (ilvIMapDefinition.isChartOrigin()) {
                Rectangle rectangle = IlvSinglePieRenderer.this.m();
                n2 = rectangle.x;
                n3 = rectangle.y;
            }
            return new IlvIMapArea(this.a, (double)n2, (double)n3, ilvIMapAttributes);
        }
    }
}

