/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolylineLinkImage;
import ilog.views.graphlayout.IlvConnectedComponentAdapter;
import ilog.views.graphlayout.IlvConnectedComponentCollectionAdapter;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.IlvGrapherAdapter;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.IlvLayoutProvider;
import ilog.views.graphlayout.internalutil.IlvArrayStableSort;
import ilog.views.graphlayout.internalutil.IlvGraphModelDFS;
import ilog.views.graphlayout.internalutil.IlvUnsyncVector;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.linkconnector.IlvFreeLinkConnector;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class IlvGraphLayoutUtil {
    private static final String a = "__GLayoutUtilConnCompFinder";
    private static final String b = "__GLayoutUtilTestTree";
    private static final String c = "__GLayoutUtilCountNodesConnComp";
    private static FreeLinkConnectorFactory d = null;

    private IlvGraphLayoutUtil() {
    }

    public static void EnsureAppropriateLinkTypes(IlvGraphLayout ilvGraphLayout, boolean bl) {
        if (ilvGraphLayout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel instanceof IlvGrapherAdapter) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkTypes((IlvGrapherAdapter)ilvGraphModel, ilvGraphLayout, bl, false, false, true);
        }
    }

    public static void EnsureAppropriateLinkTypes(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3) {
        IlvGraphLayoutUtil.EnsureAppropriateLinkTypes(ilvGrapherAdapter, ilvGraphLayout, bl, bl2, bl3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EnsureAppropriateLinkTypes(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        IlvGrapher ilvGrapher = null;
        if (bl2 && ilvGrapherAdapter != null && (ilvGrapher = ilvGrapherAdapter.getGrapher()) != null) {
            ilvGrapher.setContentsAdjusting(true);
        }
        try {
            IlvGraphLayoutUtil.a(ilvGraphLayout, ilvGrapherAdapter, bl, bl2, bl3, bl4);
        }
        finally {
            if (ilvGrapher != null) {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    public static void EnsureAppropriateLinkConnectors(IlvGraphLayout ilvGraphLayout, boolean bl) {
        if (ilvGraphLayout == null) {
            throw new IllegalArgumentException("layout cannot be null");
        }
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel instanceof IlvGrapherAdapter) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors((IlvGrapherAdapter)ilvGraphModel, ilvGraphLayout, bl, false, true);
        }
    }

    public static void EnsureAppropriateLinkConnectors(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2) {
        IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors(ilvGrapherAdapter, ilvGraphLayout, bl, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EnsureAppropriateLinkConnectors(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3) {
        if (ilvGrapherAdapter == null) {
            throw new IllegalArgumentException("grapherAdapter cannot be null");
        }
        IlvGrapher ilvGrapher = null;
        if (bl2 && ilvGrapherAdapter != null && (ilvGrapher = ilvGrapherAdapter.getGrapher()) != null) {
            ilvGrapher.setContentsAdjusting(true);
        }
        try {
            IlvGraphLayoutUtil.a(ilvGrapherAdapter, ilvGraphLayout, bl, bl2, bl3);
        }
        finally {
            if (ilvGrapher != null) {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    private static void a(IlvGrapherAdapter ilvGrapherAdapter, IlvGraphLayout ilvGraphLayout, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            Enumeration enumeration = ilvGrapherAdapter.getSubgraphs();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                IlvGraphModel ilvGraphModel = ilvGrapherAdapter.getGraphModel(e2);
                if (!(ilvGraphModel instanceof IlvGrapherAdapter)) continue;
                IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors((IlvGrapherAdapter)ilvGraphModel, ilvGraphLayout, bl, true, bl3);
            }
        }
        if (bl) {
            IlvGraphLayoutUtil.a(ilvGrapherAdapter, false, bl3);
        } else {
            IlvGraphLayoutUtil.a(ilvGrapherAdapter, bl3);
        }
    }

    public static void EnsureAppropriateLinks(IlvGraphModel ilvGraphModel, IlvLayoutProvider ilvLayoutProvider) {
        IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvGraphModel, ilvLayoutProvider, true);
    }

    public static void EnsureAppropriateLinks(IlvGraphModel ilvGraphModel, IlvLayoutProvider ilvLayoutProvider, boolean bl) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        if (ilvLayoutProvider == null) {
            throw new IllegalArgumentException("layoutProvider cannot be null");
        }
        IlvGraphModel ilvGraphModel2 = ilvGraphModel.getRootModel() != null ? ilvGraphModel.getRootModel() : ilvGraphModel;
        IlvGraphLayoutUtil.a(ilvGraphModel2, ilvGraphModel, ilvLayoutProvider, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGraphModel ilvGraphModel, IlvGraphModel ilvGraphModel2, IlvLayoutProvider ilvLayoutProvider, boolean bl) {
        Object object;
        boolean bl2 = ilvGraphModel2.isLinkCheckEnabled();
        boolean bl3 = ilvGraphModel2.isConnectionPointCheckEnabled();
        try {
            ilvGraphModel2.setLinkCheckEnabled(true);
            ilvGraphModel2.setConnectionPointCheckEnabled(true);
            object = ilvLayoutProvider.getGraphLayout(ilvGraphModel2);
            if (object != null) {
                ((IlvGraphLayout)object).checkAppropriateLinks();
            }
        }
        catch (IlvInappropriateLinkException ilvInappropriateLinkException) {
            IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvInappropriateLinkException, bl);
        }
        finally {
            ilvGraphModel2.setLinkCheckEnabled(bl2);
            ilvGraphModel2.setConnectionPointCheckEnabled(bl3);
        }
        object = ilvGraphModel2.getSubgraphs();
        while (object.hasMoreElements()) {
            IlvGraphLayoutUtil.a(ilvGraphModel, ilvGraphModel.getGraphModel(object.nextElement()), ilvLayoutProvider, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void EnsureAppropriateLinks(IlvGraphLayout ilvGraphLayout, boolean bl) {
        if (ilvGraphLayout == null) {
            return;
        }
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("layout must be attached to graph model");
        }
        boolean bl2 = ilvGraphModel.isLinkCheckEnabled();
        boolean bl3 = ilvGraphModel.isConnectionPointCheckEnabled();
        try {
            ilvGraphModel.setLinkCheckEnabled(true);
            ilvGraphModel.setConnectionPointCheckEnabled(true);
            ilvGraphLayout.checkAppropriateLinks();
        }
        catch (IlvInappropriateLinkException ilvInappropriateLinkException) {
            IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvInappropriateLinkException, bl);
        }
        finally {
            ilvGraphModel.setLinkCheckEnabled(bl2);
            ilvGraphModel.setConnectionPointCheckEnabled(bl3);
        }
    }

    public static void EnsureAppropriateLinks(IlvInappropriateLinkException ilvInappropriateLinkException) {
        IlvGraphLayoutUtil.EnsureAppropriateLinks(ilvInappropriateLinkException, true);
    }

    public static void EnsureAppropriateLinks(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvInappropriateLinkException ilvInappropriateLinkException2;
        for (ilvInappropriateLinkException2 = ilvInappropriateLinkException; ilvInappropriateLinkException2 != null; ilvInappropriateLinkException2 = (IlvInappropriateLinkException)ilvInappropriateLinkException2.getNext()) {
            IlvGraphLayoutUtil.a(ilvInappropriateLinkException2, bl);
        }
        for (ilvInappropriateLinkException2 = ilvInappropriateLinkException; ilvInappropriateLinkException2 != null; ilvInappropriateLinkException2 = (IlvInappropriateLinkException)ilvInappropriateLinkException2.getNext()) {
            IlvGraphLayoutUtil.b(ilvInappropriateLinkException2, bl);
        }
        for (ilvInappropriateLinkException2 = ilvInappropriateLinkException; ilvInappropriateLinkException2 != null; ilvInappropriateLinkException2 = (IlvInappropriateLinkException)ilvInappropriateLinkException2.getNext()) {
            IlvGraphLayoutUtil.c(ilvInappropriateLinkException2, bl);
        }
    }

    private static void a(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvGraphLayout ilvGraphLayout = ilvInappropriateLinkException.getGraphLayout();
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        if (ilvGraphLayout.getGrapher() == null) {
            return;
        }
        IlvGraphLayoutUtil.a(ilvGraphLayout, (IlvGrapherAdapter)ilvGraphModel, ilvInappropriateLinkException, bl);
    }

    private static void a(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        boolean bl2;
        int n2 = ilvInappropriateLinkException.getType();
        boolean bl3 = (n2 & 1) != 0;
        boolean bl4 = (n2 & 2) != 0;
        boolean bl5 = (n2 & 8) != 0;
        boolean bl6 = bl2 = (n2 & 0x10) != 0;
        if (bl3 || bl4) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkTypes(ilvGrapherAdapter, ilvGraphLayout, !bl4, false, false, bl);
        }
        if (bl5 || bl2) {
            IlvGraphLayoutUtil.EnsureAppropriateLinkTypes(ilvGrapherAdapter, ilvGraphLayout, !bl2, false, true, bl);
        }
    }

    private static void b(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvGraphLayout ilvGraphLayout = ilvInappropriateLinkException.getGraphLayout();
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        if (ilvGraphLayout.getGrapher() == null) {
            return;
        }
        IlvGraphLayoutUtil.b(ilvGraphLayout, (IlvGrapherAdapter)ilvGraphModel, ilvInappropriateLinkException, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void b(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        boolean bl2;
        int n2 = ilvInappropriateLinkException.getType();
        boolean bl3 = (n2 & 4) != 0;
        boolean bl4 = bl2 = (n2 & 0x20) != 0;
        if (bl3 || bl2) {
            IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
            ilvGrapher.setContentsAdjusting(true);
            try {
                boolean bl5 = !bl2;
                Enumeration enumeration = ilvGrapherAdapter.getNodes();
                while (enumeration.hasMoreElements()) {
                    IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                    if (bl5) {
                        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
                        if (ilvLinkConnector instanceof IlvPinLinkConnector) continue;
                        IlvGraphLayoutUtil.a(ilvGraphic, bl);
                        continue;
                    }
                    IlvGraphLayoutUtil.a(ilvGraphic, bl);
                }
            }
            finally {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    private static void c(IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        IlvGraphLayout ilvGraphLayout = ilvInappropriateLinkException.getGraphLayout();
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        if (ilvGraphLayout.getGrapher() == null) {
            return;
        }
        IlvGraphLayoutUtil.c(ilvGraphLayout, (IlvGrapherAdapter)ilvGraphModel, ilvInappropriateLinkException, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void c(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, IlvInappropriateLinkException ilvInappropriateLinkException, boolean bl) {
        boolean bl2;
        int n2 = ilvInappropriateLinkException.getType();
        boolean bl3 = (n2 & 4) != 0;
        boolean bl4 = bl2 = (n2 & 0x20) != 0;
        if (bl3 || bl2) {
            boolean bl5 = !bl2;
            IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
            ilvGrapher.setContentsAdjusting(true);
            try {
                IlvGraphLayoutUtil.a(ilvGrapherAdapter.getLinks(), ilvGrapherAdapter, bl5, bl);
                IlvGraphLayoutUtil.a(ilvGrapherAdapter.getInterGraphLinks(), ilvGrapherAdapter, bl5, bl);
            }
            finally {
                ilvGrapher.setContentsAdjusting(false);
            }
        }
    }

    public static void EnsureAppropriateLinks(IlvGraphLayout ilvGraphLayout, IlvInappropriateLinkException ilvInappropriateLinkException) {
        IlvGraphModel ilvGraphModel = ilvInappropriateLinkException.getGraphModel();
        if (ilvGraphModel == null) {
            ilvGraphModel = ilvGraphLayout.getGraphModel();
        }
        if (!(ilvGraphModel instanceof IlvGrapherAdapter)) {
            return;
        }
        IlvGrapherAdapter ilvGrapherAdapter = (IlvGrapherAdapter)ilvGraphModel;
        IlvGraphLayoutUtil.a(ilvGraphLayout, ilvGrapherAdapter, ilvInappropriateLinkException, true);
        IlvGraphLayoutUtil.b(ilvGraphLayout, ilvGrapherAdapter, ilvInappropriateLinkException, true);
        IlvGraphLayoutUtil.c(ilvGraphLayout, ilvGrapherAdapter, ilvInappropriateLinkException, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGrapherAdapter ilvGrapherAdapter, boolean bl) {
        Enumeration enumeration = ilvGrapherAdapter.getNodes();
        IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
        ilvGrapher.setContentsAdjusting(true);
        try {
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                IlvGraphLayoutUtil.a(ilvGrapher, ilvGraphic, bl);
            }
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getLinks(), bl);
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getInterGraphLinks(), bl);
        }
        finally {
            ilvGrapher.setContentsAdjusting(false);
        }
    }

    private static void a(Enumeration enumeration, boolean bl) {
        while (enumeration.hasMoreElements()) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)enumeration.nextElement();
            IlvGraphLayoutUtil.b(ilvLinkImage, true, bl);
            IlvGraphLayoutUtil.b(ilvLinkImage, false, bl);
        }
    }

    private static void b(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, bl);
        IlvLinkConnector ilvLinkConnector2 = null;
        if (ilvLinkConnector instanceof IlvFreeLinkConnector && !(ilvLinkConnector instanceof IlvClippingLinkConnector) && (ilvLinkConnector2 = IlvLinkConnector.GetAttached(ilvLinkImage, bl)) != null) {
            ilvLinkConnector2.detach(ilvLinkImage, bl, bl2);
        }
    }

    private static void a(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, boolean bl) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvFreeLinkConnector)object).disconnectAllLinks();
            }
        };
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
        if (ilvLinkConnector instanceof IlvFreeLinkConnector && !(ilvLinkConnector instanceof IlvClippingLinkConnector)) {
            ilvGrapher.applyToObject(ilvGraphic, ilvApplyObject, ilvLinkConnector, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2) {
        Enumeration enumeration = ilvGrapherAdapter.getNodes();
        IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
        ilvGrapher.setContentsAdjusting(true);
        try {
            while (enumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = (IlvGraphic)enumeration.nextElement();
                if (bl) {
                    IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
                    if (ilvLinkConnector instanceof IlvPinLinkConnector) continue;
                    IlvGraphLayoutUtil.a(ilvGraphic, bl2);
                    continue;
                }
                IlvGraphLayoutUtil.a(ilvGraphic, bl2);
            }
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getLinks(), ilvGrapherAdapter, bl, bl2);
            IlvGraphLayoutUtil.a(ilvGrapherAdapter.getInterGraphLinks(), ilvGrapherAdapter, bl, bl2);
        }
        finally {
            ilvGrapher.setContentsAdjusting(false);
        }
    }

    private static void a(Enumeration enumeration, IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2) {
        while (enumeration.hasMoreElements()) {
            IlvLinkImage ilvLinkImage = (IlvLinkImage)enumeration.nextElement();
            IlvGraphLayoutUtil.a(ilvLinkImage, ilvGrapherAdapter, true, bl, bl2);
            IlvGraphLayoutUtil.a(ilvLinkImage, ilvGrapherAdapter, false, bl, bl2);
        }
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            IlvLinkConnector ilvLinkConnector;
            if (ilvGrapherAdapter.hasPinnedConnectionPoint(ilvLinkImage, bl)) {
                return;
            }
            IlvLinkConnector ilvLinkConnector2 = IlvLinkConnector.GetAttached(ilvLinkImage, bl);
            if (ilvLinkConnector2 != null && !(ilvLinkConnector2 instanceof IlvFreeLinkConnector)) {
                ilvLinkConnector2.detach(ilvLinkImage, bl, bl3);
            }
            if ((ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, bl)) instanceof IlvPinLinkConnector) {
                IlvGraphLayoutUtil.a(ilvLinkImage, bl, bl3);
            } else if (ilvLinkConnector == null || !(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
                IlvGraphLayoutUtil.a(ilvLinkImage, bl, bl3);
            }
        } else {
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, bl);
            if (ilvLinkConnector == null || !(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
                IlvLinkConnector ilvLinkConnector3 = IlvLinkConnector.GetAttached(ilvLinkImage, bl);
                if (ilvLinkConnector3 != null && !(ilvLinkConnector3 instanceof IlvFreeLinkConnector)) {
                    ilvLinkConnector3.detach(ilvLinkImage, bl, bl3);
                }
                if ((ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, bl)) == null || !(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
                    IlvGraphLayoutUtil.a(ilvLinkImage, bl, bl3);
                }
            }
        }
    }

    static void a(IlvGraphic ilvGraphic, boolean bl) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
        if (!(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
            ilvLinkConnector = d != null ? d.create(ilvGraphic) : new IlvFreeLinkConnector();
            ilvLinkConnector.attach(ilvGraphic, bl);
        }
    }

    static void a(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvLinkImage, bl);
        if (!(ilvLinkConnector instanceof IlvFreeLinkConnector)) {
            if (d != null) {
                IlvGraphic ilvGraphic = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
                ilvLinkConnector = d.create(ilvGraphic);
            } else {
                ilvLinkConnector = new IlvFreeLinkConnector();
            }
            ilvLinkConnector.attach(ilvLinkImage, bl, bl2);
        }
    }

    public static void SetFreeLinkConnectorFactory(FreeLinkConnectorFactory freeLinkConnectorFactory) {
        d = freeLinkConnectorFactory;
    }

    public static FreeLinkConnectorFactory GetFreeLinkConnectorFactory() {
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvGraphLayout ilvGraphLayout, IlvGrapherAdapter ilvGrapherAdapter, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Enumeration enumeration;
        if (ilvGrapherAdapter == null) {
            throw new IllegalArgumentException("grapherAdapter cannot be null");
        }
        IlvGrapher ilvGrapher = ilvGrapherAdapter.getGrapher();
        if (ilvGrapher == null) {
            return;
        }
        if (bl2) {
            enumeration = ilvGrapherAdapter.getSubgraphs();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                object = ilvGrapherAdapter.getGraphModel(e2);
                if (!(object instanceof IlvGrapherAdapter)) continue;
                IlvGraphLayoutUtil.a(ilvGraphLayout, (IlvGrapherAdapter)object, bl, true, bl3, bl4);
            }
        }
        if ((enumeration = bl3 ? ilvGrapherAdapter.getInterGraphLinks() : ilvGrapherAdapter.getLinks()) == null || !enumeration.hasMoreElements()) {
            return;
        }
        boolean bl5 = ilvGraphLayout != null && ilvGraphLayout.supportsPreserveFixedLinks() && ilvGraphLayout.isPreserveFixedLinks();
        object = new IlvUnsyncVector(500, 500);
        Object var10_11 = null;
        while (enumeration.hasMoreElements()) {
            var10_11 = enumeration.nextElement();
            if (bl5 && ilvGraphLayout.isFixed(var10_11) || ilvGrapherAdapter.isReshapeableLink(var10_11, bl)) continue;
            ((IlvUnsyncVector)object).addElement(var10_11);
        }
        if (((IlvUnsyncVector)object).size() == 0) {
            return;
        }
        int n2 = ((IlvUnsyncVector)object).size();
        ilvGrapher.setContentsAdjusting(true);
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvLinkImage ilvLinkImage = (IlvLinkImage)((IlvUnsyncVector)object).elementAt(i2);
                IlvPolylineLinkImage ilvPolylineLinkImage = new IlvPolylineLinkImage(ilvLinkImage.getFrom(), ilvLinkImage.getTo(), ilvLinkImage.isOriented(), null);
                IlvGraphLayoutUtil.a(ilvLinkImage, ilvPolylineLinkImage);
                IlvGraphLayoutUtil.a(ilvGrapher, ilvLinkImage, ilvPolylineLinkImage, bl4);
            }
        }
        finally {
            ilvGrapher.setContentsAdjusting(false);
        }
    }

    private static void a(IlvGrapher ilvGrapher, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl) {
        IlvGraphLayoutUtil.a(ilvLinkImage, ilvLinkImage2, true, bl);
        IlvGraphLayoutUtil.a(ilvLinkImage, ilvLinkImage2, false, bl);
        ilvGrapher.replaceObject(ilvLinkImage, ilvLinkImage2, bl);
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl, boolean bl2) {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get(ilvLinkImage, bl);
        if (ilvLinkConnector != null) {
            IlvLinkConnector ilvLinkConnector2 = IlvLinkConnector.GetAttached(ilvLinkImage, bl);
            if (ilvLinkConnector2 != null) {
                IlvGraphLayoutUtil.a(ilvLinkConnector2, ilvLinkImage, ilvLinkImage2, bl, bl2, false);
            } else {
                IlvGraphLayoutUtil.a(ilvLinkConnector, ilvLinkImage, ilvLinkImage2, bl, bl2, true);
            }
        }
    }

    private static void a(IlvLinkConnector ilvLinkConnector, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, boolean bl, boolean bl2, boolean bl3) {
        IlvPoint ilvPoint = ilvLinkConnector.getConnectionPoint(ilvLinkImage, bl, null);
        if (!bl3) {
            ilvLinkConnector.disconnectLink(ilvLinkImage, bl);
            ilvLinkConnector.detach(ilvLinkImage, bl, bl2);
            ilvLinkConnector.attach(ilvLinkImage2, bl, bl2);
        }
        ilvLinkConnector.connectLink(ilvLinkImage2, ilvPoint, bl, null);
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2) {
        ilvLinkImage2.setForeground(ilvLinkImage.getForeground());
        ilvLinkImage2.setLineWidth(ilvLinkImage.getLineWidth());
        ilvLinkImage2.setLineJoin(ilvLinkImage.getLineJoin());
        ilvLinkImage2.setMaximumLineWidth(ilvLinkImage.getMaximumLineWidth());
        ilvLinkImage2.setEndCap(ilvLinkImage.getEndCap());
        ilvLinkImage2.setLineStyle(ilvLinkImage.getLineStyle());
    }

    public static int GetNodeDegree(IlvGraphLayout ilvGraphLayout, IlvGraphic ilvGraphic) {
        return ilvGraphLayout.getGraphModel().getNodeDegree(ilvGraphic);
    }

    public static boolean IsTree(IlvGraphLayout ilvGraphLayout, Object object) {
        IlvGraphModel ilvGraphModel = ilvGraphLayout.getGraphModel();
        if (ilvGraphModel == null) {
            throw new RuntimeException("no attached graph");
        }
        return IlvGraphLayoutUtil.IsTree(ilvGraphModel, object);
    }

    public static boolean IsTree(IlvGraphModel ilvGraphModel, Object object) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("startNode cannot be null");
        }
        TestTree testTree = new TestTree(ilvGraphModel, b);
        return testTree.a(object);
    }

    public static boolean IsConnected(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        Enumeration enumeration = ilvGraphModel.getNodes();
        if (!enumeration.hasMoreElements()) {
            return true;
        }
        if (!ilvGraphModel.getLinks().hasMoreElements()) {
            enumeration.nextElement();
            return !enumeration.hasMoreElements();
        }
        CountNodesInConnectedComponent countNodesInConnectedComponent = new CountNodesInConnectedComponent(ilvGraphModel, c);
        int n2 = countNodesInConnectedComponent.a(enumeration.nextElement());
        try {
            for (int i2 = 1; i2 < n2; ++i2) {
                enumeration.nextElement();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error during connectivity test: there are " + n2 + " nodes in a connected component and only " + ilvGraphModel.getNodesCount() + " nodes in the graph model " + ilvGraphModel);
        }
        return !enumeration.hasMoreElements();
    }

    public static IlvGraphModel GetConnectedComponents(IlvGraphModel ilvGraphModel) {
        return IlvGraphLayoutUtil.a(ilvGraphModel, false);
    }

    static IlvGraphModel a(IlvGraphModel ilvGraphModel, boolean bl) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        if (!bl && IlvGraphLayoutUtil.IsConnected(ilvGraphModel)) {
            return ilvGraphModel;
        }
        ConnectedComponentsFinder connectedComponentsFinder = new ConnectedComponentsFinder(ilvGraphModel, a);
        return connectedComponentsFinder.getConnectedComponents();
    }

    public static int ComputeNumberOfNodeOverlaps(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        int n2 = 0;
        int n3 = ilvGraphModel.getNodesCount();
        Object[] objectArray = new Object[n3];
        Enumeration enumeration = ilvGraphModel.getNodes();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n4++] = enumeration.nextElement();
        }
        for (n4 = 0; n4 < n3; ++n4) {
            Object object = objectArray[n4];
            IlvRect ilvRect = ilvGraphModel.boundingBox(object);
            for (int i2 = n4 + 1; i2 < n3; ++i2) {
                Object object2 = objectArray[i2];
                IlvRect ilvRect2 = ilvGraphModel.boundingBox(object2);
                if (!(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                ++n2;
            }
        }
        objectArray = null;
        return n2;
    }

    public static int ComputeNumberOfNodeLinkOverlaps(IlvGraphModel ilvGraphModel) {
        Object object;
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        int n2 = 0;
        int n3 = ilvGraphModel.getLinksCount();
        Object[] objectArray = new Object[n3];
        IlvRect[] ilvRectArray = new IlvRect[n3];
        Enumeration enumeration = ilvGraphModel.getLinks();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            objectArray[n4] = object;
            ilvRectArray[n4++] = ilvGraphModel.boundingBox(object);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint(), new IlvPoint(), new IlvPoint(), new IlvPoint()};
        enumeration = ilvGraphModel.getNodes();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            IlvRect ilvRect = ilvGraphModel.boundingBox(e2);
            ilvPointArray[0].x = ilvRect.x;
            ilvPointArray[0].y = ilvRect.y;
            ilvPointArray[1].x = ilvRect.x + ilvRect.width;
            ilvPointArray[1].y = ilvRect.y;
            ilvPointArray[2].x = ilvRect.x + ilvRect.width;
            ilvPointArray[2].y = ilvRect.y + ilvRect.height;
            ilvPointArray[3].x = ilvRect.x;
            ilvPointArray[3].y = ilvRect.y + ilvRect.height;
            ilvPointArray[4].x = ilvRect.x;
            ilvPointArray[4].y = ilvRect.y;
            for (n4 = 0; n4 < n3; ++n4) {
                object = objectArray[n4];
                IlvRect ilvRect2 = ilvRectArray[n4];
                if (ilvGraphModel.getFrom(object) == e2 || ilvGraphModel.getTo(object) == e2 || !(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                IlvPoint[] ilvPointArray2 = ilvGraphModel.getLinkPoints(object);
                int n5 = ilvPointArray2.length;
                block3: for (int i2 = 0; i2 < 4; ++i2) {
                    for (int i3 = 0; i3 < n5 - 1; ++i3) {
                        if (!IlvGraphLayoutUtil.a(ilvPointArray[i2], ilvPointArray[i2 + 1], ilvPointArray2[i3], ilvPointArray2[i3 + 1], true)) continue;
                        ++n2;
                        i2 = 5;
                        continue block3;
                    }
                }
            }
        }
        ilvPointArray = null;
        objectArray = null;
        ilvRectArray = null;
        return n2;
    }

    public static int ComputeNumberOfLinkBends(IlvGraphModel ilvGraphModel) {
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        int n2 = 0;
        Enumeration enumeration = ilvGraphModel.getLinks();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            n2 += ilvGraphModel.getLinkPointsCount(e2) - 2;
        }
        return n2;
    }

    public static int ComputeNumberOfLinkCrossings(IlvGraphModel ilvGraphModel) {
        Object object;
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        int n2 = 0;
        int n3 = ilvGraphModel.getLinksCount();
        Object[] objectArray = new Object[n3];
        IlvRect[] ilvRectArray = new IlvRect[n3];
        Enumeration enumeration = ilvGraphModel.getLinks();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            objectArray[n4] = object;
            ilvRectArray[n4++] = ilvGraphModel.boundingBox(object);
        }
        for (n4 = 0; n4 < n3; ++n4) {
            object = objectArray[n4];
            IlvRect ilvRect = ilvRectArray[n4];
            IlvPoint[] ilvPointArray = null;
            int n5 = 0;
            for (int i2 = n4; i2 < n3; ++i2) {
                Object object2 = objectArray[i2];
                IlvRect ilvRect2 = ilvRectArray[i2];
                if (!(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                if (ilvPointArray == null) {
                    ilvPointArray = ilvGraphModel.getLinkPoints(object);
                    n5 = ilvPointArray.length;
                }
                IlvPoint[] ilvPointArray2 = ilvGraphModel.getLinkPoints(object2);
                int n6 = ilvPointArray2.length;
                for (int i3 = 0; i3 < n5 - 1; ++i3) {
                    for (int i4 = 0; i4 < n6 - 1; ++i4) {
                        if (n4 == i2 && i4 <= i3 + 1 || !IlvGraphLayoutUtil.a(ilvPointArray[i3], ilvPointArray[i3 + 1], ilvPointArray2[i4], ilvPointArray2[i4 + 1], true) || i3 == 0 && i4 == 0 && ilvPointArray[i3].equals(ilvPointArray2[i4]) || i3 == 0 && i4 == n6 - 2 && ilvPointArray[i3].equals(ilvPointArray2[i4 + 1]) || i3 == n5 - 2 && i4 == 0 && ilvPointArray[i3 + 1].equals(ilvPointArray2[i4]) || i3 == n5 - 2 && i4 == n6 - 2 && ilvPointArray[i3 + 1].equals(ilvPointArray2[i4 + 1])) continue;
                        ++n2;
                    }
                }
            }
        }
        objectArray = null;
        ilvRectArray = null;
        return n2;
    }

    public static int ComputeNumberOfLinkOverlaps(IlvGraphModel ilvGraphModel) {
        Object object;
        if (ilvGraphModel == null) {
            throw new IllegalArgumentException("graphModel cannot be null");
        }
        int n2 = 0;
        int n3 = ilvGraphModel.getLinksCount();
        Object[] objectArray = new Object[n3];
        IlvRect[] ilvRectArray = new IlvRect[n3];
        Enumeration enumeration = ilvGraphModel.getLinks();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            objectArray[n4] = object;
            ilvRectArray[n4++] = ilvGraphModel.boundingBox(object);
        }
        IlvPoint ilvPoint = new IlvPoint();
        for (n4 = 0; n4 < n3; ++n4) {
            object = objectArray[n4];
            IlvRect ilvRect = ilvRectArray[n4];
            IlvPoint[] ilvPointArray = null;
            int n5 = 0;
            float f2 = 0.0f;
            for (int i2 = n4; i2 < n3; ++i2) {
                Object object2 = objectArray[i2];
                IlvRect ilvRect2 = ilvRectArray[i2];
                if (!(ilvRect.x <= ilvRect2.x + ilvRect2.width) || !(ilvRect2.x <= ilvRect.x + ilvRect.width) || !(ilvRect.y <= ilvRect2.y + ilvRect2.height) || !(ilvRect2.y <= ilvRect.y + ilvRect.height)) continue;
                if (ilvPointArray == null) {
                    ilvPointArray = ilvGraphModel.getLinkPoints(object);
                    n5 = ilvPointArray.length;
                    f2 = ilvGraphModel.getLinkWidth(object);
                }
                IlvPoint[] ilvPointArray2 = ilvGraphModel.getLinkPoints(object2);
                int n6 = ilvPointArray2.length;
                float f3 = ilvGraphModel.getLinkWidth(object2);
                for (int i3 = 0; i3 < n5 - 1; ++i3) {
                    if (n4 == i2 && ilvPointArray[i3].equals(ilvPointArray[i3 + 1])) continue;
                    for (int i4 = 0; i4 < n6 - 1; ++i4) {
                        if (n4 == i2 && (i4 <= i3 || ilvPointArray2[i4].equals(ilvPointArray2[i4 + 1])) || !IlvGraphLayoutUtil.a(ilvPointArray[i3], ilvPointArray[i3 + 1], f2, ilvPointArray2[i4], ilvPointArray2[i4 + 1], f3)) continue;
                        if (n4 == i2) {
                            boolean bl = true;
                            for (int i5 = i3 + 1; i5 < i4; ++i5) {
                                double d2 = Math.sqrt((ilvPointArray[i3 + 1].x - ilvPointArray[i5 + 1].x) * (ilvPointArray[i3 + 1].x - ilvPointArray[i5 + 1].x) + (ilvPointArray[i3 + 1].y - ilvPointArray[i5 + 1].y) * (ilvPointArray[i3 + 1].y - ilvPointArray[i5 + 1].y));
                                if (!(d2 > (double)f2)) continue;
                                ++n2;
                                bl = false;
                                break;
                            }
                            if (!bl) continue;
                            ilvPoint.x = 0.5f * (ilvPointArray2[i4].x + ilvPointArray2[i4 + 1].x);
                            ilvPoint.y = 0.5f * (ilvPointArray2[i4].y + ilvPointArray2[i4 + 1].y);
                            if (IlvGraphLayoutUtil.a(ilvPointArray[i3], ilvPointArray[i3 + 1], f2, ilvPoint, ilvPointArray2[i4 + 1], f3)) {
                                ++n2;
                                continue;
                            }
                            ilvPoint.x = 0.5f * (ilvPointArray[i3].x + ilvPointArray[i3 + 1].x);
                            ilvPoint.y = 0.5f * (ilvPointArray[i3].y + ilvPointArray[i3 + 1].y);
                            if (!IlvGraphLayoutUtil.a(ilvPointArray[i3], ilvPoint, f2, ilvPointArray2[i4], ilvPointArray2[i4 + 1], f3)) continue;
                            ++n2;
                            continue;
                        }
                        ++n2;
                    }
                }
            }
        }
        objectArray = null;
        ilvRectArray = null;
        return n2;
    }

    private static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, boolean bl) {
        double d2 = ilvPoint2.x - ilvPoint.x;
        double d3 = ilvPoint2.y - ilvPoint.y;
        double d4 = ilvPoint4.x - ilvPoint3.x;
        double d5 = ilvPoint4.y - ilvPoint3.y;
        if (d2 == 0.0 && d3 == 0.0) {
            return false;
        }
        if (d4 == 0.0 && d5 == 0.0) {
            return false;
        }
        double d6 = d2 * d5;
        double d7 = d4 * d3;
        if (d6 == d7) {
            return false;
        }
        float f2 = (float)(((double)ilvPoint.x * d7 - (double)ilvPoint3.x * d6 + (double)(ilvPoint3.y - ilvPoint.y) * d2 * d4) / (d7 - d6));
        float f3 = (float)(((double)ilvPoint.y * d6 - (double)ilvPoint3.y * d7 + (double)(ilvPoint3.x - ilvPoint.x) * d3 * d5) / (d6 - d7));
        if (Math.abs(d2) > Math.abs(d3) ? f2 < Math.min(ilvPoint.x, ilvPoint2.x) || Math.max(ilvPoint.x, ilvPoint2.x) < f2 : f3 < Math.min(ilvPoint.y, ilvPoint2.y) || Math.max(ilvPoint.y, ilvPoint2.y) < f3) {
            return false;
        }
        if (Math.abs(d4) > Math.abs(d5) ? f2 < Math.min(ilvPoint3.x, ilvPoint4.x) || Math.max(ilvPoint3.x, ilvPoint4.x) < f2 : f3 < Math.min(ilvPoint3.y, ilvPoint4.y) || Math.max(ilvPoint3.y, ilvPoint4.y) < f3) {
            return false;
        }
        if (bl) {
            if (f2 == ilvPoint2.x && f3 == ilvPoint2.y) {
                return false;
            }
            if (f2 == ilvPoint4.x && f3 == ilvPoint4.y) {
                return false;
            }
        }
        return true;
    }

    private static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, float f2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f3) {
        double d2 = ilvPoint2.x - ilvPoint.x;
        double d3 = ilvPoint4.y - ilvPoint3.y;
        double d4 = d2 * d3;
        double d5 = ilvPoint4.x - ilvPoint3.x;
        double d6 = ilvPoint2.y - ilvPoint.y;
        double d7 = d5 * d6;
        if (d4 != d7) {
            return false;
        }
        if (f2 <= 0.0f) {
            f2 = 0.5f;
        }
        if (f3 <= 0.0f) {
            f3 = 0.5f;
        }
        float f4 = d6 == 0.0 ? 0.0f : (float)(0.5 * (double)f2 / Math.sqrt(d2 / d6 * d2 / d6 + 1.0));
        float f5 = d2 == 0.0 ? 0.0f : (float)(0.5 * (double)f2 / Math.sqrt(d6 / d2 * d6 / d2 + 1.0));
        if (d2 * d6 > 0.0) {
            f4 = -f4;
        }
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint.x + f4, ilvPoint.y + f5);
        IlvPoint ilvPoint6 = new IlvPoint(ilvPoint.x - f4, ilvPoint.y - f5);
        IlvPoint ilvPoint7 = new IlvPoint(ilvPoint2.x + f4, ilvPoint2.y + f5);
        IlvPoint ilvPoint8 = new IlvPoint(ilvPoint2.x - f4, ilvPoint2.y - f5);
        f4 = d3 == 0.0 ? 0.0f : (float)(0.5 * (double)f3 / Math.sqrt(d5 / d3 * d5 / d3 + 1.0));
        f5 = d5 == 0.0 ? 0.0f : (float)(0.5 * (double)f3 / Math.sqrt(d3 / d5 * d3 / d5 + 1.0));
        if (d5 * d3 > 0.0) {
            f4 = -f4;
        }
        IlvPoint ilvPoint9 = new IlvPoint(ilvPoint3.x + f4, ilvPoint3.y + f5);
        IlvPoint ilvPoint10 = new IlvPoint(ilvPoint3.x - f4, ilvPoint3.y - f5);
        IlvPoint ilvPoint11 = new IlvPoint(ilvPoint4.x + f4, ilvPoint4.y + f5);
        IlvPoint ilvPoint12 = new IlvPoint(ilvPoint4.x - f4, ilvPoint4.y - f5);
        if (IlvGraphLayoutUtil.a(ilvPoint5, ilvPoint6, ilvPoint9, ilvPoint11, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint5, ilvPoint6, ilvPoint10, ilvPoint12, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint7, ilvPoint8, ilvPoint9, ilvPoint11, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint7, ilvPoint8, ilvPoint10, ilvPoint12, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint9, ilvPoint10, ilvPoint5, ilvPoint7, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint9, ilvPoint10, ilvPoint6, ilvPoint8, false)) {
            return true;
        }
        if (IlvGraphLayoutUtil.a(ilvPoint11, ilvPoint12, ilvPoint5, ilvPoint7, false)) {
            return true;
        }
        return IlvGraphLayoutUtil.a(ilvPoint11, ilvPoint12, ilvPoint6, ilvPoint8, false);
    }

    public static void ConnectLinksToPoint(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, IlvPoint ilvPoint, IlvTransformer ilvTransformer, boolean bl) {
        IlvClippingUtil.ConnectLinksToPoint(ilvGrapher, ilvGraphic, ilvPoint, ilvTransformer, bl);
    }

    public static IlvPoint BestClipPointOnRay(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n2) {
        return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n2);
    }

    public static boolean LineIntersectsSegment(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5) {
        return IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5);
    }

    public static int LineIntersectsPolyPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, boolean bl, IlvPoint[] ilvPointArray2) {
        return IlvClippingUtil.LineIntersectsPolyPoints(ilvPoint, ilvPoint2, ilvPointArray, bl, ilvPointArray2);
    }

    public static int LineIntersectsEllipse(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, IlvPoint[] ilvPointArray) {
        return IlvClippingUtil.LineIntersectsEllipse(ilvPoint, ilvPoint2, ilvRect, ilvPointArray);
    }

    public static int LineIntersectsArc(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, double d2, double d3, IlvPoint[] ilvPointArray) {
        return IlvClippingUtil.LineIntersectsArc(ilvPoint, ilvPoint2, ilvRect, d2, d3, ilvPointArray);
    }

    public static int LineIntersectsQuadSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n2, IlvPoint[] ilvPointArray2) {
        return IlvClippingUtil.LineIntersectsQuadSpline(ilvPoint, ilvPoint2, ilvPointArray, n2, ilvPointArray2);
    }

    public static int LineIntersectsCubicSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n2, IlvPoint[] ilvPointArray2) {
        return IlvClippingUtil.LineIntersectsCubicSpline(ilvPoint, ilvPoint2, ilvPointArray, n2, ilvPointArray2);
    }

    public static IlvPoint ArcStartPoint(IlvRect ilvRect, double d2) {
        return IlvClippingUtil.ArcStartPoint(ilvRect, d2);
    }

    public static IlvPoint ArcEndPoint(IlvRect ilvRect, double d2, double d3) {
        return IlvClippingUtil.ArcEndPoint(ilvRect, d2, d3);
    }

    public static Enumeration CreateSortedEnumeration(Enumeration enumeration, Comparator comparator) {
        if (comparator == null || enumeration == null || !enumeration.hasMoreElements()) {
            return enumeration;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        final int n2 = arrayList.size();
        final Object[] objectArray = arrayList.toArray();
        IlvGraphLayoutUtil.Sort(objectArray, comparator);
        return new Enumeration(){
            private int a = 0;

            public boolean hasMoreElements() {
                return this.a < n2;
            }

            public Object nextElement() {
                if (this.a < n2) {
                    return objectArray[this.a++];
                }
                throw new NoSuchElementException("Enumeration");
            }
        };
    }

    public static void Sort(Object[] objectArray, Comparator comparator) {
        if (comparator == null || objectArray == null || objectArray.length <= 1) {
            return;
        }
        SortByComparator sortByComparator = new SortByComparator(comparator);
        sortByComparator.sort(objectArray);
    }

    private static final class ConnectedComponentsFinder
    extends IlvGraphModelDFS {
        private transient IlvConnectedComponentAdapter a = null;

        ConnectedComponentsFinder(IlvGraphModel ilvGraphModel, String string) {
            super(ilvGraphModel, string);
        }

        public IlvGraphModel getConnectedComponents() {
            IlvConnectedComponentCollectionAdapter ilvConnectedComponentCollectionAdapter = new IlvConnectedComponentCollectionAdapter(this._graphModel);
            Enumeration enumeration = this._graphModel.getNodes();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                throw new RuntimeException("should not be called for empty graphs");
            }
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (this.isMarkedNode(e2)) continue;
                this.a = new IlvConnectedComponentAdapter(this._graphModel);
                ilvConnectedComponentCollectionAdapter.addNode(this.a);
                super.execute(e2, false);
            }
            Enumeration enumeration2 = ilvConnectedComponentCollectionAdapter.getNodes();
            while (enumeration2.hasMoreElements()) {
                Enumeration enumeration3 = ((IlvGraphModel)enumeration2.nextElement()).getNodesAndLinks();
                while (enumeration3.hasMoreElements()) {
                    this._graphModel.setProperty(enumeration3.nextElement(), this._propName, null);
                }
            }
            return ilvConnectedComponentCollectionAdapter;
        }

        protected void markNode(Object object) {
            super.markNode(object);
            this.a.addNode(object);
        }

        protected void markLink(Object object) {
            super.markLink(object);
            this.a.addLink(object);
        }
    }

    private static final class CountNodesInConnectedComponent
    extends IlvGraphModelDFS {
        private int a = 0;

        CountNodesInConnectedComponent(IlvGraphModel ilvGraphModel, String string) {
            super(ilvGraphModel, string);
        }

        int a(Object object) {
            this.a = 0;
            super.execute(object, true);
            return this.a;
        }

        protected void markNode(Object object) {
            super.markNode(object);
            ++this.a;
        }
    }

    public static interface FreeLinkConnectorFactory {
        public IlvFreeLinkConnector create(IlvGraphic var1);
    }

    private static class SortByComparator
    extends IlvArrayStableSort {
        private Comparator a;

        SortByComparator(Comparator comparator) {
            this.a = comparator;
        }

        protected final boolean compare(Object object, Object object2) {
            return this.a.compare(object, object2) <= 0;
        }
    }

    private static final class TestTree
    extends IlvGraphModelDFS {
        private boolean a;
        private boolean b;

        TestTree(IlvGraphModel ilvGraphModel, String string) {
            super(ilvGraphModel, string);
        }

        boolean a(Object object) {
            this.b = true;
            this.a = false;
            super.execute(object, true);
            return this.b;
        }

        protected void traverseBack(Object object, Object object2) {
            if (this._graphModel.getFrom(object) != this._graphModel.getTo(object)) {
                this.b = false;
                this.a = true;
            }
        }

        protected boolean isDone() {
            return this.a;
        }
    }
}

