/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.NoMainClassAttributeException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;

public class CWICustomClassLoader
extends URLClassLoader {
    private String mJarFileName = null;

    public CWICustomClassLoader(String jarFileName, ClassLoader parent) throws MalformedURLException {
        super(CWICustomClassLoader.makeUrls(jarFileName), parent);
        this.mJarFileName = jarFileName;
    }

    private static URL[] makeUrls(String jarFileName) throws MalformedURLException {
        URL[] urls = new URL[]{CWICustomClassLoader.createURL(jarFileName)};
        return urls;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        return super.findClass(className);
    }

    private static final URL createURL(String fileName) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot create url for: " + fileName);
                e.printStackTrace();
                throw e;
            }
        }
        return url;
    }

    protected void invokeMain(String[] args) throws NoMainClassAttributeException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        this.invokeClass(this.getMainClassName(), args);
    }

    private String getMainClassName() throws NoMainClassAttributeException {
        String result = null;
        URL[] urls = this.getURLs();
        for (int i = 0; result == null && i < urls.length; ++i) {
            try {
                URL url = new URL("jar", "", urls[i].toString() + "!/");
                JarURLConnection uc = (JarURLConnection)url.openConnection();
                Attributes attr = uc.getMainAttributes();
                if (attr == null) continue;
                result = attr.getValue(Attributes.Name.MAIN_CLASS);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new NoMainClassAttributeException();
        }
        return result.trim();
    }

    private void invokeClass(String name, String[] args) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> c = this.loadClass(name);
        Class[] t = new Class[]{args.getClass()};
        Method m = c.getMethod("main", t);
        m.setAccessible(true);
        if (!this.isMethodPublicStaticVoid(m)) {
            throw new NoSuchMethodException("main");
        }
        Object[] a = new Object[]{args};
        m.invoke(null, a);
    }

    private boolean isMethodPublicStaticVoid(Method m) {
        int mods = m.getModifiers();
        return m.getReturnType() == Void.TYPE && Modifier.isStatic(mods) && Modifier.isPublic(mods);
    }
}

