/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.InstallerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Uninstall {
    public static void main(String[] args) {
        try {
            System.out.println("In Uninstall");
            if (!InstallerUtil.showQuestionDialog(null, "Uninstall will remove all user data and preferences files.\nDo you wish to proceed with the uninstall?")) {
                System.out.println("Uninstall aborted by user.");
                System.out.println("Exit value is 2");
                System.exit(2);
            }
            Uninstall uninstall = new Uninstall();
            uninstall.begin(args);
            System.exit(0);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(cnfe);
            cnfe.printStackTrace();
            Uninstall.fatal("Load class failed to load a class..." + cnfe);
        }
        catch (IllegalAccessException iae) {
            System.err.println(iae);
            iae.printStackTrace();
            Uninstall.fatal("cannot access the 'main(String[])' method");
        }
        catch (InstantiationException ie) {
            System.err.println(ie);
            ie.printStackTrace();
            Uninstall.fatal("failed to instantiate a class loader");
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(nsme + ": " + nsme.getMessage());
            nsme.printStackTrace();
            Uninstall.fatal("'setParent(CmsClassLoader)' not in ElementFactory OR 'main(String[])' not in class tagged as Main-Class");
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
            Uninstall.fatal("failed to invoke 'main(String[])'");
        }
        catch (MalformedURLException mue) {
            System.err.println(mue);
            mue.printStackTrace();
            Uninstall.fatal("invalid URL parts on command line");
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            ioe.printStackTrace();
            Uninstall.fatal("I/O error while caching JAR");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            Uninstall.fatal("Error uninstalling CWI");
        }
    }

    private Uninstall() {
    }

    private void begin(String[] args) throws Exception {
        if (args.length > 0) {
            InstallerUtil.showInfoDialog(null, "To ensure a successful uninstall, please close all\nrunning copies of CWI and all open browser windows.\nClick OK to proceed once this has been done.");
            String installFilePath = args[0];
            if (installFilePath.length() != 0) {
                File installPath = new File(installFilePath);
                installFilePath = installPath.getPath();
            }
            String compatibilityPath = installFilePath.substring(0, installFilePath.lastIndexOf(File.separator));
            HashMap fileDirMap = null;
            try {
                fileDirMap = InstallerUtil.readFileAsMap(installFilePath);
            }
            catch (IOException ex) {
                String errorMessage = "Unable to read " + installFilePath + " successfully.";
                InstallerUtil.showErrorDialog(null, errorMessage + "\nUnable to uninstall" + " CWI successfully", "CWI Uninstaller - Error");
                Uninstall.fatal(errorMessage);
            }
            if (fileDirMap != null) {
                Set fileKeys = fileDirMap.keySet();
                Iterator iter = fileKeys.iterator();
                boolean success = true;
                while (iter.hasNext()) {
                    String filePath = (String)iter.next();
                    if (filePath.equals(installFilePath)) continue;
                    String dirName = (String)fileDirMap.get(filePath);
                    File file = new File(filePath);
                    if (file.exists()) {
                        if (file.delete()) {
                            System.out.println(" File " + filePath + " successfully deleted.");
                        } else {
                            String errorMessage = "Could not delete " + filePath + ".";
                            System.out.println(errorMessage);
                            if (!"installer.jar".equals(file.getName())) {
                                success = false;
                            }
                        }
                    }
                    this.removeDirectories(dirName, filePath);
                }
                if (success) {
                    String dirName = (String)fileDirMap.get(installFilePath);
                    File installFile = new File(installFilePath);
                    installFile.delete();
                    this.removeDirectories(dirName, installFilePath);
                } else {
                    String errorMessage = "Unable to uninstall CWI successfully.";
                    InstallerUtil.showErrorDialog(null, "Unable to uninstall CWI successfully.", "CWI Uninstaller - Error");
                    Uninstall.fatal("Unable to uninstall CWI successfully.");
                }
            }
        } else {
            Uninstall.fatal("Incorrect generated uninstall file or jar locations messed up.");
        }
    }

    private void removeDirectories(String parentDirName, String filePath) {
        String immediateParentDirName;
        if (parentDirName != null && (immediateParentDirName = InstallerUtil.getParentDirName(filePath)) != null) {
            this.removeParentDirectories(immediateParentDirName, parentDirName);
        }
    }

    private void removeParentDirectories(String dirName, String lastDirName) {
        String parentDirName;
        File file = new File(dirName);
        if (file.isDirectory() && file.list().length == 0) {
            file.delete();
        }
        if (!dirName.equals(lastDirName) && (parentDirName = InstallerUtil.getParentDirName(dirName)) != null) {
            this.removeParentDirectories(parentDirName, lastDirName);
        }
    }

    private static void fatal(String msg) {
        System.err.println(msg);
        System.err.println("Exit value is 1");
        System.err.flush();
        System.exit(1);
    }
}

