/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.IncompatibleVersionListException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionStringException;
import com.cisco.hfr.cwi.installer.NEVersion;
import com.cisco.hfr.cwi.installer.Version;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionFactory {
    private Log mLog = LogFactory.getLog(VersionFactory.class);
    private static VersionFactory sInstance = null;

    private VersionFactory() {
    }

    public static VersionFactory instance() {
        if (sInstance == null) {
            sInstance = new VersionFactory();
        }
        return sInstance;
    }

    public IVersion getVersion(String version) throws IncompatibleVersionStringException, IncompatibleVersionListException {
        return this.getVersion(version, null);
    }

    public IVersion getVersion(String version, String neName) throws IncompatibleVersionStringException, IncompatibleVersionListException {
        return this.getVersion(version, neName, null);
    }

    public IVersion getVersion(String version, String neName, String versionList) throws IncompatibleVersionStringException, IncompatibleVersionListException {
        this.isVersionStringFormat(version);
        if (versionList != null) {
            this.mLog.debug("Version List is : " + versionList);
            this.isVersionListStringFormat(versionList);
        }
        Version versionObject = null;
        versionObject = neName != null ? new NEVersion(neName, version, versionList) : new Version(version, versionList);
        return versionObject;
    }

    public boolean isVersionStringFormat(String version) throws IncompatibleVersionStringException {
        boolean isVersionFormat = false;
        int dotIndex = version.indexOf(".");
        if (dotIndex != -1) {
            String firstVersionNumber = version.substring(0, dotIndex);
            String secondVersionNumber = version.substring(dotIndex + 1);
            try {
                int number = Integer.parseInt(firstVersionNumber);
                number = Integer.parseInt(secondVersionNumber);
                isVersionFormat = true;
            }
            catch (NumberFormatException e) {
                String errorMessage = "Version string " + version + " is " + "not of expected format - Number.Number";
                this.mLog.warn(errorMessage);
                throw new IncompatibleVersionStringException(errorMessage);
            }
        } else {
            throw new IncompatibleVersionStringException("Version string " + version + " is not of expected format " + "- Number.Number");
        }
        return isVersionFormat;
    }

    private boolean isVersionListStringFormat(String versionList) throws IncompatibleVersionListException {
        String DELIMS = ".,-";
        StringBuffer accumulatedTokens = new StringBuffer();
        String firstVersionString = null;
        boolean isVersionListFormat = true;
        StringTokenizer tokenizer = new StringTokenizer(versionList, ".,-", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(",") || token.equals("-")) {
                String versionString = accumulatedTokens.toString();
                this.checkVersionStringFormat(versionString, versionList);
                if (token.equals("-")) {
                    firstVersionString = versionString;
                } else if (firstVersionString != null) {
                    this.compareVersionRangeParameters(firstVersionString, versionString, versionList);
                    firstVersionString = null;
                }
                accumulatedTokens.delete(0, accumulatedTokens.length());
                continue;
            }
            accumulatedTokens.append(token);
        }
        String versionString = accumulatedTokens.toString();
        this.checkVersionStringFormat(versionString, versionList);
        if (firstVersionString != null) {
            this.compareVersionRangeParameters(firstVersionString, versionString, versionList);
        }
        return isVersionListFormat;
    }

    private void checkVersionStringFormat(String versionString, String versionList) throws IncompatibleVersionListException {
        try {
            this.isVersionStringFormat(versionString);
        }
        catch (IncompatibleVersionStringException ex) {
            String errorMessage = "Version string " + versionString + " not " + " in version format while parsing version " + "list: " + versionList;
            this.mLog.error(errorMessage, ex);
            throw new IncompatibleVersionListException(errorMessage);
        }
    }

    private void compareVersionRangeParameters(String versionString1, String versionString2, String versionList) throws IncompatibleVersionListException {
        IVersion version1 = null;
        IVersion version2 = null;
        try {
            version1 = this.getVersion(versionString1);
            version2 = this.getVersion(versionString2);
        }
        catch (IncompatibleVersionStringException ex) {
            String errorMessage = "Range version parameters not correct Version Strings: " + versionString1 + " and " + versionString1 + " while " + " parsing " + versionList;
            this.mLog.error(errorMessage, ex);
            throw new IncompatibleVersionListException(errorMessage);
        }
        if (version1.getFeatureVersion() != version2.getFeatureVersion() && version1.getMaintenanceVersion() != version2.getMaintenanceVersion()) {
            String errorMessage = "Range version parameters(" + version1 + " and " + version2 + ") not correct while " + " parsing " + versionList;
            this.mLog.error(errorMessage);
            throw new IncompatibleVersionListException(errorMessage);
        }
    }
}

