/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.mgbl.security;

import com.cisco.hfr.mgbl.security.SSL14InitializerHelper;
import com.cisco.hfr.mgbl.security.SSLORBSocketFactory;
import com.cisco.hfr.mgbl.security.VerifyCertificateDialog;
import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import sun.security.provider.Sun;

public class SSLInitializer {
    private static SSLInitializer mInstance = null;
    private SSLSocketFactory mSocketFactory = null;

    private SSLInitializer() {
    }

    public static synchronized SSLInitializer instance() throws NoSuchAlgorithmException, KeyManagementException {
        if (mInstance == null) {
            SSLInitializer instance = new SSLInitializer();
            instance.initializeSocketFactory();
            mInstance = instance;
        }
        return mInstance;
    }

    private void initializeSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        Security.addProvider(new Sun());
        Security.addProvider((java.security.Provider)new Provider());
        Object km = null;
        TrustManager[] tm = new TrustManager[]{new CWIX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance((String)"SSL");
        sslContext.init(null, tm, new SecureRandom());
        this.mSocketFactory = sslContext.getSocketFactory();
    }

    public SSLSocketFactory getSocketFactory() {
        return this.mSocketFactory;
    }

    public HttpURLConnection initializeHttpsProtocol(String urlStr) throws MalformedURLException, IOException {
        URL url = new URL(urlStr);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (urlConnection instanceof HttpsURLConnection) {
            HttpsURLConnection connection = (HttpsURLConnection)urlConnection;
            connection.setSSLSocketFactory(this.mSocketFactory);
            connection.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String urlHost, String ssls) {
                    return true;
                }
            });
        } else {
            SSL14InitializerHelper.initializeHttpsProtocolForJDK14(urlConnection, this.mSocketFactory);
        }
        return urlConnection;
    }

    public static final boolean checkKeyUsage(X509Certificate xcert, boolean[] usage) {
        if (usage == null) {
            return true;
        }
        Set<String> critExtn = xcert.getCriticalExtensionOIDs();
        if (critExtn != null && critExtn.contains("2.5.29.15")) {
            boolean[] cusage = xcert.getKeyUsage();
            int len = usage.length > cusage.length ? cusage.length : usage.length;
            for (int i = 0; i < len; ++i) {
                if (!usage[i] || cusage[i]) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean verifyCertificate(X509Certificate xcert) throws Exception {
        String javaHome = System.getProperty("java.home");
        String fileSeparator = System.getProperty("file.separator");
        String cacerts = javaHome + fileSeparator + "lib" + fileSeparator + "security" + fileSeparator + "cacerts";
        FileInputStream cacertsFile = null;
        String trustStore = System.getProperty("javax.net.ssl.trustStore");
        cacertsFile = trustStore == null ? new FileInputStream(cacerts) : new FileInputStream(trustStore);
        KeyStore javaKeyStore = KeyStore.getInstance("JKS");
        javaKeyStore.load(cacertsFile, "changeit".toCharArray());
        cacertsFile.close();
        boolean[] dsigUsage = new boolean[]{true};
        if (!SSLInitializer.verifyTrustedCertificate(xcert, dsigUsage, javaKeyStore, true)) {
            VerifyCertificateDialog verifyDialog = new VerifyCertificateDialog(null, true, new X509Certificate[]{xcert});
            verifyDialog.show();
            switch (verifyDialog.getSelectedOption()) {
                case 1: {
                    File cwiCACerts = File.createTempFile("cacerts", ".cwi");
                    SSLInitializer.createSessionStore(new File(cacerts), cwiCACerts, cwiCACerts.getCanonicalPath(), "changeit", "cwi_hfr_ne", xcert);
                    return true;
                }
                case 2: {
                    javaKeyStore.setCertificateEntry("cwi_hfr_ne", xcert);
                    FileOutputStream cacertsOutFile = new FileOutputStream(cacerts);
                    javaKeyStore.store(cacertsOutFile, "changeit".toCharArray());
                    cacertsOutFile.close();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static final boolean verifyTrustedCertificate(X509Certificate xcert, boolean[] usage, KeyStore root, boolean add) throws Exception {
        Enumeration<String> aliases = root.aliases();
        Principal issuerDN = xcert.getIssuerDN();
        Principal subjectDN = xcert.getSubjectDN();
        PublicKey pk = xcert.getPublicKey();
        xcert.checkValidity();
        if (!SSLInitializer.checkKeyUsage(xcert, usage)) {
            throw new Exception("KEYUSAGE: Wrong Key Usage");
        }
        while (aliases.hasMoreElements()) {
            X509Certificate cert;
            String calias = aliases.nextElement();
            if (!root.isCertificateEntry(calias) || !SSLInitializer.isCertificateValid(cert = (X509Certificate)root.getCertificate(calias))) continue;
            Principal sDN = cert.getSubjectDN();
            Principal iDN = cert.getIssuerDN();
            PublicKey pkc = cert.getPublicKey();
            if (((Object)issuerDN).equals(sDN)) {
                try {
                    xcert.verify(pkc);
                    return true;
                }
                catch (SignatureException se) {
                    throw new Exception("SIGNERROR: Signature verification failed for Certificate with Subject: " + ((Object)subjectDN).toString());
                }
            }
            if (!((Object)subjectDN).equals(sDN) && !pk.equals(pkc)) continue;
            return true;
        }
        return false;
    }

    private static void createSessionStore(File castore, File casession, String casessionStr, String storepass, String alias, X509Certificate cert) throws Exception {
        FileInputStream fi;
        String currentKeyStore = System.getProperty("javax.net.ssl.trustStore");
        if (currentKeyStore == null) {
            SSLInitializer.copyFile(castore, casession);
            fi = new FileInputStream(casession);
        } else {
            fi = new FileInputStream(currentKeyStore);
            casessionStr = currentKeyStore;
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(fi, storepass.toCharArray());
        fi.close();
        ks.setCertificateEntry(alias, cert);
        FileOutputStream fo = new FileOutputStream(casessionStr);
        ks.store(fo, storepass.toCharArray());
        fo.close();
        System.setProperty("javax.net.ssl.trustStore", casessionStr);
        System.setProperty("javax.net.ssl.trustStorePassword", storepass);
    }

    private static final void copyFile(File src, File dest) throws Exception {
        int numread;
        BufferedInputStream isrc = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream odest = new BufferedOutputStream(new FileOutputStream(dest));
        byte[] record = new byte[8192];
        while ((numread = isrc.read(record, 0, record.length)) != -1) {
            odest.write(record, 0, numread);
        }
        odest.flush();
        odest.close();
        isrc.close();
    }

    private static final boolean isCertificateValid(X509Certificate certificate) {
        try {
            certificate.checkValidity();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void registerForSSLORB(String neName) {
        SSLORBSocketFactory.registerForSSLORB(neName);
    }

    public void initORB() {
        System.setProperty("com.sun.CORBA.transport.ORBSocketFactoryClass", "com.cisco.hfr.mgbl.security.SSLORBSocketFactory");
    }

    static class CWIX509TrustManager
    implements X509TrustManager {
        CWIX509TrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        public boolean isServerTrusted(X509Certificate[] cert) {
            try {
                return SSLInitializer.verifyCertificate(cert[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean isClientTrusted(X509Certificate[] cert) {
            try {
                return SSLInitializer.verifyCertificate(cert[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

