/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.authentication.PasswordChangePrompt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public class PasswordChange
implements PasswordChangePrompt {
    public static final String PASSWORD_ICON = "/com/sshtools/common/authentication/largepassword.png";
    private static PasswordChange instance;
    private Component parent;

    private PasswordChange() {
    }

    public void setParentComponent(Component parent) {
        this.parent = parent;
    }

    public String changePassword(String prompt) {
        Window w = this.parent == null ? null : (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent);
        PasswordChangeDialog dialog = null;
        dialog = w instanceof Frame ? new PasswordChangeDialog((Frame)w, prompt) : (w instanceof Dialog ? new PasswordChangeDialog((Dialog)w, prompt) : new PasswordChangeDialog(prompt));
        char[] p = dialog.getPassword();
        return p == null ? null : new String(p);
    }

    public static PasswordChange getInstance() {
        if (instance == null) {
            instance = new PasswordChange();
        }
        return instance;
    }

    class PasswordChangeDialog
    extends JDialog {
        JLabel promptLabel;
        JPasswordField password;
        JPasswordField confirm;
        boolean cancelled;

        PasswordChangeDialog(String prompt) {
            super((Frame)null, "Password Change", true);
            this.promptLabel = new JLabel();
            this.password = new JPasswordField(15);
            this.confirm = new JPasswordField(15);
            this.init(prompt);
        }

        PasswordChangeDialog(Frame frame, String prompt) {
            super(frame, "Password Change", true);
            this.promptLabel = new JLabel();
            this.password = new JPasswordField(15);
            this.confirm = new JPasswordField(15);
            this.init(prompt);
        }

        PasswordChangeDialog(Dialog dialog, String prompt) {
            super(dialog, "Password Change", true);
            this.promptLabel = new JLabel();
            this.password = new JPasswordField(15);
            this.confirm = new JPasswordField(15);
            this.init(prompt);
        }

        char[] getPassword() {
            return this.cancelled ? null : this.password.getPassword();
        }

        void init(String prompt) {
            this.setDefaultCloseOperation(2);
            JPanel g = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 2, 2);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            UIUtil.jGridBagAdd(g, new JLabel("Password: "), gbc, -1);
            gbc.weightx = 1.0;
            UIUtil.jGridBagAdd(g, this.password, gbc, 0);
            gbc.weightx = 0.0;
            UIUtil.jGridBagAdd(g, new JLabel("Confirm: "), gbc, -1);
            gbc.weightx = 1.0;
            UIUtil.jGridBagAdd(g, this.confirm, gbc, 0);
            this.promptLabel.setHorizontalAlignment(0);
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            centerPanel.add((Component)this.promptLabel, "North");
            centerPanel.add((Component)g, "Center");
            JButton ok = new JButton("Ok");
            ok.setMnemonic('o');
            ok.setDefaultCapable(true);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (!new String(PasswordChangeDialog.this.password.getPassword()).equals(new String(PasswordChangeDialog.this.confirm.getPassword()))) {
                        JOptionPane.showMessageDialog(PasswordChangeDialog.this, "Passwords do not match. Please try again.", "Passwords do not match", 0);
                    } else {
                        PasswordChangeDialog.this.hide();
                    }
                }
            });
            this.getRootPane().setDefaultButton(ok);
            JButton cancel = new JButton("Cancel");
            cancel.setMnemonic('c');
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    PasswordChangeDialog.this.cancelled = true;
                    PasswordChangeDialog.this.hide();
                }
            });
            JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
            southPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            southPanel.add(cancel);
            southPanel.add(ok);
            IconWrapperPanel iconPanel = new IconWrapperPanel(new ResourceIcon("largelock.png"), centerPanel);
            iconPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            mainPanel.add((Component)iconPanel, "Center");
            mainPanel.add((Component)southPanel, "South");
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(mainPanel);
            this.pack();
            this.toFront();
            UIUtil.positionComponent(0, this);
            this.setVisible(true);
        }
    }
}

