/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.authentication.AuthorizationFileVerification;
import com.sshtools.daemon.authentication.PublicKeyVerification;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublicKeyAuthenticationServer
extends SshAuthenticationServer {
    private static Class pkv = AuthorizationFileVerification.class;
    private Log log = LogFactory.getLog(PublicKeyAuthenticationServer.class);

    public String getMethodName() {
        return "publickey";
    }

    public static void setVerificationImpl(Class pkv) {
        PublicKeyAuthenticationServer.pkv = pkv;
    }

    public int authenticate(AuthenticationProtocolServer authentication, SshMsgUserAuthRequest msg) throws IOException {
        ByteArrayReader bar = new ByteArrayReader(msg.getRequestData());
        int check = bar.read();
        String algorithm = bar.readString();
        byte[] encoded = bar.readBinaryString();
        byte[] signature = null;
        try {
            PublicKeyVerification verify = (PublicKeyVerification)pkv.newInstance();
            if (check == 0) {
                if (verify.acceptKey(msg.getUsername(), algorithm, encoded)) {
                    SshMsgUserAuthPKOK reply = new SshMsgUserAuthPKOK(algorithm, encoded);
                    authentication.sendMessage(reply);
                    return 1;
                }
                return 2;
            }
            signature = bar.readBinaryString();
            NativeAuthenticationProvider authProv = NativeAuthenticationProvider.getInstance();
            if (authProv == null) {
                this.log.error("Authentication failed because no native authentication provider is available");
                return 2;
            }
            if (!authProv.logonUser(msg.getUsername())) {
                this.log.info("Authentication failed because " + msg.getUsername() + " is not a valid username");
                return 2;
            }
            try {
                if (verify.verifyKeySignature(msg.getUsername(), algorithm, encoded, msg.getServiceName(), authentication.getSessionIdentifier(), signature)) {
                    return 4;
                }
            }
            catch (Exception ex) {
                this.log.error("Failed to create an instance of the verification implementation", ex);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return 2;
    }
}

