/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog(PublicKeyAuthenticationClient.class);
    protected SshAgentClient agent;

    public void setAgent(SshAgentClient agent) {
        this.agent = agent;
    }

    public void reset() {
        this.agent = null;
    }

    public String getMethodName() {
        return "publickey";
    }

    public boolean acceptsKey(AuthenticationProtocolClient authentication, String username, String serviceToStart, SshPublicKey key) throws IOException {
        authentication.registerMessage(SshMsgUserAuthPKOK.class, 60);
        log.info("Determining if server can accept public key for authentication");
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.write(0);
        baw.writeString(key.getAlgorithmName());
        baw.writeBinaryString(key.getEncoded());
        SshMessage msg = new SshMsgUserAuthRequest(username, serviceToStart, this.getMethodName(), baw.toByteArray());
        authentication.sendMessage(msg);
        try {
            msg = authentication.readMessage(60);
            if (msg instanceof SshMsgUserAuthPKOK) {
                return true;
            }
            throw new IOException("Unexpected message returned from readMessage");
        }
        catch (TerminatedStateException ex) {
            return false;
        }
    }

    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.agent == null) {
            throw new AuthenticationProtocolException("You must supply a username and agent");
        }
        Map keys = this.agent.listKeys();
        Iterator it = keys.entrySet().iterator();
        boolean acceptable = false;
        SshPublicKey key = null;
        while (it.hasNext() && !acceptable) {
            Map.Entry entry = it.next();
            key = (SshPublicKey)entry.getKey();
            String description = (String)entry.getValue();
            acceptable = this.acceptsKey(authentication, this.getUsername(), serviceToStart, key);
            log.info("Agent authentication with key " + key.getFingerprint() + " [" + description + "] is " + (acceptable ? " acceptable" : " not acceptable"));
            if (!acceptable) continue;
            ByteArrayWriter baw = new ByteArrayWriter();
            log.info("Generating data to sign");
            log.info("Preparing public key authentication request");
            baw.write(1);
            baw.writeString(key.getAlgorithmName());
            baw.writeBinaryString(key.getEncoded());
            ByteArrayWriter data = new ByteArrayWriter();
            data.writeBinaryString(authentication.getSessionIdentifier());
            data.write(50);
            data.writeString(this.getUsername());
            data.writeString(serviceToStart);
            data.writeString(this.getMethodName());
            data.write(1);
            data.writeString(key.getAlgorithmName());
            data.writeBinaryString(key.getEncoded());
            baw.writeBinaryString(this.agent.hashAndSign(key, data.toByteArray()));
            SshMsgUserAuthRequest msg = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, this.getMethodName(), baw.toByteArray());
            authentication.sendMessage(msg);
            try {
                authentication.readAuthenticationState();
            }
            catch (TerminatedStateException ex) {
                if (ex.getState() != 4) continue;
                throw ex;
            }
        }
        throw new TerminatedStateException(2);
    }

    public boolean showAuthenticationDialog(Component parent) {
        return false;
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
    }

    public boolean canAuthenticate() {
        return this.agent != null && this.getUsername() != null;
    }

    public boolean hasAcceptableKey(SshClient ssh) {
        try {
            Map keys = this.agent.listKeys();
            for (SshPublicKey key : keys.keySet()) {
                if (!ssh.acceptsKey(this.getUsername(), key)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

