/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static boolean closeStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        File[] list = file.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (IOUtil.delTree(list[i])) continue;
            return false;
        }
        return true;
    }

    public static void recurseDeleteDirectory(File dir) {
        int i;
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files == null) {
            return;
        }
        for (i = 0; i < files.length; ++i) {
            IOUtil.recurseDeleteDirectory(files[i]);
            files[i].delete();
        }
        files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        for (i = 0; i < files.length; ++i) {
            files[i].delete();
        }
        dir.delete();
    }

    public static void copyFile(File from, File to) throws IOException {
        if (from.isDirectory()) {
            if (!to.exists()) {
                to.mkdir();
            }
            File[] children = from.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getName().equals(".") || children[i].getName().equals("..")) continue;
                if (children[i].isDirectory()) {
                    File f = new File(to, children[i].getName());
                    IOUtil.copyFile(children[i], f);
                    continue;
                }
                IOUtil.copyFile(children[i], to);
            }
        } else if (from.isFile() && (to.isDirectory() || to.isFile())) {
            int read;
            if (to.isDirectory()) {
                to = new File(to, from.getName());
            }
            FileInputStream in = new FileInputStream(from);
            FileOutputStream out = new FileOutputStream(to);
            byte[] buf = new byte[32678];
            while ((read = in.read(buf)) > -1) {
                out.write(buf, 0, read);
            }
            IOUtil.closeStream(in);
            IOUtil.closeStream(out);
        }
    }
}

