/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.kex.DhGroup1Sha1;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyExchangeFactory {
    private static Map kexs;
    private static String defaultAlgorithm;
    private static Log log;

    protected SshKeyExchangeFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultKeyExchange() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeyExchanges() {
        return new ArrayList(kexs.keySet());
    }

    public static SshKeyExchange newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyExchange)((Class)kexs.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshKeyExchangeFactory.class);
        kexs = new HashMap();
        log.info("Loading key exchange methods");
        kexs.put("diffie-hellman-group1-sha1", DhGroup1Sha1.class);
        defaultAlgorithm = "diffie-hellman-group1-sha1";
    }
}

