/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.jta.HostUnreachableException;
import de.mud.jta.ICliSessionDelegatee;
import de.mud.jta.ScriptHandler;
import de.mud.ssh.SshIO;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshWrapper
implements ICliSessionDelegatee {
    private Log log = LogFactory.getLog(SshWrapper.class);
    protected SshIO handler;
    private String prompt = null;
    private byte[] buffer;
    private int pos;
    protected ScriptHandler scriptHandler = new ScriptHandler();
    private Thread reader;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected String host;
    protected Vector script = new Vector();
    private boolean mIsTimeoutAcceptable = false;

    public SshWrapper() {
        this.handler = new SshIO(){

            public String getTerminalType() {
                return "vt320";
            }

            public Dimension getWindowSize() {
                return new Dimension(80, 25);
            }

            public void setLocalEcho(boolean echo) {
            }

            public void write(byte[] b) throws IOException {
                SshWrapper.this.out.write(b);
            }
        };
    }

    public void connect(String host, int port) throws IOException {
        this.log.debug("SSHWrapper: connect(" + host + "," + port + ")");
        try {
            this.socket = new Socket(host, port);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.log.warn("SshWrapper: Exception during connect()", e);
            this.disconnect();
            throw e;
        }
    }

    public void disconnect() throws IOException {
        this.log.debug("SshWrapper: disconnect()");
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void login(String user, String pwd) throws IOException {
        this.handler.setLogin(user);
        this.handler.setPassword(pwd);
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] b) throws IOException {
        if (this.buffer != null) {
            int amount = this.buffer.length - this.pos <= b.length ? this.buffer.length - this.pos : b.length;
            System.arraycopy(this.buffer, this.pos, b, 0, amount);
            if (this.pos + amount < this.buffer.length) {
                this.pos += amount;
                return amount;
            }
            this.buffer = null;
            return amount;
        }
        int n = 0;
        boolean validSocketTimeout = false;
        try {
            n = this.in.read(b);
        }
        catch (SocketTimeoutException ste) {
            if (!this.mIsTimeoutAcceptable) {
                throw ste;
            }
            validSocketTimeout = true;
            this.log.debug("SocketTimeOutException: " + ste);
        }
        if (n <= 0) {
            if (n != -1) return n;
            if (validSocketTimeout) return n;
            this.log.error("read() returned -1 - connection closed by foreign host");
            throw new HostUnreachableException("Connection closed by foreign host.", "Please verify device connectivity and configuration.");
        }
        byte[] tmp = new byte[n];
        System.arraycopy(b, 0, tmp, 0, n);
        this.pos = 0;
        try {
            this.buffer = this.handler.handleSSH(tmp);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.buffer != null && this.buffer.length > 0) {
            this.log.debug("ssh: " + new String(this.buffer));
            this.log.debug("ssh: incoming=" + n + " now=" + this.buffer.length);
            int amount = this.buffer.length <= b.length ? this.buffer.length : b.length;
            System.arraycopy(this.buffer, 0, b, 0, amount);
            this.pos = n = amount;
            if (amount != this.buffer.length) return n;
            this.buffer = null;
            this.pos = 0;
            return n;
        }
        this.log.debug("ssh: Buffer is null.");
        return 0;
    }

    public void write(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            switch (b[i]) {
                case 10: {
                    b[i] = 13;
                }
            }
        }
        this.handler.sendData(new String(b));
    }

    public void setReadTimeout(int millisecs) {
        try {
            this.socket.setSoTimeout(millisecs);
        }
        catch (SocketException se) {
            this.log.error("Unable to set socket timeout", se);
        }
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public void setTimeoutAcceptable(boolean isTimeoutAcceptable) {
        this.mIsTimeoutAcceptable = isTimeoutAcceptable;
    }
}

