/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.ITdmProtocolType;
import cerent.util.AbstractEnumBehavior;
import cerent.util.SDHTDMTerminology;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;

public class TdmProtocolType
extends AbstractEnumBehavior
implements ITdmProtocolType {
    private static AbstractEnumBehavior.EnumRange range = new AbstractEnumBehavior.EnumRange(TdmProtocolType.class);
    private static final int IS_SONET = 0;
    private static final int IS_SDH = 1;
    private static TdmProtocolType[] tdmProtocolTypes = new TdmProtocolType[range.getNumTypes()];
    private static final ICircuitType[] supportedSonetCktTypes = new ICircuitType[]{CircuitType.getCircuitType(1), CircuitType.getCircuitType(2), CircuitType.getCircuitType(3), CircuitType.getCircuitType(7), CircuitType.getCircuitType(10), CircuitType.getCircuitType(11)};
    private static final ICircuitType[] supportedSdhCktTypes = new ICircuitType[]{CircuitType.getCircuitType(4), CircuitType.getCircuitType(5), CircuitType.getCircuitType(6), CircuitType.getCircuitType(8), CircuitType.getCircuitType(12), CircuitType.getCircuitType(13)};
    public static final TdmProtocolType SONET = new TdmProtocolType(0, "SONET", supportedSonetCktTypes, 1, 1, 0, 1, 2, 3, 7, 10, 11, SONETTDMTerminology.instance());
    public static final TdmProtocolType SDH = new TdmProtocolType(1, "SDH", supportedSdhCktTypes, 0, 9, 1, 4, 5, 6, 8, 12, 13, SDHTDMTerminology.instance());
    private ICircuitType[] supportedCktTypes = null;
    private int mediumType;
    private int opticalPayloadType;
    private int protocolType;
    private int hoCircuitType;
    private int loCircuitType;
    private int tunnelCircuitType;
    private int loAggCircuitType;
    private int hoVcatCircuitType;
    private int loVcatCircuitType;
    private TDMTerminology terms;
    private String tdmProtocolTypeStr;

    private TdmProtocolType(int n, String string, ICircuitType[] iCircuitTypeArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, TDMTerminology tDMTerminology) {
        super(tdmProtocolTypes, n);
        this.tdmProtocolTypeStr = string;
        this.supportedCktTypes = iCircuitTypeArray;
        this.mediumType = n2;
        this.opticalPayloadType = n3;
        this.protocolType = n4;
        this.hoCircuitType = n5;
        this.loCircuitType = n6;
        this.tunnelCircuitType = n7;
        this.loAggCircuitType = n8;
        this.hoVcatCircuitType = n9;
        this.loVcatCircuitType = n10;
        this.terms = tDMTerminology;
        TdmProtocolType.tdmProtocolTypes[n] = this;
    }

    public static ITdmProtocolType getTdmProtocolType(int n) {
        TdmProtocolType.CheckType(n, range);
        return tdmProtocolTypes[n];
    }

    @Override
    public String getTdmProtocolTypeString() {
        return this.tdmProtocolTypeStr;
    }

    @Override
    public ICircuitType[] getSupportedCircuitTypes() {
        return this.supportedCktTypes;
    }

    @Override
    public int getMediumType() {
        return this.mediumType;
    }

    @Override
    public int getOpticalPayloadType() {
        return this.opticalPayloadType;
    }

    public static boolean isSonet(int n) {
        return TdmProtocolType.getTdmProtocolType(n).isSonet();
    }

    @Override
    public boolean isSonet() {
        return this.protocolType == 0;
    }

    @Override
    public boolean isSdh() {
        return this.protocolType == 1;
    }

    @Override
    public int getHoCircuitType() {
        return this.hoCircuitType;
    }

    @Override
    public int getLoCircuitType() {
        return this.loCircuitType;
    }

    @Override
    public int getTunnelCircuitType() {
        return this.tunnelCircuitType;
    }

    @Override
    public int getAggCircuitType() {
        return this.loAggCircuitType;
    }

    @Override
    public int getHoVcatCircuitType() {
        return this.hoVcatCircuitType;
    }

    @Override
    public int getLoVcatCircuitType() {
        return this.loVcatCircuitType;
    }

    @Override
    public TDMTerminology getTDMTerminology() {
        return this.terms;
    }
}

