/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.helper;

import cerent.cms.model.IEqType;
import cerent.util.DebugManager;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EqTypeHelper {
    private static Map eqTypeStringMap = new HashMap();
    private static Map eqTypeStringMap0470 = new HashMap();

    public static final String eqType2Name(TDMTerminology tDMTerminology, int n) {
        String[] stringArray = EqTypeHelper.getEqTypeStrings(tDMTerminology);
        return n != -1 ? stringArray[n] : null;
    }

    public static final String eqTypeToName(TDMTerminology tDMTerminology, int n) {
        String[] stringArray = EqTypeHelper.getEqTypeNames(tDMTerminology);
        return n != -1 ? stringArray[n] : null;
    }

    private static String[] buildEqTypeNames(TDMTerminology tDMTerminology) {
        String[] stringArray = EnumStrings.getStrings(IEqType.class);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("DS3")) {
                stringArray[i] = "DS3_PORT";
            } else if (stringArray[i].equals("AD_1C_CARD")) {
                stringArray[i] = "OADM 1 channel";
            } else if (stringArray[i].equals("AD_2C_CARD")) {
                stringArray[i] = "OADM 2 channels";
            } else if (stringArray[i].equals("AD_4C_CARD")) {
                stringArray[i] = "OADM 4 channels";
            } else if (stringArray[i].equals("AD_1B_CARD")) {
                stringArray[i] = "OADM 1 band";
            } else if (stringArray[i].equals("AD_4B_CARD")) {
                stringArray[i] = "OADM 4 bands";
            } else if (stringArray[i].equals("OSC_CSM_CARD")) {
                stringArray[i] = "OSC + Combiner/Separator";
            } else if (stringArray[i].equals("MMU_CARD")) {
                stringArray[i] = "MMU";
            } else if (stringArray[i].equals("OSCM_CARD")) {
                stringArray[i] = "OSC Module";
            } else if (stringArray[i].equals("MUX32_O_CARD")) {
                stringArray[i] = "32 MUXO";
            } else if (stringArray[i].equals("DMX32_O_CARD")) {
                stringArray[i] = "32 DMXO";
            } else if (stringArray[i].equals("WXC40_LINE_CARD")) {
                stringArray[i] = "40 WXC";
            } else if (stringArray[i].equals("WXC40_L_LINE_CARD")) {
                stringArray[i] = "40 WXC L";
            } else if (stringArray[i].equals("WXC80_C_LINE_CARD")) {
                stringArray[i] = "80 WXC C";
            } else if (stringArray[i].equals("WSS_32_CARD")) {
                stringArray[i] = "32 WSS";
            } else if (stringArray[i].equals("WSS40_LINE_CARD")) {
                stringArray[i] = "40 WSS C";
            } else if (stringArray[i].equals("WSS40_L_LINE_CARD")) {
                stringArray[i] = "40 WSS L";
            } else if (stringArray[i].equals("MUX_DMX4_CARD")) {
                stringArray[i] = "4MD";
            } else if (stringArray[i].equals("DMX32_R_CARD")) {
                stringArray[i] = "32 DMX";
            } else if (stringArray[i].equals("DMX40_LINE_CARD")) {
                stringArray[i] = "40 DMX C";
            } else if (stringArray[i].equals("MUX40_LINE_CARD")) {
                stringArray[i] = "40 MUX";
            } else if (stringArray[i].equals("DMX40_L_LINE_CARD")) {
                stringArray[i] = "40 DMX L";
            } else if (stringArray[i].equals("MUX40_L_LINE_CARD")) {
                stringArray[i] = "40 MUX L";
            } else if (stringArray[i].equals("OPT_PRE")) {
                stringArray[i] = "Optical preamplifier";
            } else if (stringArray[i].equals("OPT_BST")) {
                stringArray[i] = "Optical booster";
            } else if (stringArray[i].equals("OPT_BST_L")) {
                stringArray[i] = "Optical booster L";
            } else if (stringArray[i].equals("OPT_AMP_L")) {
                stringArray[i] = "Optical amplifier L";
            } else if (stringArray[i].equals("OPT_AMP_17_C_LINE_CARD")) {
                stringArray[i] = "OPT-AMP 17";
            } else if (stringArray[i].equals("OPT_AMP_23_C_LINE_CARD")) {
                stringArray[i] = "OPT-AMP 23";
            } else if (stringArray[i].equals("OPT_AMP_C")) {
                stringArray[i] = "OPT-AMP C";
            } else if (stringArray[i].equals("OPT_RAMP_CARD")) {
                stringArray[i] = "OPT-RAMP C";
            } else if (stringArray[i].equals("OPT_RAMP_CARD_E")) {
                stringArray[i] = "OPT-RAMP CE";
            } else if (stringArray[i].equals("DMX32_L_CARD")) {
                stringArray[i] = "32 DMX L";
            } else if (stringArray[i].equals("WSS32_L_CARD")) {
                stringArray[i] = "32 WSS L";
            } else if (stringArray[i].equals("OPT_BST_E")) {
                stringArray[i] = "Optical booster ENH";
            } else if (stringArray[i].equals("SMR1_40_C_LINE_CARD")) {
                stringArray[i] = "40 SMR1 C";
            } else if (stringArray[i].equals("SMR2_40_C_LINE_CARD")) {
                stringArray[i] = "40 SMR2 C";
            } else if (stringArray[i].equals("SMR1_80_C_LINE_CARD")) {
                stringArray[i] = "80 SMR1 C";
            } else if (stringArray[i].equals("PASSIVE_PP_4_SMR")) {
                stringArray[i] = "MESH-PP-SMR";
            } else if (stringArray[i].startsWith("PASSIVE_")) {
                stringArray[i] = stringArray[i].replace("_", " ");
            } else if (stringArray[i].equals("MECH_UNIT")) {
                stringArray[i] = "MECH UNIT";
            } else if (stringArray[i].equals("XC192_CARD")) {
                stringArray[i] = "XC10G";
            } else if (stringArray[i].equals("XCVXL_CARD")) {
                stringArray[i] = "XCVXL (10G)";
            } else if (stringArray[i].equals("XCVXL25G_CARD")) {
                stringArray[i] = "XCVXL (2.5G)";
            } else if (stringArray[i].equals("BIC_UNKNOWN")) {
                stringArray[i] = "BIC_UNEQPT";
            } else if (stringArray[i].equals("XCVXC_CARD")) {
                stringArray[i] = "XCVXC (10G)";
            } else if (stringArray[i].equals("FCMR_PORT")) {
                stringArray[i] = "FC-MR Port";
            } else if (stringArray[i].equals("ML2_EXIGE_MAPPER_CARD")) {
                stringArray[i] = "CE-100T-8";
            } else if (stringArray[i].equals("XP_10GE_LINE_CARD")) {
                stringArray[i] = "10GE_XP";
            } else if (stringArray[i].equals("XP_GE_LINE_CARD")) {
                stringArray[i] = "GE_XP";
            } else if (stringArray[i].equals("XP_4_10G_LINE_CARD")) {
                stringArray[i] = "OTU2_XP";
            } else if (stringArray[i].equals("XT_40G_LINE_CARD")) {
                stringArray[i] = "40G-TXP-C";
            } else if (stringArray[i].equals("XM_40G_LINE_CARD")) {
                stringArray[i] = "40G-MXP-C";
            } else if (stringArray[i].equals("XM_40G_CE_LINE_CARD")) {
                stringArray[i] = "40E-MXP-C";
            } else if (stringArray[i].equals("XT_40E_LINE_CARD")) {
                stringArray[i] = "40E-TXP-C";
            } else if (stringArray[i].equals("CE1000_4_CARD")) {
                stringArray[i] = "CE-1000-4";
            } else if (stringArray[i].equals("CE_1000_ETHER_PORT")) {
                stringArray[i] = "CE-1000-4 Ether Port";
            } else if (stringArray[i].equals("CEMR_454_CARD")) {
                stringArray[i] = "CE-MR-10";
            } else if (stringArray[i].equals("CEMR_310_CARD")) {
                stringArray[i] = "CE-MR-6";
            } else if (stringArray[i].equals("MLMR_454_CARD")) {
                stringArray[i] = "ML-MR-10";
            } else if (stringArray[i].equals("MS_ISC_100T_CARD")) {
                stringArray[i] = "MS-ISC-100T";
            } else if (stringArray[i].equals("FTDCU_CARD")) {
                stringArray[i] = "F TDCU";
            } else if (stringArray[i].equals("CTDCU_CARD")) {
                stringArray[i] = "C TDCU";
            } else {
                int n = stringArray[i].indexOf("_LINE_CARD");
                if (n >= 0) {
                    stringArray[i] = stringArray[i].substring(0, n);
                    if (stringArray[i].equals("EPOS_100")) {
                        stringArray[i] = "ETH100";
                    } else if (stringArray[i].equals("EPOS_1000")) {
                        stringArray[i] = "ETH1000";
                    } else if (stringArray[i].equals("ML2_MAPPER")) {
                        stringArray[i] = "CE-100T-8";
                    } else if (stringArray[i].equals("ML2_L2L3")) {
                        stringArray[i] = "ML-100T-8";
                    } else if (stringArray[i].equals("L2SC_100")) {
                        stringArray[i] = "ML100T";
                    } else if (stringArray[i].equals("L2SC_GIG")) {
                        stringArray[i] = "ML1000";
                    } else if (stringArray[i].equals("ML_FX_100")) {
                        stringArray[i] = "ML100X-8";
                    } else if (stringArray[i].equals("MXP_2_5G_10G")) {
                        stringArray[i] = "MXP_2.5G_10G";
                    } else if (stringArray[i].equals("MXP_2_5G_10E")) {
                        stringArray[i] = "MXP_2.5G_10E";
                    } else if (stringArray[i].equals("TXP_MR_2_5G")) {
                        stringArray[i] = "TXP_MR_2.5G";
                    } else if (stringArray[i].equals("TXPP_MR_2_5G")) {
                        stringArray[i] = "TXPP_MR_2.5G";
                    } else if (stringArray[i].equals("MXP_MR_2_5G")) {
                        stringArray[i] = "MXP_MR_2.5G";
                    } else if (stringArray[i].equals("MXPP_MR_2_5G")) {
                        stringArray[i] = "MXPP_MR_2.5G";
                    } else if (stringArray[i].equals("FCMR")) {
                        stringArray[i] = "FC-MR";
                    } else if (stringArray[i].equals("MXP_2_5G_10X")) {
                        stringArray[i] = "MXP_2.5G_10X";
                    } else if (stringArray[i].equals("ADM_10G")) {
                        stringArray[i] = "ADM_10G";
                    }
                    int n2 = -1;
                    if (stringArray[i].equals("OC3")) {
                        n2 = 0;
                    } else if (stringArray[i].equals("OC3_8")) {
                        n2 = 12;
                    } else if (stringArray[i].equals("OC12")) {
                        n2 = 1;
                    } else if (stringArray[i].equals("OC12_4")) {
                        n2 = 11;
                    } else if (stringArray[i].equals("OC48")) {
                        n2 = 2;
                    } else if (stringArray[i].equals("OC48_16")) {
                        n2 = 14;
                    } else if (stringArray[i].equals("OC192")) {
                        n2 = 3;
                    } else if (stringArray[i].equals("OC192_XFP")) {
                        n2 = 16;
                    } else if (stringArray[i].equals("OC192_4")) {
                        n2 = 15;
                    } else if (stringArray[i].equals("OC192_4_DWDM")) {
                        n2 = 19;
                    } else if (stringArray[i].equals("DS1_28_DS3_EC1_3")) {
                        n2 = 20;
                    } else if (stringArray[i].equals("DS1_84_DS3_EC1_3")) {
                        n2 = 21;
                    } else if (stringArray[i].equals("OC768")) {
                        n2 = 22;
                    }
                    if (n2 != -1) {
                        try {
                            stringArray[i] = tDMTerminology.getCardName(n2);
                        }
                        catch (Exception exception) {
                            DebugManager.printStackTrace((Throwable)exception);
                        }
                    }
                } else if (stringArray[i].equals("CTX_2500_CARD")) {
                    stringArray[i] = "CTX 2500";
                } else {
                    n = stringArray[i].indexOf("_CARD");
                    if (n >= 0) {
                        String string;
                        try {
                            string = tDMTerminology.getCardName(4);
                        }
                        catch (Exception exception) {
                            string = "XCVT";
                        }
                        stringArray[i] = stringArray[i].startsWith(string) ? string : stringArray[i].replaceFirst("_CARD", "");
                    } else if (stringArray[i].equals("PPM_SLOT")) {
                        stringArray[i] = "PPM Slot";
                    } else if (stringArray[i].equals("DWDM_CLIENT_PORT")) {
                        stringArray[i] = "Client";
                    } else if (stringArray[i].equals("DWDM_TRUNK_PORT")) {
                        stringArray[i] = "Trunk";
                    } else if (stringArray[i].equals("INTERLINK_TRUNK_PORT")) {
                        stringArray[i] = "Interlink";
                    } else if (stringArray[i].equals("PPM_1_PORT")) {
                        stringArray[i] = "PPM (1 Port)";
                    } else if (stringArray[i].equals("PPM_4_PORT")) {
                        stringArray[i] = "PPM (4 Port)";
                    } else if (stringArray[i].equals("ISC_PORT")) {
                        stringArray[i] = "ISC COMPAT";
                    } else if (stringArray[i].equals("ISC3_PORT")) {
                        stringArray[i] = "ISC PEER";
                    } else if (stringArray[i].equals("ISC3_1G_PORT")) {
                        stringArray[i] = "ISC3 PEER 1G";
                    } else if (stringArray[i].equals("ISC3_2G_PORT")) {
                        stringArray[i] = "ISC3 PEER 2G";
                    } else if (stringArray[i].equals("ISC1_PORT")) {
                        stringArray[i] = "ISC1";
                    } else {
                        n = stringArray[i].indexOf("_VT_MAPPED");
                        if (n >= 0) {
                            stringArray[i] = stringArray[i].substring(0, n) + "_PORT";
                        } else if (stringArray[i].equals("INVALID")) {
                            stringArray[i] = "";
                        } else if (stringArray[i].equals("UNPROVISIONED")) {
                            stringArray[i] = "UNASSIGNED";
                        } else if (stringArray[i].startsWith("OC") && stringArray[i].endsWith("_PORT")) {
                            int n3 = -1;
                            if (stringArray[i].equals("OC3_PORT")) {
                                n3 = 0;
                            } else if (stringArray[i].equals("OC12_PORT")) {
                                n3 = 1;
                            } else if (stringArray[i].equals("OC48_PORT")) {
                                n3 = 2;
                            } else if (stringArray[i].equals("OC192_PORT")) {
                                n3 = 3;
                            } else if (stringArray[i].equals("OC768_PORT")) {
                                n3 = 22;
                            }
                            if (n3 != -1) {
                                try {
                                    stringArray[i] = tDMTerminology.getCardName(n3) + "_PORT";
                                }
                                catch (Exception exception) {
                                    DebugManager.printStackTrace((Throwable)exception);
                                }
                            }
                        } else if (stringArray[i].equals("BIC_CMN")) {
                            stringArray[i] = "CHASSIS";
                        } else if (stringArray[i].equals("CHASSIS_CRS")) {
                            stringArray[i] = "CHASSIS CRS";
                        } else if (stringArray[i].equals("CRS_SLOT")) {
                            stringArray[i] = "CRS SLOT";
                        } else if (stringArray[i].equals("FOUR_10GE_PLIM")) {
                            stringArray[i] = "4x10GE PLIM";
                        } else if (stringArray[i].equals("PLIM_Optic_Port")) {
                            stringArray[i] = "PLIM Optic Port";
                        } else if (stringArray[i].equals("OC768_PLIM")) {
                            stringArray[i] = "OC768 PLIM";
                        } else if (stringArray[i].equals("Route_Processor")) {
                            stringArray[i] = "Route Processor";
                        } else if (stringArray[i].equals("CHASSIS_M6_ANSI")) {
                            stringArray[i] = "15454 M6 ANSI";
                        } else if (stringArray[i].equals("CHASSIS_M6_ETSI")) {
                            stringArray[i] = "15454 M6 ETSI";
                        } else if (stringArray[i].equals("CHASSIS_M2_ANSI")) {
                            stringArray[i] = "15454 M2 ANSI";
                        } else if (stringArray[i].equals("CHASSIS_M2_ETSI")) {
                            stringArray[i] = "15454 M2 ETSI";
                        }
                    }
                }
            }
            if (stringArray[i].indexOf("_UTS") == -1) continue;
            stringArray[i] = stringArray[i].replaceAll("_UTS", "");
        }
        return stringArray;
    }

    protected static String[] getEqTypeStrings(TDMTerminology tDMTerminology) {
        String[] stringArray = (String[])eqTypeStringMap0470.get(tDMTerminology);
        if (stringArray == null) {
            String[] stringArray2 = EqTypeHelper.getEqTypeNames(tDMTerminology);
            stringArray = new String[stringArray2.length];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray[143] = "FC_MR";
            eqTypeStringMap0470.put(tDMTerminology, stringArray);
        }
        return stringArray;
    }

    public static String[] getEqTypeNames(TDMTerminology tDMTerminology) {
        String[] stringArray = (String[])eqTypeStringMap.get(tDMTerminology);
        if (stringArray == null) {
            stringArray = EqTypeHelper.buildEqTypeNames(tDMTerminology);
            eqTypeStringMap.put(tDMTerminology, stringArray);
        }
        return stringArray;
    }

    public static void printEqTypeNames(KDebug kDebug, TDMTerminology tDMTerminology) {
        String[] stringArray = EqTypeHelper.getEqTypeNames(tDMTerminology);
        for (int i = 0; i < stringArray.length; ++i) {
            kDebug.fine(i + 1 + ": " + stringArray[i]);
        }
    }

    public static final int cardEqType2portEqType(int n) {
        switch (n) {
            case 28: 
            case 29: 
            case 30: 
            case 61: 
            case 302: {
                return n;
            }
            case 9: 
            case 106: 
            case 124: {
                return 28;
            }
            case 10: 
            case 85: {
                return 29;
            }
            case 11: 
            case 87: 
            case 126: {
                return 30;
            }
            case 60: 
            case 86: 
            case 220: {
                return 61;
            }
        }
        return -1;
    }

    public static final List cardEqType2PortEqTypes(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        switch (n) {
            case 28: 
            case 29: 
            case 30: 
            case 61: 
            case 302: {
                arrayList.add(new Integer(n));
                break;
            }
            case 9: 
            case 106: 
            case 124: {
                arrayList.add(new Integer(28));
                break;
            }
            case 10: 
            case 85: {
                arrayList.add(new Integer(29));
                break;
            }
            case 11: 
            case 87: 
            case 126: {
                arrayList.add(new Integer(30));
                break;
            }
            case 60: 
            case 86: 
            case 220: {
                arrayList.add(new Integer(61));
                break;
            }
            case 219: 
            case 253: 
            case 254: {
                arrayList.add(new Integer(29));
                arrayList.add(new Integer(30));
                arrayList.add(new Integer(61));
            }
        }
        return arrayList;
    }

    public static final String getPortRateString(TDMTerminology tDMTerminology, int n) {
        String string = EqTypeHelper.eqType2Name(tDMTerminology, n);
        int n2 = string.indexOf("_PORT");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        return string;
    }
}

