/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.helper;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.KDebug;
import java.awt.Font;
import java.util.regex.Pattern;

public class OsiHelper {
    private static final String notHex = "[^\\p{XDigit}]";
    public static final String DOT = ".";
    public static final String DOT_REG = "\\.";
    public static final Font FIXED_WIDTH_FONT = new Font("Arial", 1, 12);
    private static final KDebug db = new KDebug("OsiHelper");

    private OsiHelper() {
    }

    public static String getAreaAddressString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            Byte by = new Byte(byArray[i]);
            int n = by.intValue() & 0xFF;
            if (n <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
            if (byArray.length != 13 || i != 0 && i != 2 && i != 3 && i != 6 && i != 8 && i != 10) continue;
            stringBuffer.append(DOT);
        }
        return stringBuffer.toString();
    }

    public static String getAreaAddressString(Byte[] byteArray) {
        byte[] byArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            byArray[i] = byteArray[i];
        }
        return OsiHelper.getAreaAddressString(byArray);
    }

    public static String getSystemIdString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            Byte by = new Byte(byArray[i]);
            int n = by.intValue() & 0xFF;
            if (n <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
        }
        return stringBuffer.toString();
    }

    public static String getNsapString(byte[] byArray) {
        return OsiHelper.getNsapString(byArray, byArray.length == 20);
    }

    public static String getNsapString(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            Byte by = new Byte(byArray[i]);
            int n = by.intValue() & 0xFF;
            if (n <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n).toUpperCase());
            if (!bl || i != 0 && i != 2 && i != 3 && i != 6 && i != 8 && i != 10 && i != 12 && i != 18) continue;
            stringBuffer.append(DOT);
        }
        return stringBuffer.toString();
    }

    public static boolean isValidAreaAddressString(String string) {
        boolean bl = true;
        String string2 = string.replaceAll(DOT_REG, "");
        if (Pattern.compile(notHex).matcher(string2).find()) {
            db.fine("Address needs allHex");
            bl = false;
        }
        if (string2.length() < 2 || string2.length() > 26) {
            db.fine("Address must be between 1 and 13 bytes");
            bl = false;
        }
        return bl;
    }

    public static boolean isValidNsapString(String string) {
        boolean bl = true;
        String string2 = string.replaceAll(DOT_REG, "");
        if (Pattern.compile(notHex).matcher(string2).find()) {
            db.fine("NSAP needs allHex");
            bl = false;
        }
        if (string2.length() < 16 || string2.length() > 40) {
            db.fine("NSAP must be between 8 and 20 bytes");
            bl = false;
        }
        return bl;
    }

    public static String formatAreaAddressString(String string) {
        try {
            return OsiHelper.getAreaAddressString(OsiHelper.getAreaAddressBytes(string));
        }
        catch (Exception exception) {
            return "!ERROR!";
        }
    }

    public static byte[] getNsapBytes(String string) throws Exception {
        if ((string = string.replaceAll(DOT_REG, "")).length() % 2 != 0) {
            throw new Exception("The NSAP address is invalid. The string is not an even number of characters.");
        }
        if (string.length() < 16 || string.length() > 40) {
            throw new Exception("The NSAP address is invalid. It must be between 8 and 20 bytes.");
        }
        if (Pattern.compile(notHex).matcher(string).find()) {
            throw new Exception("The NSAP address is invalid. It contains non-hex characters.");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 2);
            byArray[n] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
            ++i;
            ++n;
        }
        return byArray;
    }

    public static byte[] getAreaAddressBytes(String string) throws Exception {
        if ((string = string.replaceAll(DOT_REG, "")).length() % 2 != 0) {
            throw new Exception("The area address is invalid. The string is not even.");
        }
        if (string.length() < 2 || string.length() > 26) {
            throw new Exception("The area address is invalid. It must be between 1 and 13 bytes.");
        }
        if (Pattern.compile(notHex).matcher(string).find()) {
            throw new Exception("The area address is invalid. It contains non-hex characters.");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 2);
            byArray[n] = (byte)(Integer.parseInt(string2, 16) & 0xFF);
            ++i;
            ++n;
        }
        return byArray;
    }

    public static String dccIndexToSlotPort(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException {
        return OsiHelper.dccIndexToSlotPort(iNodeModel, n, false);
    }

    public static String dccIndexToSlotPort(INodeModel iNodeModel, int n, boolean bl) throws AbstractCmsNoSuchEntityException {
        String string = "??";
        if (n == 0) {
            string = "N/A";
        } else {
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            IPortModel iPortModel = null;
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            if (iEntityModel instanceof IPortModel) {
                iPortModel = (IPortModel)iEntityModel;
            }
            if (iPortModel != null) {
                string = bl ? "Slot " + String.valueOf(iPortModel.getSlot()) + ", Port " + PortHelper.getPortNumString(iPortModel) : String.valueOf(iPortModel.getSlot()) + "/" + PortHelper.getPortNumString(iPortModel);
            }
        }
        return string;
    }

    public static String getRouterId(short s, byte[] byArray, byte[] byArray2) {
        return "Router " + s + " [" + OsiHelper.getAreaAddressString(byArray) + " " + OsiHelper.getSystemIdString(byArray2) + "]";
    }
}

