/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.TDMTerminology;
import java.util.Arrays;

public class SONETTDMTerminology
extends TDMTerminology {
    String[] FrameTerms_ = new String[]{"STS 1", "STS 3c"};
    String[] VirtualContainerTerms_ = new String[]{"", "", "VT-6", "VT-2", "VT-1.5"};
    String[] VGroupTerms_ = new String[]{"VT GROUP", "VC GROUP"};
    String[] CardNames_ = new String[]{"OC3", "OC12", "OC48", "OC192", "XCVT", "DS1", "DS1N", "DS3", "DS3N", "DS3I", "DS3IN", "OC12_4", "OC3_8", "", "OC48_16", "OC192_4", "OC192XFP", "", "XCVXC", "OC192_4_DWDM", "DS1_28_DS3_EC1_3", "DS1_84_DS3_EC1_3", "OC768"};
    String[] PmStats_ = new String[]{"FC", "CV", "ES", "SES", "SEFS", "", "", "", "", "UAS", "PPJC-PDET", "NPJC-PDET", "PPJC-PGEN", "NPJC-PGEN", "PSC", "PSD", "PSC-W", "PSD-W", "PSC-S", "PSD-S", "PSC-R", "PSD-R", "LOSS", "AISS", "SAS", "LBC", "OPT", "OPR", "PJCDIFF", "PJCS-PDET", "PJCS-PGEN"};
    String[] PmStatTypes_ = new String[]{"S", "L", "LFE", "P", "PFE", "V", "VFE", "L", "LFE", "P", "PFE", "", "P", "P"};
    String[] GeneralTerms_ = new String[]{"STS", "VT", "Line", "Section", "SONET", "VTT", "VAP", "STS", "SDCC", "PDI-P", "LDCC"};
    String[] RingTerms_ = new String[]{"UPSR", "BLSR", "APS"};
    String[] PhysicalLinkTerms_ = new String[]{"OC3", "OC12", "OC48", "OC192", "OC768"};
    String[] LineCoding_ = new String[]{"JBZS", "B8ZS", "HDB3", "AMI", "ZBTSI", "B6ZS", "B3ZS"};
    String[] LinkPhysicalType_ = new String[]{"OC3", "OC12", "OC48", "OC192", "OC768"};
    String[] AddCardType_ = new String[]{"OCn", "DSn", "Ethernet", "nXP", "OADM", "OSC", "AMPLI", "MD", "WXC", "OTHER", "MESH"};
    String[] AddFamilyType_ = new String[]{"DWDM"};
    String[] AdminStateTerms_ = new String[]{"IS", "OOS,DSBLD", "OOS,MT", "IS,AINS", "OOS,OOG"};
    String[] ServiceStateTerms_ = new String[]{"IS-NR", "OOS-AU,AINS", "OOS-MA,DSBLD", "OOS-MA,MT", "OOS-MA,LPBK & MT", "OOS-AU,AINS & MEA", "OOS-AU,AINS & SWDL", "OOS-AU,AINS & UEQ", "OOS-AU,MEA", "OOS-AU,SWDL", "OOS-AU,UEQ", "OOS-AUMA,MEA & MT", "OOS-AUMA,MEA & UAS", "OOS-AUMA,MT & UEQ", "OOS-AUMA,MT & SWDL", "OOS-AUMA,UAS", "OOS-AUMA,UAS & UEQ", "OOS-MA,DSBLD & OOG", "OOS-MA,MT,OOG", "OOS-MA,LPBK & MT & OOG", "OOS-MA,FLT & MT", "OOS-MA,FLT & LPBK & MT", "OOS-AU,FLT", "OOS-AU,AINS & FLT", "OOS-AU,FLT & OOG", "OOS-AUMA,FLT & MT", "OOS-AUMA,FLT & LPBK & MT", "OOS-AUMA,FLT & MT & OOG", "OOS-AUMA,FLT & LPBK & MT & OOG", "OOS-AU,AINS & FLT & OOG", "OOS-MA,FLT & MT & OOG"};
    private String[] NonStandardServiceStateTerms_ = new String[]{"Up", "Down", "IS", "OOS", "OOS,DSBLD", "OOS-AU"};
    String[] PrimaryStateTerms_ = new String[]{"IS", "OOS", "OOS[Partial]", "OOS,OOG", "OOS,OOG[Partial]", "OOS", "OOS[Partial]"};
    String[] NetPartialAdminStateTerms_ = new String[]{"OOS-DSBLD-PARTIAL", "OOS-MT-PARTIAL", "IS-AINS-PARTIAL", "IS-PARTIAL"};
    public int[] circuitTypes = new int[]{0, 1, 2, 3, 7};
    public int highOrderCircuitType = 1;
    public int lowOrderCircuitType = 2;
    public int tunnelCircuitType = 3;
    public int ethernetCircuitType = 0;
    public int loAggCircuitType = 7;
    public int[] circuitSizes = new int[]{0, 1, 2, 3, 7, 4, 27, 8, 25, 5, 32, 6};
    public int[] highOrderCircuitSizes = new int[]{1, 2, 3, 7, 4, 27, 8, 25, 5, 32, 6};
    public int[] lowOrderCircuitSizes = new int[]{0};
    public int baseHighOrderCircuitSize = 1;
    public int tunnelCircuitSize = 1;
    public int ethernetCircuitSize = 1;
    public int loAggCircuitSize = 1;
    protected static SONETTDMTerminology singleton_ = new SONETTDMTerminology();

    public static SONETTDMTerminology instance() {
        return singleton_;
    }

    protected SONETTDMTerminology() {
        this.initialize();
    }

    @Override
    protected void initialize() {
        ((TDMTerminology)this).FrameTerms_ = this.FrameTerms_;
        ((TDMTerminology)this).VirtualContainerTerms_ = this.VirtualContainerTerms_;
        ((TDMTerminology)this).VGroupTerms_ = this.VGroupTerms_;
        ((TDMTerminology)this).CardNames_ = this.CardNames_;
        ((TDMTerminology)this).PmStats_ = this.PmStats_;
        ((TDMTerminology)this).PmStatTypes_ = this.PmStatTypes_;
        ((TDMTerminology)this).GeneralTerms_ = this.GeneralTerms_;
        ((TDMTerminology)this).RingTerms_ = this.RingTerms_;
        ((TDMTerminology)this).PhysicalLinkTerms_ = this.PhysicalLinkTerms_;
        ((TDMTerminology)this).LineCoding_ = this.LineCoding_;
        ((TDMTerminology)this).LinkPhysicalType_ = this.LinkPhysicalType_;
        ((TDMTerminology)this).AddCardType_ = this.AddCardType_;
        ((TDMTerminology)this).AddFamilyType_ = this.AddFamilyType_;
        ((TDMTerminology)this).ServiceStateTerms_ = this.ServiceStateTerms_;
        ((TDMTerminology)this).PrimaryStateTerms_ = this.PrimaryStateTerms_;
        ((TDMTerminology)this).AdminStateTerms_ = this.AdminStateTerms_;
        ((TDMTerminology)this).NetPartialAdminStateTerms_ = this.NetPartialAdminStateTerms_;
        this.NonStandardServiceStateTerms = this.NonStandardServiceStateTerms_;
        this.ethernetTerm = "STS";
    }

    @Override
    protected void staticInitialize() {
        Arrays.sort(this.circuitTypes);
        Arrays.sort(this.circuitSizes);
        Arrays.sort(this.highOrderCircuitSizes);
        Arrays.sort(this.lowOrderCircuitSizes);
        TDMTerminology.circuitTypes = this.circuitTypes;
        TDMTerminology.highOrderCircuitType = this.highOrderCircuitType;
        TDMTerminology.lowOrderCircuitType = this.lowOrderCircuitType;
        TDMTerminology.tunnelCircuitType = this.tunnelCircuitType;
        TDMTerminology.ethernetCircuitType = this.ethernetCircuitType;
        TDMTerminology.loAggCircuitType = this.loAggCircuitType;
        TDMTerminology.circuitSizes = this.circuitSizes;
        TDMTerminology.highOrderCircuitSizes = this.highOrderCircuitSizes;
        TDMTerminology.lowOrderCircuitSizes = this.lowOrderCircuitSizes;
        TDMTerminology.baseHighOrderCircuitSize = this.baseHighOrderCircuitSize;
        TDMTerminology.tunnelCircuitSize = this.tunnelCircuitSize;
        TDMTerminology.ethernetCircuitSize = this.ethernetCircuitSize;
        TDMTerminology.loAggCircuitSize = this.loAggCircuitSize;
        this.ethernetTerm = "STS";
    }

    @Override
    public String getTdmHoTerm(int n) {
        return "STS";
    }

    @Override
    public String createPmColumnName(int n, int n2) {
        String string;
        try {
            string = this.getPmStatType(n) == "" ? this.getPmStat(n2) : this.getPmStat(n2) + "-" + this.getPmStatType(n);
        }
        catch (Exception exception) {
            string = "EMPTY";
        }
        return string;
    }

    @Override
    public String getBackplaneTerm(boolean bl) {
        String string = bl ? "Backplane" : "backplane";
        return string;
    }

    @Override
    public String getUnitSizedTdmHOTerm() {
        return "STS-1";
    }

    @Override
    public String getDs1PortStringTerm(int n, int n2) {
        switch (n / 28) {
            case 0: {
                return "(1-28)";
            }
            case 1: {
                return "(29-56)";
            }
            case 2: {
                return "(57-84)";
            }
        }
        return "";
    }
}

