/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.HelpMgr;
import cerent.util.KDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;

public class HelpMaintDialog
extends JDialog
implements ActionListener {
    public static final String TITLE = "Remove User Manuals";
    public static final String REMOVE = "Remove...";
    public static final String CLOSE = "Close";
    private JButton removeButton;
    private JButton closeButton;
    private DefaultListModel helpListModel;
    private JList helpList;
    private static Object[][] PROTOTYPE_STRING = new Object[][]{{"Cisco ONS 15454 Release 3.3 XXXXXXXXXX", "15454_03_30"}};
    private static int LIST_ROW_COUNT = 6;
    public static final KDebug db = new KDebug("HelpMaintDialog");

    public HelpMaintDialog(Frame frame) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpMaintDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JComponent getMainPanel() {
        this.helpListModel = new DefaultListModel();
        this.populateList();
        this.helpList = new JList(this.helpListModel);
        this.helpList.setPrototypeCellValue(PROTOTYPE_STRING);
        this.helpList.setCellRenderer(new HelpBookRenderer());
        this.helpList.setVisibleRowCount(LIST_ROW_COUNT);
        return new UScrollPane(this.helpList);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.removeButton = this.makeActionButton(REMOVE);
        jPanel.add(this.removeButton);
        this.closeButton = this.makeActionButton(CLOSE);
        jPanel.add(this.closeButton);
        return jPanel;
    }

    private void populateList() {
        this.helpListModel.clear();
        TreeMap treeMap = HelpMgr.getHelpDocDirs();
        Set set = treeMap.entrySet();
        for (Map.Entry entry : set) {
            Object[][] objectArray = new Object[1][2];
            objectArray[0][0] = (String)entry.getKey();
            objectArray[0][1] = (String)entry.getValue();
            this.helpListModel.addElement(objectArray);
        }
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.removeButton) {
            try {
                this.deleteSelectedHelpBooks();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        } else if (object == this.closeButton) {
            this.dispose();
        }
    }

    private void deleteSelectedHelpBooks() {
        int n = 0;
        ListSelectionModel listSelectionModel = this.helpList.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        int n2 = listSelectionModel.getMinSelectionIndex();
        int n3 = listSelectionModel.getMaxSelectionIndex();
        if (!CerentDialog.yesNoDialog(this, "Do you really want to remove the selected user manual" + (n2 < n3 ? "s?" : "?"), "Delete User Manuals")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n2; i <= n3; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            try {
                Object[][] objectArray = (Object[][])this.helpListModel.getElementAt(i);
                if (HelpMaintDialog.db.on) {
                    db.println("removing " + (String)objectArray[0][0] + " at " + (String)objectArray[0][1]);
                }
                HelpMgr.removeHelpDocDir((String)objectArray[0][1]);
                this.helpListModel.removeElementAt(i);
                --i;
                continue;
            }
            catch (Exception exception) {
                ++n;
                stringBuffer.append(exception.getMessage());
                stringBuffer.append("\n");
            }
        }
        if (stringBuffer.length() > 0) {
            // empty if block
        }
        listSelectionModel.clearSelection();
        this.populateList();
    }

    class HelpBookRenderer
    extends JLabel
    implements ListCellRenderer {
        public HelpBookRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[][] objectArray = (Object[][])object;
            try {
                this.setText(((String)objectArray[0][0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

