/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.DebugManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JLabel;
import javax.swing.RepaintManager;

public class HtmlContentPrinter
implements Printable {
    private String htmlReport;

    public static void printHtmlContent(String string) {
        new HtmlContentPrinter(string).print();
    }

    public HtmlContentPrinter(String string) {
        this.htmlReport = string;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                DebugManager.printStackTrace((Throwable)printerException);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        JLabel jLabel = new JLabel(this.htmlReport);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        Font font = new Font("Monospaced", 0, 6);
        graphics2D.setFont(font);
        int n2 = 850;
        int n3 = 1100;
        pageFormat.setOrientation(1);
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        jLabel.setBounds(0, 0, n2, n3);
        jLabel.setVerticalAlignment(1);
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(font);
        jLabel.setText(this.htmlReport);
        int n4 = jLabel.getWidth();
        int n5 = jLabel.getHeight();
        double d3 = this.getScaleFactor(pageFormat, jLabel);
        graphics2D.scale(d3, d3);
        graphics2D.translate(d, d2);
        graphics2D.setClip(-1, -1, n2 + 1, n3 + 1);
        jLabel.paint(graphics2D);
        graphics2D.translate(-d, -d2);
        return 0;
    }

    public double getScaleFactor(PageFormat pageFormat, Component component) {
        double d = 1.0;
        double d2 = pageFormat.getImageableWidth();
        double d3 = pageFormat.getImageableHeight();
        double d4 = component.getHeight();
        double d5 = component.getWidth();
        double d6 = 1.0;
        double d7 = 1.0;
        d6 = d2 / d5;
        d7 = d3 / d4;
        d = d6 < d7 ? d6 : d7;
        return d;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

