/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import com.cisco.crs.model.PlimPortId;
import java.io.IOException;

public class CLIG709Action
extends CLIAction {
    private static final String FEC = "fec";
    private static final String STANDARD = "standard";
    private static final String DISABLE = "disable";
    private static final String G709 = "g709";
    private static final String OTU = "otu";
    private static final String THRESHOLD = "threshold";
    private static final String SD_BER = "sd-ber";
    private static String cmdG709Enable = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nshutdown\r\ncommit\r\nno g709 disable\r\ncommit\r\nno shutdown\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdG709Disable = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nshutdown\r\ncommit\r\ng709 disable\r\ncommit\r\nno shutdown\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdStdFecSet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nshutdown\r\ncommit\r\ng709 fec standard\r\ncommit\r\nno shutdown\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdEnhFecSet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nshutdown\r\ncommit\r\nno g709 fec\r\ncommit\r\nno shutdown\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdFecReset = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nshutdown\r\ncommit\r\ng709 fec disable\r\ncommit\r\nno shutdown\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";
    private static String cmdSdBer = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm _Parameter_\r\nshutdown\r\ncommit\r\ng709 otu threshold sd-ber _Parameter2_\r\ncommit\r\nno shutdown\r\ncommit\r\nexit\r\n</Configuration>\r\n</CLI>\r\n</Request>";

    public CLIG709Action(String string) {
        super(string);
        this.cliCmd = new CLICmdRsp[1];
    }

    public CLIG709Action(ITTYSession iTTYSession) {
        this(iTTYSession.getHostname());
    }

    public boolean enableG709(String string) {
        boolean bl = false;
        String string2 = cmdG709Enable.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean enableG709(int n) {
        return this.enableG709(new PlimPortId(n).toString());
    }

    public boolean disableG709(String string) {
        boolean bl = false;
        String string2 = cmdG709Disable.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean disableG709(int n) {
        return this.disableG709(new PlimPortId(n).toString());
    }

    public boolean setStdFEC(String string) {
        boolean bl = false;
        String string2 = cmdStdFecSet.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean setStdFEC(int n) {
        return this.setStdFEC(new PlimPortId(n).toString());
    }

    public boolean setEnhFEC(String string) {
        boolean bl = false;
        String string2 = cmdEnhFecSet.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean setEnhFEC(int n) {
        return this.setEnhFEC(new PlimPortId(n).toString());
    }

    public boolean disableFEC(String string) {
        boolean bl = false;
        String string2 = cmdFecReset.replaceAll("_Parameter_", string);
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean disableFEC(int n) {
        return this.disableFEC(new PlimPortId(n).toString());
    }

    public boolean setSdBer(String string, int n) {
        boolean bl = false;
        String string2 = cmdSdBer.replaceAll("_Parameter_", string).replaceAll("_Parameter2_", Integer.toString(n));
        this.cliCmd[0] = new CLICmdRsp(string2, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        return bl;
    }

    public boolean setSdBer(int n, int n2) {
        return this.setSdBer(new PlimPortId(n).toString(), n2);
    }
}

