/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.cms.model.INodeModel;
import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.TTYException;
import com.cisco.crs.model.PlimPortId;
import java.io.IOException;

public class CLIProactiveProtectionAction
extends CLIAction {
    private static String _PARAM_IF_ = "interface_param";
    private static String _trigger_revert_param = "trigger_param";
    private static String _window_thresh_param = "window_param";
    private static String _value = "value_param";
    private static String _enable_flag = "enable_flag";
    private static String PROACTIVE = "proactive";
    private static String EXEC = "<exec>";
    private static String EXEC_END = "</exec>";
    private static String SHOW = "show";
    private static String cmdProProtectionParamSet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\ncontroller dwdm " + _PARAM_IF_ + " " + PROACTIVE + " " + _trigger_revert_param + " " + _window_thresh_param + " " + _value + "\r\n" + "commit" + "\r\n" + "exit" + "\r\n" + "</Configuration>" + "\r\n" + "</CLI>" + "\r\n" + "</Request>";
    private static String cmdProProtectionEnable = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n<Configuration>\r\n" + _enable_flag + "controller" + " " + "dwdm" + " " + _PARAM_IF_ + " " + PROACTIVE + "\r\n" + "commit" + "\r\n" + "exit" + "\r\n" + "</Configuration>" + "\r\n" + "</CLI>" + "\r\n" + "</Request>";
    private static String showProactiveProtParams = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Request>\r\n<CLI>\r\n" + EXEC + "\r\n" + SHOW + " " + "controller" + " " + "dwdm" + " " + _PARAM_IF_ + " " + PROACTIVE + "\r\n" + EXEC_END + "\r\n" + "</CLI>" + "\r\n" + "</Request>";
    KDebug db = null;
    INodeModel node;

    public CLIProactiveProtectionAction(INodeModel iNodeModel, KDebug kDebug) {
        super(iNodeModel.getHostName());
        this.db = kDebug;
        this.node = iNodeModel;
        this.cliCmd = new CLICmdRsp[1];
    }

    public boolean setRevertWindow(int n, String string) {
        boolean bl = false;
        String string2 = new PlimPortId(n).toString();
        String string3 = cmdProProtectionParamSet.replaceAll(_PARAM_IF_, string2);
        string3 = string3.replaceAll(_trigger_revert_param, "revert");
        string3 = string3.replaceAll(_window_thresh_param, "window");
        string3 = string3.replaceAll(_value, string);
        this.cliCmd[0] = new CLICmdRsp(string3, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        if (this.db.on()) {
            this.db.println("Node " + this.node.getHostName());
            this.db.println(string3 + "\n\n\n\n");
            this.db.println("Result :" + this.cliCmd[0].getResponse());
        }
        return bl;
    }

    public boolean setTriggerThreshold(int n, String string) {
        boolean bl = false;
        String string2 = new PlimPortId(n).toString();
        String string3 = this.getThresholdString(string);
        String string4 = cmdProProtectionParamSet.replaceAll(_PARAM_IF_, string2);
        string4 = string4.replaceAll(_trigger_revert_param, "trigger");
        string4 = string4.replaceAll(_window_thresh_param, "threshold");
        string4 = string4.replaceAll(_value, string3);
        this.cliCmd[0] = new CLICmdRsp(string4, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        if (this.db.on()) {
            this.db.println("Node " + this.node.getHostName());
            this.db.println(string4 + "\n\n\n\n");
            this.db.println("Result :" + this.cliCmd[0].getResponse());
        }
        return bl;
    }

    public boolean setTriggerWindow(int n, String string) {
        boolean bl = false;
        String string2 = new PlimPortId(n).toString();
        String string3 = cmdProProtectionParamSet.replaceAll(_PARAM_IF_, string2);
        string3 = string3.replaceAll(_trigger_revert_param, "trigger");
        string3 = string3.replaceAll(_window_thresh_param, "window");
        string3 = string3.replaceAll(_value, string);
        this.cliCmd[0] = new CLICmdRsp(string3, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        if (this.db.on()) {
            this.db.println("Node " + this.node.getHostName());
            this.db.println(string3 + "\n\n\n\n");
            this.db.println("Result :" + this.cliCmd[0].getResponse());
        }
        return bl;
    }

    public boolean setRevertThreshold(int n, String string) {
        boolean bl = false;
        String string2 = new PlimPortId(n).toString();
        String string3 = this.getThresholdString(string);
        String string4 = cmdProProtectionParamSet.replaceAll(_PARAM_IF_, string2);
        string4 = string4.replaceAll(_trigger_revert_param, "revert");
        string4 = string4.replaceAll(_window_thresh_param, "threshold");
        string4 = string4.replaceAll(_value, string3);
        this.cliCmd[0] = new CLICmdRsp(string4, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        if (this.db.on()) {
            this.db.println("Node " + this.node.getHostName());
            this.db.println(string4 + "\n\n\n\n");
            this.db.println("Result :" + this.cliCmd[0].getResponse());
        }
        return bl;
    }

    public boolean setProactiveProtection(int n, int n2) {
        boolean bl = false;
        String string = new PlimPortId(n).toString();
        String string2 = n2 == 0 ? "no " : "";
        String string3 = cmdProProtectionEnable.replaceAll(_PARAM_IF_, string);
        string3 = string3.replaceAll(_enable_flag, string2);
        this.cliCmd[0] = new CLICmdRsp(string3, true);
        try {
            bl = super.performAction(this.cliCmd[0]);
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (TTYException tTYException) {
            bl = true;
        }
        this.cliCmd[0].setError(bl);
        if (this.db.on()) {
            this.db.println("Node " + this.node.getHostName());
            this.db.println(string3 + "\n\n\n\n");
            this.db.println("Result :" + this.cliCmd[0].getResponse());
        }
        return bl;
    }

    private String getThresholdString(String string) {
        String[] stringArray = string.split("E-");
        String string2 = "";
        if (stringArray.length == 2) {
            string2 = stringArray[0] + " " + stringArray[1];
        }
        return string2;
    }
}

