/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.KDebug;
import cerent.util.Pair;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLICmdRsp;
import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import com.cisco.crs.model.PlimPortId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CLIShowRunAction
extends CLIAction {
    private KDebug db;
    private static final String COMMAND = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><CLI><Exec>show run</Exec></CLI></Request>";

    public CLIShowRunAction(ITTYSession iTTYSession, KDebug kDebug) {
        this(iTTYSession.getHostname(), kDebug);
    }

    public CLIShowRunAction(String string, KDebug kDebug) {
        super(string);
        this.db = kDebug;
        this.cliCmd = new CLICmdRsp[1];
    }

    public Result get() {
        Object object;
        Object object2;
        Document document;
        block17: {
            this.cliCmd[0] = new CLICmdRsp(COMMAND, true);
            try {
                if (super.performAction(this.cliCmd[0])) {
                    if (this.db.on()) {
                        this.db.println("failed to send XML command");
                    }
                    return null;
                }
            }
            catch (IOException iOException) {
                return null;
            }
            catch (TTYException tTYException) {
                return null;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = null;
            try {
                object2 = documentBuilderFactory.newDocumentBuilder();
                object = this.cliCmd[0].getResponse();
                if (object == null) {
                    if (this.db.on) {
                        this.db.println("getResponse()==null");
                    }
                    return null;
                }
                document = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (this.db.on) {
                    this.db.println("ParseConfigurationException while parsing Lmp ID");
                }
            }
            catch (SAXException sAXException) {
                if (this.db.on) {
                    this.db.println("SAXException while parsing Lmp ID");
                }
            }
            catch (IOException iOException) {
                if (!this.db.on) break block17;
                this.db.println("IOException while parsing Lmp ID");
            }
        }
        if (document == null) {
            if (this.db.on) {
                this.db.println("Error while parsing Lmp ID: dom==null");
            }
            return null;
        }
        object2 = document.getDocumentElement();
        object = object2.getElementsByTagName("Exec");
        if (object == null || object.getLength() == 0) {
            if (this.db.on) {
                this.db.println("Error while parsing Lmp ID: <Exec> not found");
            }
            return null;
        }
        String string = ((Element)object.item(0)).getTextContent();
        return new Result(string);
    }

    public static class Result {
        private String text;

        public Result(String string) {
            this.text = string;
        }

        public Pair<String, PlimPortId.PlimType> getLmpNeighborAndType(PlimPortId plimPortId) {
            int n = this.text.indexOf("mpls traffic-eng");
            int n2 = this.text.indexOf("\n!\n", n);
            int n3 = this.text.indexOf("\n interface ", n);
            while (n3 != -1 && n3 < n2) {
                int n4;
                String string;
                int n5 = n3 += 12;
                if ((string = this.text.substring(n5, (n4 = this.text.indexOf("\n !\n", n3)) + 1)).indexOf(plimPortId.getShortString()) != -1) {
                    PlimPortId plimPortId2 = new PlimPortId(this.text.substring(n5, this.text.indexOf("\n", n5)));
                    n5 = string.indexOf("lmp data-link adjacency");
                    if (n5 == -1) {
                        return null;
                    }
                    n4 = string.indexOf("\n  !\n", n5);
                    if (n4 == -1) {
                        return null;
                    }
                    if ((n5 = string.indexOf("\n   neighbor ", n5)) == -1 || n5 > n4) {
                        return null;
                    }
                    return new Pair<String, PlimPortId.PlimType>(string.substring(n5 += "\n   neighbor ".length(), string.indexOf("\n", n5)).trim(), plimPortId2.getType());
                }
                n3 = this.text.indexOf("\n interface", n3);
            }
            return null;
        }

        public String getTtiForPlim(PlimPortId plimPortId) {
            String string = "g709 otu overhead tti sent ascii ";
            int n = this.text.indexOf("\ncontroller dwdm" + plimPortId.getShortString());
            if (n == -1) {
                return null;
            }
            int n2 = this.text.indexOf("\n!\n", n);
            if (n2 == -1) {
                return null;
            }
            if ((n = this.text.indexOf(string, n)) == -1 || n > n2) {
                return null;
            }
            n2 = this.text.indexOf("\n", n);
            return this.text.substring(n, n2);
        }

        public String getConnIdForPlim(PlimPortId plimPortId) {
            String string = "network connection id ";
            int n = this.text.indexOf("\ncontroller dwdm" + plimPortId.getShortString());
            if (n == -1) {
                return null;
            }
            int n2 = this.text.indexOf("\n!\n", n);
            if (n2 == -1) {
                return null;
            }
            if ((n = this.text.indexOf(string, n)) == -1 || n > n2) {
                return null;
            }
            n2 = this.text.indexOf("\n", n);
            return this.text.substring(n, n2);
        }
    }
}

