/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvNodeModel;
import cerent.util.IFvDebug;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewNodeDef;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.SvgParams;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.svg.SVGDocumentReader;
import ilog.views.svg.SVGDocumentReaderConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractSvgFactory
implements IViewNodeDef,
IViewSvg {
    protected static HashMap<Integer, IViewSvg.IViewSvgEnum> SVGFileMap = new HashMap();
    protected static HashMap<String, ViewGraphicSet> SVGCache = new HashMap();
    protected static final int CARD_LAYER = 0;
    protected static final int LABEL_LAYER = 1;
    protected static final int PORT_LAYER = 2;
    protected static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    protected static DocumentBuilder builder = null;
    protected IFvNodeModel nm = null;
    protected static IFvDebug db = null;

    public AbstractSvgFactory(IFvNodeModel iFvNodeModel) {
        db = FunctDebug.instance().addChild("SVGCardFactory", "Dump the info related to FunctView");
        this.nm = iFvNodeModel;
        AbstractSvgFactory.initBuilder();
        this.initSvgHash();
    }

    protected static void initBuilder() {
        if (builder != null) {
            return;
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        builder.setErrorHandler(new Handler());
        builder.setEntityResolver(new SchemaLoader());
    }

    protected abstract void initSvgHash();

    protected static HashMap getSvgFilesMap() {
        return SVGFileMap;
    }

    public abstract IViewGraph getViewElem(SvgParams var1) throws SAXException, IOException, ParserConfigurationException, FunctException;

    public static ViewGraphicSet getSvgShape(IViewSvg.IViewSvgEnum iViewSvgEnum, InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        if (SVGCache.containsKey(iViewSvgEnum.getSvgFullPath())) {
            return AbstractSvgFactory.cloneSvg(SVGCache.get(iViewSvgEnum.getSvgFullPath()));
        }
        ViewGraphicSet viewGraphicSet = AbstractSvgFactory.loadShapeBagFromSVG(inputStream);
        SVGCache.put(iViewSvgEnum.getSvgFullPath(), AbstractSvgFactory.cloneSvg(viewGraphicSet));
        return viewGraphicSet;
    }

    public static ViewGraphicSet cloneSvg(ViewGraphicSet viewGraphicSet) {
        ViewGraphicSet viewGraphicSet2 = new ViewGraphicSet();
        if (viewGraphicSet == null) {
            System.out.print(true);
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = viewGraphicSet.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            IlvGraphic ilvGraphic2 = ilvGraphic.copy();
            ilvGraphic2.setName(ilvGraphic.getName());
            viewGraphicSet2.addObject(ilvGraphic2, false);
        }
        return viewGraphicSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ViewGraphicSet loadShapeBagFromSVG(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        Document document = null;
        ViewGraphicSet viewGraphicSet = null;
        try {
            document = AbstractSvgFactory.parse(inputStream);
            SVGDocumentReaderConfigurator sVGDocumentReaderConfigurator = new SVGDocumentReaderConfigurator();
            SVGDocumentReader sVGDocumentReader = new SVGDocumentReader(sVGDocumentReaderConfigurator);
            viewGraphicSet = new ViewGraphicSet();
            sVGDocumentReader.readDocument(document, (IlvGraphicBag)viewGraphicSet);
        }
        finally {
            inputStream.close();
            return viewGraphicSet;
        }
    }

    protected static Document parse(InputStream inputStream) throws FactoryConfigurationError, ParserConfigurationException, IOException, SAXException {
        return builder.parse(inputStream);
    }

    private static class Handler
    implements ErrorHandler {
        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            ViewManager.addToLog(this, " There was an error in the parsing ");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            ViewManager.addToLog(this, " There was an error in the parsing ");
            sAXParseException.printStackTrace();
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            ViewManager.addToLog(this, " There was an error in the parsing ");
            sAXParseException.printStackTrace();
        }
    }

    private static class SchemaLoader
    implements EntityResolver {
        private SchemaLoader() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            URL uRL = AbstractSvgFactory.class.getClassLoader().getResource("images/svg/svg10.dtd");
            return new InputSource(uRL.openStream());
        }
    }
}

