/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvDwdmTrkLineModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvViewCircuitPath;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.ViewCircuitPathElement;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.helper.FunctDebug;
import com.cisco.fv.grapher.util.LinkBalloon;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.graphic.composite.IlvCompositeLink;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLinkAttachmentLocation;
import ilog.views.sdm.graphic.IlvSDMCompositeLink;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class AbstractViewLink
extends IlvSDMCompositeLink
implements ActionListener,
IViewLink {
    public static int BALLOONS_NUMBER = 2;
    private static int RX = 0;
    private static int TX = 1;
    private LinkBalloon[] powerBalloon;
    private int[] powerBalloonChildIndex;
    protected ViewInternalLink linkModel = null;
    protected IlvGrapher parent = null;
    private String fromName = "";
    private String toName = "";
    private boolean isOnCircuit;
    protected static int serial = 1;
    protected IFvNodeModel nm;
    private int linkId;
    private boolean balloonVisible;
    private List<IFvOptLinkModel> mpoIndexes = new ArrayList<IFvOptLinkModel>(8);
    protected static final String PWR_CMD = "Hide/Show Power";
    protected static final String FLIP_CMD = "Flip Power Balloons";
    public static final String CMD_LINK_DELETE = "Delete Link";
    public static final String POWER_STR_TOKEN = "\r";
    private ViewManagerToolKit tk = null;
    protected IViewGraph fromPort;
    protected IViewGraph toPort;

    public AbstractViewLink(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IFvNodeModel iFvNodeModel, ViewManagerToolKit viewManagerToolKit) {
        super(ilvGraphic, ilvGraphic2, bl);
        this.init(viewManagerToolKit, iFvNodeModel, IlvGrapher.getLowestCommonGrapher((IlvGraphic)ilvGraphic, (IlvGraphic)ilvGraphic2));
    }

    public AbstractViewLink(IViewGraph iViewGraph, IViewGraph iViewGraph2, boolean bl, IFvNodeModel iFvNodeModel, ViewManagerToolKit viewManagerToolKit) {
        super((IlvGraphic)iViewGraph.getGraphParent(), (IlvGraphic)iViewGraph2.getGraphParent(), bl);
        this.fromPort = iViewGraph;
        this.toPort = iViewGraph2;
        this.init(viewManagerToolKit, iFvNodeModel, IlvGrapher.getLowestCommonGrapher((IlvGraphic)((IlvGraphic)iViewGraph.getGraphParent()), (IlvGraphic)((IlvGraphic)iViewGraph2.getGraphParent())));
    }

    private void init(ViewManagerToolKit viewManagerToolKit, IFvNodeModel iFvNodeModel, IlvGrapher ilvGrapher) {
        this.powerBalloon = new LinkBalloon[BALLOONS_NUMBER];
        this.powerBalloonChildIndex = new int[BALLOONS_NUMBER];
        this.balloonVisible = false;
        this.parent = ilvGrapher;
        this.nm = iFvNodeModel;
        this.tk = viewManagerToolKit;
    }

    public abstract void onInitPopupMenu(UPopupMenu var1);

    protected abstract void initPopupMenu(UPopupMenu var1);

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_LINK_DELETE) {
            this.doDelete();
        } else if (string == PWR_CMD) {
            try {
                if (this.nm.isInCircuit()) {
                    IFvViewCircuitPath iFvViewCircuitPath = this.tk.getGraph().getViewManager().getFunctionalCircuitPath();
                    if (this.isOnCircuit()) {
                        this.showInCircuit(iFvViewCircuitPath.getUsedLambda());
                        this.showBalloons();
                        return;
                    }
                }
                this.showAggregated();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                FunctDebug.printStackTrace(abstractCmsNoSuchEntityException);
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace(noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace(wrongInterfaceType);
            }
        } else if (string == FLIP_CMD) {
            this.safeRotateBalloons();
        }
    }

    private void showInCircuit(int n) throws AbstractCmsNoSuchEntityException {
        IFvInterfaceModel iFvInterfaceModel = null;
        IFvPortModel iFvPortModel = (IFvPortModel)this.nm.getEntityModelByIndex(this.getFromPort());
        IFvPortModel iFvPortModel2 = (IFvPortModel)this.nm.getEntityModelByIndex(this.getToPort());
        IFvInterfaceModel iFvInterfaceModel2 = null;
        IFvInterfaceModel iFvInterfaceModel3 = null;
        try {
            iFvInterfaceModel2 = iFvPortModel.getIFvInterfaceModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            iFvInterfaceModel3 = iFvPortModel2.getIFvInterfaceModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iFvInterfaceModel2 != null && iFvInterfaceModel2 instanceof IFvDwdmTrkLineModel) {
            iFvInterfaceModel = ((IFvCardModel)iFvInterfaceModel2.getModuleModel()).getPortConnected(iFvInterfaceModel3, iFvInterfaceModel2);
        } else if (iFvInterfaceModel3 != null && iFvInterfaceModel3 instanceof IFvDwdmTrkLineModel) {
            iFvInterfaceModel = ((IFvCardModel)iFvInterfaceModel3.getModuleModel()).getPortConnected(iFvInterfaceModel3, iFvInterfaceModel2);
        }
        this.setPowerInformation(iFvInterfaceModel3, iFvInterfaceModel2, iFvInterfaceModel, n);
        this.setBalloonVisible(!this.isBalloonVisible());
    }

    protected abstract void showAggregated() throws AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType;

    protected void doDelete() {
        this.tk.delLink(this);
    }

    public void placeBalloons() {
        this.powerBalloon[AbstractViewLink.RX] = new LinkBalloon("", LinkBalloon.PATCH_BASE_COLOR, 20);
        this.powerBalloon[AbstractViewLink.TX] = new LinkBalloon("", LinkBalloon.PATCH_BASE_COLOR, 20);
        for (int i = 0; i < this.powerBalloon.length; ++i) {
            IlvAttachmentConstraint ilvAttachmentConstraint;
            int n;
            int n2 = n = this.getChildren() != null ? this.getChildren().length : 0;
            if (i == RX) {
                this.powerBalloon[i].setOrientation(2);
                ilvAttachmentConstraint = new IlvAttachmentConstraint(IlvAttachmentLocation.BottomCenter, IlvLinkAttachmentLocation.ToLink);
            } else {
                this.powerBalloon[i].setOrientation(6);
                ilvAttachmentConstraint = new IlvAttachmentConstraint(IlvAttachmentLocation.TopCenter, IlvLinkAttachmentLocation.FromLink);
            }
            this.setLayers(n, 20);
            this.powerBalloonChildIndex[i] = n;
            this.safeSetChildren(n, (IlvGraphic)this.powerBalloon[i], n++, ilvAttachmentConstraint);
            this.powerBalloon[i].showIt(false);
        }
    }

    @Override
    public void showBalloons() {
        ViewManagerToolKit viewManagerToolKit = null;
        if (this.parent != null && ((ViewGrapher)this.parent).getViewManager() != null) {
            viewManagerToolKit = ((ViewGrapher)this.parent).getViewManager().getViewTk();
        } else {
            FunctDebug.instance().println("Parent is null problem in power balloon!!!! AbstractViewLink::setBalloonVisible" + this.getFromName() + this.getToName());
        }
        if (this.powerBalloon.length > 0) {
            for (int i = 0; i < this.powerBalloon.length; ++i) {
                if (this.powerBalloon[i] == null) continue;
                if (!this.powerBalloon[i].getLinkLabelStr().equals("") && !this.powerBalloon[i].getLinkLabelStr().equals("null")) {
                    if (viewManagerToolKit == null || !viewManagerToolKit.isZoomLevelVisible()) continue;
                    this.powerBalloon[i].showIt(this.balloonVisible);
                    continue;
                }
                this.powerBalloon[i].showIt(false);
            }
        }
    }

    public void hideBalloons() {
        if (this.powerBalloon.length > 0) {
            for (int i = 0; i < this.powerBalloon.length; ++i) {
                if (this.powerBalloon[i] == null) continue;
                this.powerBalloon[i].showIt(false);
            }
        }
    }

    @Override
    public void setBalloonVisible(boolean bl) {
        this.balloonVisible = bl;
    }

    public boolean areBalloonsVisible() {
        if (this.powerBalloon.length > 0 && this.powerBalloon[1] != null) {
            return this.powerBalloon[1].isVisible();
        }
        return false;
    }

    public void flipBalloon(int n, int n2) {
        if (this.powerBalloon.length > 0) {
            for (int i = 0; i < this.powerBalloon.length; ++i) {
                if (this.powerBalloon[i] == null) continue;
                this.powerBalloon[i].scaleIt(n, n2);
            }
        }
    }

    @Override
    public void setBalloonLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, POWER_STR_TOKEN);
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            if (this.powerBalloon[i] == null) continue;
            this.powerBalloon[i].setLinkLabel(stringTokenizer.nextToken());
        }
    }

    public void setBalloonLabel(String string, int n) {
        if (this.powerBalloon[n] != null) {
            this.powerBalloon[n].setLinkLabel(string);
        }
    }

    @Override
    public String[] getBalloonLabel() {
        String[] stringArray = new String[]{this.powerBalloon[0].getLinkLabelStr(), this.powerBalloon[1].getLinkLabelStr()};
        return stringArray;
    }

    public IlvAttachmentConstraint getPowerBalloonConstraint(int n) {
        return (IlvAttachmentConstraint)this.getConstraints(this.powerBalloonChildIndex[n]);
    }

    @Override
    public ViewInternalLink getLinkModel() {
        return this.linkModel;
    }

    @Override
    public void setLinkModel(ViewInternalLink viewInternalLink) {
        this.linkModel = viewInternalLink;
        if (viewInternalLink == null) {
            this.linkId = ++serial;
        }
    }

    @Override
    public int getFromPort() {
        return this.linkModel.getLink().getFrom();
    }

    @Override
    public int getToPort() {
        return this.linkModel.getLink().getTo();
    }

    @Override
    public int getIndex() {
        if (this.linkModel == null) {
            return this.linkId;
        }
        return this.linkModel.getIndex();
    }

    @Override
    public IlvGrapher getLinkOwner() {
        return this.parent;
    }

    @Override
    public void setFromName(String string) {
        this.fromName = string;
    }

    @Override
    public String getFromName() {
        return this.fromName;
    }

    @Override
    public String getToName() {
        return this.toName;
    }

    @Override
    public void setToName(String string) {
        this.toName = string;
    }

    @Override
    public void setBalloonUnderCircuit(boolean bl) {
        if (this.powerBalloon != null) {
            this.isOnCircuit = bl;
        }
    }

    @Override
    public boolean isOnCircuit() {
        return this.isOnCircuit;
    }

    @Override
    public void setPowerBalloonFontSize(int n) {
        if (this.powerBalloon.length > 0) {
            for (int i = 0; i < this.powerBalloon.length; ++i) {
                if (this.powerBalloon[i] == null) continue;
                Font font = this.powerBalloon[i].getLinkLabel().getFont();
                this.powerBalloon[i].getLinkLabel().setFont(font.deriveFont(n));
            }
        }
    }

    @Override
    public int getPowerBalloonFontSize() {
        return this.powerBalloon[0].getLinkLabel().getFont().getSize();
    }

    public boolean isTxpLink() {
        return false;
    }

    @Override
    public String setPowerInformation(IFvInterfaceModel iFvInterfaceModel, IFvInterfaceModel iFvInterfaceModel2, IFvInterfaceModel iFvInterfaceModel3, int n) {
        String string;
        StringBuffer stringBuffer = new StringBuffer("<html>");
        String[] stringArray = new String[2];
        if (iFvInterfaceModel == null && iFvInterfaceModel2 == null) {
            return null;
        }
        if (iFvInterfaceModel != null) {
            stringArray[0] = ViewCircuitPathElement.getPowerTooltipStr(iFvInterfaceModel, stringBuffer, n);
            stringBuffer.append("<BR>");
            if (stringArray[0] == null) {
                stringArray[0] = "";
            }
        }
        if (iFvInterfaceModel2 != null) {
            stringArray[1] = ViewCircuitPathElement.getPowerTooltipStr(iFvInterfaceModel2, stringBuffer, n);
            if (stringArray[1] == null) {
                stringArray[1] = "";
            }
        }
        if ((string = stringBuffer.toString()) == null) {
            string = "";
        }
        this.setBalloonLabel(stringArray[0] + POWER_STR_TOKEN + stringArray[1]);
        return string;
    }

    public boolean isBalloonVisible() {
        return this.balloonVisible;
    }

    @Override
    public void dispose() {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.setChildren(null);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ((AbstractViewLink)object).setChildren(null);
                }
            }, (Object)this, false);
        }
        if (this.powerBalloon != null) {
            for (int i = 0; i < BALLOONS_NUMBER; ++i) {
                if (this.powerBalloon[i] == null) continue;
                this.powerBalloon[i].dispose();
                this.powerBalloon[i] = null;
            }
            this.powerBalloon = null;
        }
        this.tk = null;
        this.linkModel = null;
        this.parent = null;
        this.nm = null;
    }

    public void safeSetChildren(int n, IlvGraphic ilvGraphic, int n2, IlvAttachmentConstraint ilvAttachmentConstraint) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.setChildren(n, ilvGraphic);
            if (n2 != -1) {
                this.setConstraints(n2, ilvAttachmentConstraint);
            }
        } else {
            IlvManager ilvManager;
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new SetChildren(n, ilvGraphic, n2, ilvAttachmentConstraint), (Object)this, true);
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    public void safeRotateBalloons() {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            for (int i = 0; i < 2; ++i) {
                IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)this.getConstraints(this.powerBalloonChildIndex[i]);
                if (ilvAttachmentConstraint.getHotSpot() == IlvAttachmentLocation.BottomCenter) {
                    ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.TopCenter);
                    this.powerBalloon[i].setOrientation(6);
                } else {
                    ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.BottomCenter);
                    this.powerBalloon[i].setOrientation(2);
                }
                this.setConstraints(this.powerBalloonChildIndex[i], ilvAttachmentConstraint);
            }
            this.doLayout();
        } else {
            IlvManager ilvManager;
            IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(true, true);
            }
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    for (int i = 0; i < 2; ++i) {
                        IlvAttachmentConstraint ilvAttachmentConstraint = (IlvAttachmentConstraint)((AbstractViewLink)ilvGraphic).getConstraints(AbstractViewLink.this.powerBalloonChildIndex[i]);
                        if (ilvAttachmentConstraint.getHotSpot() == IlvAttachmentLocation.BottomCenter) {
                            ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.TopCenter);
                            AbstractViewLink.this.powerBalloon[i].setOrientation(6);
                        } else {
                            ilvAttachmentConstraint.setHotSpot(IlvAttachmentLocation.BottomCenter);
                            AbstractViewLink.this.powerBalloon[i].setOrientation(2);
                        }
                        ((AbstractViewLink)ilvGraphic).setConstraints(AbstractViewLink.this.powerBalloonChildIndex[i], ilvAttachmentConstraint);
                    }
                    ((AbstractViewLink)ilvGraphic).doLayout();
                }
            }, (Object)this, true);
            if (ilvManager != null) {
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    @Override
    public void addMpoIndex(IFvOptLinkModel iFvOptLinkModel) {
        this.mpoIndexes.add(iFvOptLinkModel);
    }

    @Override
    public List<Integer> getMpoIndexes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mpoIndexes.size());
        for (int i = 0; i < this.mpoIndexes.size(); ++i) {
            arrayList.add(this.mpoIndexes.get(i).getIndex());
        }
        return arrayList;
    }

    public List<IFvOptLinkModel> getMpoLinks() {
        return this.mpoIndexes;
    }

    static class SetChildren
    implements IlvApplyObject {
        IlvGraphic children;
        int index;
        int indexConstraints;
        IlvAttachmentConstraint constraints;

        SetChildren(int n, IlvGraphic ilvGraphic, int n2, IlvAttachmentConstraint ilvAttachmentConstraint) {
            this.children = ilvGraphic;
            this.index = n;
            this.indexConstraints = n2;
            this.constraints = ilvAttachmentConstraint;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            ((IlvCompositeLink)ilvGraphic).setChildren(this.index, this.children);
            if (this.indexConstraints != -1) {
                ((IlvCompositeLink)ilvGraphic).setConstraints(this.indexConstraints, (Object)this.constraints);
            }
        }
    }
}

