/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvSideModel;
import cerent.util.IFvDebug;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.AbstractView;
import cerent.util.view.fv.AbstractViewLink;
import cerent.util.view.fv.GrapherViewCommand;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewLinksManager;
import cerent.util.view.fv.IViewManagerView;
import cerent.util.view.fv.IViewPSMCardGrapher;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvg;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAlarmGrapher;
import cerent.util.view.fv.ViewBandDomainGrapher;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewDomainHelper;
import cerent.util.view.fv.ViewFiberGrapher;
import cerent.util.view.fv.ViewGeneralGrapher;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.ViewGrapherLayout;
import cerent.util.view.fv.ViewHalfZoomingGraphic;
import cerent.util.view.fv.ViewInternalLink;
import cerent.util.view.fv.ViewLabel;
import cerent.util.view.fv.ViewLink;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerFlipHelper;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewMultipleLayout;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewShapeInfo;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import cerent.util.view.fv.helper.ViewModelUpdateType;
import com.cisco.fv.grapher.util.LinkBalloon;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.IlvGraphLayoutUtil;
import ilog.views.graphlayout.IlvInappropriateLinkException;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.link.longlink.IlvLongLinkLayout;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public abstract class ViewDomainGrapher
extends ViewGrapher
implements IViewSvg,
IViewLinksManager,
Observer,
TransformerListener,
IViewManagerView {
    private ViewGeneralGrapher childgrapher = null;
    private IlvGraphic domRect = null;
    private boolean labelflipped = false;
    public HashMap<String, ViewPin> allSourceDestination = new HashMap();
    protected IFvNodeModel nm = null;
    protected IViewShapeInfo shape = null;
    protected boolean defaultPosinited = false;
    protected ViewMultipleLayout layout = null;
    protected IViewGraph parent = null;
    protected IViewGraph owner = null;
    protected String key = null;
    protected IFvDebug db = null;
    private boolean mustFlip = true;
    private boolean zoomVisibility;
    public ViewGrapherLayout.GraphPos graphPosition;
    public static final int W = 0;
    public static final int P = 1;
    public static final int MMU = 2;
    public static final int DOMSIDELENGTH = 3;
    protected IViewPSMCardGrapher psmLineorPathPresent = null;
    private double ntwZoom;
    private double nodeZoom;
    protected IFvSideModel[] domSideModel = new IFvSideModel[]{null, null, null};
    protected List<IFvSideModel> otherSides = new ArrayList<IFvSideModel>();
    private boolean sideDomainInActivePath = true;

    public boolean hasExtraSide(IFvSideModel iFvSideModel) {
        for (IFvSideModel iFvSideModel2 : this.otherSides) {
            if (iFvSideModel2.getIndex() != iFvSideModel.getIndex()) continue;
            return true;
        }
        return false;
    }

    public ViewDomainGrapher() {
        super(null);
        this.graphPosition = ViewGrapherLayout.GraphPos.CENTER_1;
    }

    public ViewDomainGrapher(ISvgParams iSvgParams) {
        super(iSvgParams);
        this.zoomVisibility = true;
        this.ntwZoom = 1.0;
        this.nodeZoom = 1.0;
        IlvLongLinkLayout ilvLongLinkLayout = new IlvLongLinkLayout();
        IlvHierarchicalLayout ilvHierarchicalLayout = new IlvHierarchicalLayout();
        this.layout = new ViewMultipleLayout((IlvGraphLayout)ilvLongLinkLayout, ilvHierarchicalLayout);
        ((IlvLongLinkLayout)this.layout.getLinkLayout()).setGlobalLinkStyle(2);
        ((IlvLongLinkLayout)this.layout.getLinkLayout()).setHorizontalGridOffset(15.0f);
        ((IlvLongLinkLayout)this.layout.getLinkLayout()).setVerticalGridOffset(15.0f);
        ((IlvLongLinkLayout)this.layout.getLinkLayout()).setNodeObstacleEnabled(true);
        this.parent = iSvgParams.getParent();
        this.owner = iSvgParams.getOwner();
        this.nm = iSvgParams.getNodeModel();
        this.key = (String)iSvgParams.getSvgKey();
        this.layout.attach(this);
        try {
            this.layout.performLayout(true, true, true);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            FunctDebug.printStackTrace(ilvGraphLayoutException);
        }
        this.setContentsAdjusting(true);
    }

    protected abstract void initShapeinfo();

    public abstract String getSideName();

    public IFvSideModel getSideModel() {
        return this.domSideModel[0];
    }

    public IFvSideModel getSideModel(int n) {
        return this.domSideModel[n];
    }

    public IFvSideModel[] getSideModels() {
        return this.domSideModel;
    }

    public int getSideId() {
        return -1;
    }

    public int getSideLabelValue() {
        return -1;
    }

    public int getSideRole() {
        return -1;
    }

    @Override
    public abstract void doMouseClick(MouseViewCommand var1);

    @Override
    public abstract void doMouseDoubleClick(MouseViewCommand var1);

    @Override
    public abstract void doMousePopup(MouseViewCommand var1);

    @Override
    public abstract void doMouseUpdate(MouseViewCommand var1);

    @Override
    public String getShortName() {
        return this.getSideName();
    }

    protected void moveDefaultRect() {
        if (this.domRect == null) {
            this.domRect = ViewDomainGrapher.getDefaultDomainRect();
            double d = this.domRect.boundingBox().getMinX();
            double d2 = this.domRect.boundingBox().getMinY();
            double d3 = this.domRect.boundingBox().getHeight();
            this.domRect.move((float)d, (float)(d2 - d3 / 2.0));
        }
    }

    public void dumpCards() {
        if (this.db.on()) {
            this.setVisible(true);
            this.reDraw();
            this.db.println("domain " + this.getToolTipText() + " cards :");
            IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                if (!(ilvGraphic instanceof ViewCardGrapher)) continue;
                this.db.println("cards " + ((ViewCardGrapher)ilvGraphic).getToolTipText());
            }
        }
    }

    @Override
    public void dispose() {
        this.childgrapher = null;
        this.nm = null;
        this.shape = null;
        this.parent = null;
        this.owner = null;
        this.key = null;
        if (this.db != null) {
            this.db.dispose();
            this.db = null;
        }
        if (this.allSourceDestination != null) {
            this.allSourceDestination.clear();
            this.allSourceDestination = null;
        }
        super.dispose();
        if (this.layout != null) {
            this.layout.detach();
            this.layout = null;
        }
    }

    public IFvNodeModel getNodemodel() {
        return this.nm;
    }

    public static Rectangle2D getDefaultDomainRect2D() {
        return new Rectangle(0, 860, 900, 800);
    }

    public static IlvRectangle getDefaultDomainRect() {
        IlvRectangle ilvRectangle = new IlvRectangle(new IlvRect(0.0f, 860.0f, 900.0f, 800.0f));
        ilvRectangle.setName("DEFAULT_RECT_ID");
        ilvRectangle.setForeground(Color.RED);
        ilvRectangle.setVisible(true);
        IlvCompositeGraphic ilvCompositeGraphic = new IlvCompositeGraphic();
        IlvGraphicBag ilvGraphicBag = ilvCompositeGraphic.getGraphicBag();
        if (ilvGraphicBag == null) {
            ilvCompositeGraphic.setChildren(0, (IlvGraphic)ilvRectangle);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)ilvCompositeGraphic, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ((IlvCompositeGraphic)ilvGraphic).setChildren(0, (IlvGraphic)object);
                }
            }, (Object)ilvRectangle, false);
        }
        return ilvRectangle;
    }

    public void updateSideName(String string) {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (ilvGraphic.getName() != "DEFAULT_LABEL_ID") continue;
            ((ViewLabel)ilvGraphic).setText(string);
            break;
        }
    }

    public void updateSideLabelPos() {
        ViewLabel viewLabel = this.getSidelabel();
        this.moveObject((IlvGraphic)viewLabel, 0.0f, (float)this.boundingBox().getCenterY(), false);
    }

    public ViewLabel getSidelabel() {
        IlvGraphic ilvGraphic = null;
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements() && !((ilvGraphic = ilvGraphicEnumeration.nextElement()) instanceof ViewLabel)) {
            ilvGraphic = null;
        }
        return (ViewLabel)ilvGraphic;
    }

    public void createCardLink(ViewInternalLink viewInternalLink, ViewCompositeGraphic viewCompositeGraphic, ViewPortGraphic viewPortGraphic, ViewCompositeGraphic viewCompositeGraphic2, ViewPortGraphic viewPortGraphic2) {
        this.createGenericLink(viewInternalLink, viewCompositeGraphic, viewPortGraphic, viewCompositeGraphic2, viewPortGraphic2);
    }

    public void createGenericLink(ViewInternalLink viewInternalLink, ViewCompositeGraphic viewCompositeGraphic, ViewPortGraphic viewPortGraphic, ViewCompositeGraphic viewCompositeGraphic2, ViewPortGraphic viewPortGraphic2) {
        block9: {
            if (viewPortGraphic == null || viewPortGraphic2 == null) {
                if (this.db.on()) {
                    this.db.println("createCardLink error:" + viewInternalLink.getLink().getFrom() + "->" + viewInternalLink.getLink().getTo());
                }
                return;
            }
            IlvGrapher ilvGrapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)viewPortGraphic, (IlvGraphic)viewPortGraphic2);
            IViewLink iViewLink = this.getTk().createFunctLink(ilvGrapher, viewCompositeGraphic, viewPortGraphic, viewCompositeGraphic2, viewPortGraphic2, null, true);
            iViewLink.setLinkModel(viewInternalLink);
            try {
                this.connectPorts(viewCompositeGraphic, viewPortGraphic, viewCompositeGraphic2, viewPortGraphic2, iViewLink);
            }
            catch (FunctException functException) {
                FunctDebug.printStackTrace(functException);
            }
            try {
                if (ilvGrapher != null) {
                    ilvGrapher.addLink((IlvLinkImage)((ViewLink)iViewLink), false);
                } else if (this.db.on()) {
                    this.db.println("createCardLink error:" + viewPortGraphic.getPortType() + "->" + viewPortGraphic2.getPortType());
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block9;
                this.db.println("error from:" + viewPortGraphic.getGraphKey() + " to" + viewPortGraphic2.getGraphKey());
            }
        }
    }

    protected void init() {
        this.initShapeinfo();
        try {
            this.layout.performLayout(true, true, true);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            FunctDebug.printStackTrace(ilvGraphLayoutException);
        }
    }

    protected List<ViewCardGrapher> getDomainCards() {
        ArrayList<ViewCardGrapher> arrayList = new ArrayList<ViewCardGrapher>();
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!this.isNode(ilvGraphic) || !(ilvGraphic instanceof ViewCardGrapher)) continue;
            arrayList.add((ViewCardGrapher)ilvGraphic);
        }
        return arrayList;
    }

    protected List<ViewFiberGrapher> getFiberListCards() {
        ArrayList<ViewFiberGrapher> arrayList = new ArrayList<ViewFiberGrapher>();
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!this.isNode(ilvGraphic) || !(ilvGraphic instanceof ViewFiberGrapher)) continue;
            arrayList.add((ViewFiberGrapher)ilvGraphic);
        }
        return arrayList;
    }

    private IlvLongLinkLayout getlonglink() {
        return (IlvLongLinkLayout)this.layout.getLinkLayout();
    }

    protected void performLongLayout() {
        try {
            this.getlonglink().performLayout(true, true);
        }
        catch (IlvInappropriateLinkException ilvInappropriateLinkException) {
            ilvInappropriateLinkException.printStackTrace();
            IlvGraphLayoutUtil.EnsureAppropriateLinks((IlvInappropriateLinkException)ilvInappropriateLinkException);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            ilvGraphLayoutException.printStackTrace();
        }
    }

    protected void performLayout() {
        this.performLongLayout();
    }

    protected void notPerformLayout() {
        try {
            int n = this.layout.performLayout(true, true, true);
            if (n != 5 && this.db.on()) {
                this.db.println("Layout not done");
            }
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            this.reDraw();
        }
    }

    public void redrawAllLinks() {
        this.performLayout();
    }

    public void redrawDomainLinks(boolean bl, boolean bl2) {
        if (this.layout.getLinkLayout() != null) {
            try {
                this.layout.getLinkLayout().performLayout(bl, bl2);
            }
            catch (IlvGraphLayoutException ilvGraphLayoutException) {
                ilvGraphLayoutException.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCoordinates(double d, double d2, double d3, boolean bl) {
        this.shape.setCenterX(this.getTk().clipWorldX(d));
        this.shape.setCenterY(this.getTk().clipWorldY(d2));
        if (!(bl || this.shape.getCenterX() != 0.0 && this.shape.getCenterX() != (double)AbstractView.getCanvasWidth() && this.shape.getCenterY() != 0.0 && this.shape.getCenterY() != (double)AbstractView.getCanvasHeight())) {
            this.shape.setCenterX(AbstractView.getCanvasCenterX());
            this.shape.setCenterY(AbstractView.getCanvasCenterY());
        }
        this.setLocation(this.shape.getCenterX(), this.shape.getCenterY());
    }

    public void setLocation(double d, double d2) {
        IlvRect ilvRect = this.boundingBox();
        double d3 = ilvRect.getWidth();
        double d4 = ilvRect.getHeight();
        double d5 = d - d3 / 2.0;
        double d6 = d2 - d4 / 2.0;
        this.safeMove((float)d5, (float)d6);
    }

    protected void doShapeRotate(Double d) {
        Float f = new Float(this.boundingBox().getCenterX());
        Float f2 = new Float(this.boundingBox().getCenterY());
        if (d.floatValue() > 0.0f) {
            ((ViewShapeInfo)this.shape).incAngle();
        } else {
            ((ViewShapeInfo)this.shape).decAngle();
        }
        this.initReDraws();
        this.invalidateRegion(this.boundingBox());
        this.safeRotate(new IlvPoint(f.floatValue(), f2.floatValue()), d);
        this.invalidateRegion(this.boundingBox());
        this.reDrawViews();
        this.redrawAllLinks();
        ((ViewManagerToolKit)this.getGraphParent()).reDraw();
    }

    public void setDomainToolTipText(String string) {
        super.setToolTipText(string);
    }

    @Override
    public void doAdd(GrapherViewCommand grapherViewCommand) {
    }

    @Override
    public void doChange(GrapherViewCommand grapherViewCommand) {
    }

    @Override
    public void doDelete(GrapherViewCommand grapherViewCommand) {
    }

    public void updateCoordinates() {
        this.initReDraws();
        if (this.shape.getAngle() != 0.0) {
            this.safeRotate(new IlvPoint(new Float(this.boundingBox().getCenterX()).floatValue(), new Float(this.boundingBox().getCenterY()).floatValue()), this.shape.getAngle());
        }
        if (this.shape.getFlipH()) {
            this.safeScale(1, -1);
        }
        if (this.shape.getFlipV()) {
            this.safeScale(-1, 1);
        }
        this.setLocation(this.shape.getCenterX(), this.shape.getCenterY());
        this.reDrawViews();
    }

    @Override
    public IViewShapeInfo getInfo() {
        return this.shape;
    }

    @Override
    protected void onInitPopupMenu(UPopupMenu uPopupMenu) {
    }

    public ViewGeneralGrapher getChildGraph() {
        return this.childgrapher;
    }

    @Override
    public String getGraphKey() {
        return null;
    }

    @Override
    public IViewGraph getGraphParent() {
        return this.parent;
    }

    @Override
    public IViewGraph getOwner() {
        return this.parent;
    }

    @Override
    public int compareTo(Object object) {
        return this.getGraphKey().compareTo(((IViewGraph)object).getGraphKey());
    }

    @Override
    public void addLink(ViewPortGraphic viewPortGraphic, ViewPortGraphic viewPortGraphic2) {
    }

    public void delLink(ViewLink viewLink) {
        ViewManager.addToLog(this, "del link " + viewLink.getName() + " index=" + viewLink.getIndex());
        this.initReDraws();
        this.invalidateRegion(viewLink.boundingBox());
        this.removeLink((IlvLinkImage)viewLink, false);
        this.invalidateRegion(viewLink.boundingBox());
        this.reDrawViews();
        viewLink.getLinkModel().getLink().deleteObserver(this);
    }

    public void updateLinks(HashMap<Integer, ViewInternalLink> hashMap, Integer n) {
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof IFvOptLinkModel) {
            if ((Integer)object == ViewModelUpdateType.DELETED) {
                Integer n = ((IFvOptLinkModel)((Object)observable)).getIndex();
                if (this.graphLinks != null && this.graphLinks.containsKey(n)) {
                    IViewLink iViewLink = (IViewLink)this.graphLinks.get(n);
                    this.delLink(iViewLink);
                }
            }
        } else if (observable instanceof IFvSideModel && (Integer)object == ViewModelUpdateType.DELETED) {
            this.parent.delGraphNode(this);
        }
    }

    public Pair<Double, Double>[] getBoundf(HashMap<String, IViewGraph> hashMap) {
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        IlvRect ilvRect = ViewDomainGrapher.getDefaultDomainRect().boundingBox();
        double d = ilvRect.getMaxX();
        double d2 = ilvRect.getMaxY();
        double d3 = ilvRect.getMinX();
        double d4 = ilvRect.getMinY();
        for (IViewGraph iViewGraph : hashMap.values()) {
            IlvRect ilvRect2 = ((IlvGrapher)iViewGraph).boundingBox();
            double d5 = ilvRect2.getMaxX();
            double d6 = ilvRect2.getMaxY();
            double d7 = ilvRect2.getMinX();
            double d8 = ilvRect2.getMinY();
            if (d < d5) {
                d = d5;
            }
            if (d2 < d6) {
                d2 = d6;
            }
            if (d3 > d7) {
                d3 = d7;
            }
            if (!(d4 > d8)) continue;
            d4 = d8;
        }
        return new Pair[]{new Pair<Double, Double>(d3, d4), new Pair<Double, Double>(d, d2)};
    }

    public void doRotateL() {
        this.doShapeRotate(new Double(-90.0));
    }

    public void doRotateR() {
        this.doShapeRotate(new Double(90.0));
    }

    public float[] getBound(HashMap<String, IViewGraph> hashMap) {
        if (hashMap == null || hashMap.size() == 0) {
            return null;
        }
        float[] fArray = new float[4];
        IlvRect ilvRect = ViewDomainGrapher.getDefaultDomainRect().boundingBox();
        fArray[GraphBound.MIN_X.getIndex()] = (float)ilvRect.getMinX();
        fArray[GraphBound.MAX_X.getIndex()] = (float)ilvRect.getMaxX();
        fArray[GraphBound.MIN_Y.getIndex()] = (float)ilvRect.getMinY();
        fArray[GraphBound.MAX_Y.getIndex()] = (float)ilvRect.getMaxY();
        for (IViewGraph iViewGraph : hashMap.values()) {
            float[] fArray2 = new float[4];
            ilvRect = ((IlvGrapher)iViewGraph).boundingBox();
            fArray2[GraphBound.MIN_X.getIndex()] = (float)ilvRect.getMinX();
            fArray2[GraphBound.MAX_X.getIndex()] = (float)ilvRect.getMaxX();
            fArray2[GraphBound.MIN_Y.getIndex()] = (float)ilvRect.getMinY();
            fArray2[GraphBound.MAX_Y.getIndex()] = (float)ilvRect.getMaxY();
            if (iViewGraph instanceof ViewCardGrapher) {
                ViewCardGrapher viewCardGrapher = (ViewCardGrapher)iViewGraph;
                ViewManager.addToLog(this, viewCardGrapher.getToolTipText());
            }
            ViewManager.addToLog(this, "MIN_X:" + fArray2[GraphBound.MIN_X.getIndex()] + " MAX_X:" + fArray2[GraphBound.MAX_X.getIndex()] + " MIN_Y:" + fArray2[GraphBound.MIN_Y.getIndex()] + " MAX_Y:" + fArray2[GraphBound.MAX_Y.getIndex()]);
            if (fArray[GraphBound.MAX_X.getIndex()] < fArray2[GraphBound.MAX_X.getIndex()]) {
                fArray[GraphBound.MAX_X.getIndex()] = fArray2[GraphBound.MAX_X.getIndex()];
            }
            if (fArray[GraphBound.MAX_Y.getIndex()] < fArray2[GraphBound.MAX_Y.getIndex()]) {
                fArray[GraphBound.MAX_Y.getIndex()] = fArray2[GraphBound.MAX_Y.getIndex()];
            }
            if (fArray[GraphBound.MIN_X.getIndex()] > fArray2[GraphBound.MIN_X.getIndex()]) {
                fArray[GraphBound.MIN_X.getIndex()] = fArray2[GraphBound.MIN_X.getIndex()];
            }
            if (!(fArray[GraphBound.MIN_Y.getIndex()] > fArray2[GraphBound.MIN_Y.getIndex()])) continue;
            fArray[GraphBound.MIN_Y.getIndex()] = fArray2[GraphBound.MIN_Y.getIndex()];
        }
        return fArray;
    }

    public boolean isLabelflipped() {
        return this.labelflipped;
    }

    public void setLabelflipped(boolean bl) {
        this.labelflipped = bl;
    }

    public void flipAlarms() {
        ArrayList<ViewAlarmGrapher> arrayList = ViewDomainHelper.getAlarmGraph(this);
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).doFlipV();
            arrayList.get(i).doFlipH();
        }
    }

    public void flipComponents() {
        if (this.isCardPortsLabelFlipNeeded()) {
            ViewManagerFlipHelper.flipLabels(this, -1, -1);
            this.flipCardPortsLabel(-1, -1);
            ViewManagerFlipHelper.flipBalloons(this);
            this.flipAlarms();
            this.flipPatchPanel();
            this.flipSideName();
            this.flipSourceDestinationLabel();
            this.setMustFlip(false);
        }
    }

    private void flipPatchPanel() {
        this.flipPatchPanel(ViewDomainHelper.getPatchPanel(this));
    }

    private void flipSideName() {
        this.flipSideName(ViewDomainHelper.getSideName(this));
    }

    private void flipNodeName() {
        this.flipNodeName(ViewDomainHelper.getNodeName(this));
    }

    public void flipPatchPanel(Collection<IViewGraph> collection) {
        Object viewBandDomainGrapher2 = null;
        boolean bl = false;
        for (ViewBandDomainGrapher viewBandDomainGrapher : collection) {
            bl = false;
            if (viewBandDomainGrapher == null) continue;
            IlvGraphicBag ilvGraphicBag = viewBandDomainGrapher.getGraphicBag();
            if (!viewBandDomainGrapher.isCollapsed()) {
                if (ilvGraphicBag == null) {
                    viewBandDomainGrapher.setCollapsed(true);
                } else {
                    ilvGraphicBag.applyToObject((IlvGraphic)viewBandDomainGrapher, new IlvApplyObject(){

                        public void apply(IlvGraphic ilvGraphic, Object object) {
                            ((IlvGrapher)object).setCollapsed(true);
                        }
                    }, (Object)viewBandDomainGrapher, false);
                }
                bl = true;
            }
            viewBandDomainGrapher.doFlipV();
            viewBandDomainGrapher.doFlipH();
            ViewManagerFlipHelper.flipLabels(viewBandDomainGrapher, -1, -1);
            viewBandDomainGrapher.setFlipped(!viewBandDomainGrapher.isFlipped());
            if (!bl) continue;
            if (ilvGraphicBag == null) {
                viewBandDomainGrapher.setCollapsed(false);
                continue;
            }
            ilvGraphicBag.applyToObject((IlvGraphic)viewBandDomainGrapher, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ((IlvGrapher)object).setCollapsed(false);
                }
            }, (Object)viewBandDomainGrapher, false);
            if (!viewBandDomainGrapher.isFlipped()) continue;
            viewBandDomainGrapher.flipExpandedBandDomain(-1, -1);
        }
    }

    public void flipSideName(Collection<IViewGraph> collection) {
        Object viewHalfZoomingGraphic2 = null;
        for (ViewHalfZoomingGraphic viewHalfZoomingGraphic : collection) {
            if (viewHalfZoomingGraphic == null) continue;
            viewHalfZoomingGraphic.safeScale(-1, -1);
        }
    }

    public void flipNodeName(Collection<IViewGraph> collection) {
        Object viewHalfZoomingGraphic2 = null;
        for (ViewHalfZoomingGraphic viewHalfZoomingGraphic : collection) {
            if (viewHalfZoomingGraphic == null) continue;
            viewHalfZoomingGraphic.safeScale(-1, -1);
        }
    }

    public void flipSourceDestinationLabel() {
        Collection<ViewPin> collection = this.allSourceDestination.values();
        for (ViewPin viewPin : collection) {
            this.rotateSourceDestination(viewPin);
        }
    }

    protected void rotateSourceDestination(ViewPin viewPin) {
        if (viewPin != null) {
            IlvGraphicBag ilvGraphicBag = viewPin.pinCompo.getGraphicBag();
            if (ilvGraphicBag == null) {
                ((IViewGraph)viewPin.pinCompo.getObject(5)).safeRotate(viewPin.pinCompo.getChildren(5).getCenter(null), 180.0);
                if (viewPin.left) {
                    viewPin.pinCompo.setConstraints(5, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.TopRight, IlvAttachmentLocation.Center));
                    viewPin.left = false;
                } else {
                    viewPin.pinCompo.setConstraints(5, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.TopLeft, IlvAttachmentLocation.Center));
                    viewPin.left = true;
                }
            } else {
                ilvGraphicBag.applyToObject((IlvGraphic)viewPin.pinCompo, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        if (((ViewPin)((Object)object)).bottom) {
                            if (((ViewPin)((Object)object)).left) {
                                ((ViewPin)((Object)object)).pinCompo.getChildren(5).rotate(((ViewPin)((Object)object)).pinCompo.getChildren(5).getCenter(null), 180.0);
                                ((ViewPin)((Object)object)).pinCompo.setConstraints(5, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.TopRight, IlvAttachmentLocation.Center));
                                ((ViewPin)((Object)object)).left = false;
                                ((ViewPin)((Object)object)).bottom = false;
                            } else {
                                ((ViewPin)((Object)object)).pinCompo.getChildren(5).rotate(((ViewPin)((Object)object)).pinCompo.getChildren(5).getCenter(null), 180.0);
                                ((ViewPin)((Object)object)).pinCompo.setConstraints(5, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.TopLeft, IlvAttachmentLocation.Center));
                                ((ViewPin)((Object)object)).left = true;
                                ((ViewPin)((Object)object)).bottom = false;
                            }
                        } else if (((ViewPin)((Object)object)).left) {
                            ((ViewPin)((Object)object)).pinCompo.getChildren(5).rotate(((ViewPin)((Object)object)).pinCompo.getChildren(5).getCenter(null), 180.0);
                            ((ViewPin)((Object)object)).pinCompo.setConstraints(5, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.BottomRight, IlvAttachmentLocation.Center));
                            ((ViewPin)((Object)object)).left = false;
                            ((ViewPin)((Object)object)).bottom = true;
                        } else {
                            ((ViewPin)((Object)object)).pinCompo.getChildren(5).rotate(((ViewPin)((Object)object)).pinCompo.getChildren(5).getCenter(null), 180.0);
                            ((ViewPin)((Object)object)).pinCompo.setConstraints(5, (Object)new IlvAttachmentConstraint(IlvAttachmentLocation.BottomLeft, IlvAttachmentLocation.Center));
                            ((ViewPin)((Object)object)).left = true;
                            ((ViewPin)((Object)object)).bottom = true;
                        }
                    }
                }, (Object)viewPin, false);
            }
        }
    }

    public void flipCardPortsLabel(int n, int n2) {
        for (ViewCardGrapher hashMap2 : this.getDomainCards()) {
            hashMap2.graphicFlipPortsLabel(n, n2);
        }
        for (ViewFiberGrapher viewFiberGrapher : this.getFiberListCards()) {
            viewFiberGrapher.graphicFlipPortsLabel(n, n2);
        }
        HashMap<String, IViewGraph> hashMap = this.getGraphChildren();
        ViewBandDomainGrapher viewBandDomainGrapher = (ViewBandDomainGrapher)hashMap.get("FunctBandDomainGrapher-EVEN");
        if (viewBandDomainGrapher != null) {
            ViewManagerFlipHelper.flipLabels(viewBandDomainGrapher, n, n2);
        }
        if ((viewBandDomainGrapher = (ViewBandDomainGrapher)hashMap.get("FunctBandDomainGrapher-ODD")) != null) {
            ViewManagerFlipHelper.flipLabels(viewBandDomainGrapher, n, n2);
        }
    }

    public void flipLinkBalloon(int n, int n2) {
        Collection<IViewLink> collection = this.getGraphLinks().values();
        for (ViewLink viewLink : collection) {
            viewLink.flipBalloon(n, n2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCardPortsLabelFlipNeeded() {
        ViewGrapherLayout.GraphPos graphPos = this.getViewManager().getViewTk().getViewGrapherLayout().getPosition(this);
        if (graphPos != ViewGrapherLayout.GraphPos.RIGHT_1) {
            if (graphPos != ViewGrapherLayout.GraphPos.RIGHT_2) {
                if (graphPos != ViewGrapherLayout.GraphPos.RIGHT_3) return false;
            }
        }
        boolean bl = true;
        boolean bl2 = bl;
        if (!bl2) return false;
        if (!this.mustFlip) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAddLabelFlipNeeded() {
        ViewGrapherLayout.GraphPos graphPos = this.getViewManager().getViewTk().getViewGrapherLayout().getPosition(this);
        if (graphPos == ViewGrapherLayout.GraphPos.RIGHT_1) return true;
        if (graphPos == ViewGrapherLayout.GraphPos.RIGHT_2) return true;
        if (graphPos != ViewGrapherLayout.GraphPos.RIGHT_3) return false;
        return true;
    }

    @Override
    public String toString() {
        return "ViewDomainGrapher" + this.key;
    }

    @Override
    public void paintParent(Color color) {
    }

    public void setMustFlip(boolean bl) {
        this.mustFlip = bl;
    }

    public boolean isWorkingActive() {
        if (this.psmLineorPathPresent == null) {
            return true;
        }
        return this.psmLineorPathPresent.isWorkingActive();
    }

    public abstract void fitToView();

    @Override
    public void connectPorts(ViewCompositeGraphic viewCompositeGraphic, ViewPortGraphic viewPortGraphic, ViewCompositeGraphic viewCompositeGraphic2, ViewPortGraphic viewPortGraphic2, IViewLink iViewLink) throws FunctException {
        this.getlonglink().setAutoLayout(false);
        IlvGraphLayoutUtil.EnsureAppropriateLinkConnectors((IlvGraphLayout)this.getlonglink(), (boolean)false);
        try {
            super.connectPorts(viewCompositeGraphic, viewPortGraphic, viewCompositeGraphic2, viewPortGraphic2, iViewLink);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace(functException);
        }
        IlvGraphLayoutUtil.EnsureAppropriateLinks((IlvGraphLayout)this.getlonglink(), (boolean)false);
        this.getlonglink().setAutoLayout(true);
    }

    public ViewMultipleLayout getLayout() {
        return this.layout;
    }

    public void performLayout(boolean bl, boolean bl2, boolean bl3) {
        try {
            this.layout.performLayout(bl, bl2, bl3);
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            FunctDebug.printStackTrace(ilvGraphLayoutException);
        }
    }

    public ViewPortGraphic[] getLineCardPort(boolean bl, int n, IFvSideModel iFvSideModel) {
        return null;
    }

    public void addSource(ViewPin viewPin, boolean bl) {
    }

    public void addDestination(ViewPin viewPin, boolean bl) {
    }

    public HashMap<String, IViewGraph> getTxpGraphCards() {
        HashMap<String, IViewGraph> hashMap = new HashMap<String, IViewGraph>();
        Collection<IViewGraph> collection = this.getGraphChildren().values();
        for (IViewGraph iViewGraph : collection) {
            if (!(iViewGraph instanceof ViewBandDomainGrapher)) continue;
            Collection<IViewGraph> collection2 = iViewGraph.getGraphChildren().values();
            for (IViewGraph iViewGraph2 : collection2) {
                if (!(iViewGraph2 instanceof ViewCardGrapher)) continue;
                String string = String.valueOf(((ViewCardGrapher)iViewGraph2).getCardModel().getEntityIndex());
                hashMap.put(string, iViewGraph2);
            }
        }
        return hashMap;
    }

    public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        boolean bl = false;
        double d = this.getTransformer().zoomFactor();
        if ((d *= this.nodeZoom) * this.ntwZoom < 0.8) {
            if (this.zoomVisibility) {
                bl = true;
                this.zoomVisibility = false;
            }
        } else if (!this.zoomVisibility) {
            bl = true;
            this.zoomVisibility = true;
        }
        if (bl) {
            ViewPortGraphic viewPortGraphic;
            Object[] objectArray;
            int[] nArray;
            HashMap<Integer, IViewLink> hashMap = this.getGraphLinks();
            Iterator<Integer> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                nArray = (int[])((AbstractViewLink)hashMap.get(iterator.next()));
                objectArray = nArray.getChildren();
                if (objectArray.length == 0) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof LinkBalloon) || !nArray.isBalloonVisible()) continue;
                    ((LinkBalloon)objectArray[i]).showIt(this.zoomVisibility);
                }
            }
            nArray = this.getSideModel().getLinesIn();
            objectArray = this.getSideModel().getLinesOut();
            for (Object object : nArray) {
                viewPortGraphic = this.getTk().getConnectedPort((int)object);
                if (viewPortGraphic != null) {
                    if (!viewPortGraphic.isBalloonOpened()) continue;
                    viewPortGraphic.setPowerVisibility(this.zoomVisibility);
                    viewPortGraphic.showPowerBalloon();
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("Do not find the line port");
            }
            int[] nArray2 = objectArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                object = nArray2[i];
                viewPortGraphic = this.getTk().getConnectedPort((int)object);
                if (viewPortGraphic != null) {
                    if (!viewPortGraphic.isBalloonOpened()) continue;
                    viewPortGraphic.setPowerVisibility(this.zoomVisibility);
                    viewPortGraphic.showPowerBalloon();
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("Do not find the line port");
            }
        }
    }

    public void moveResize(IlvRect ilvRect) {
        super.moveResize(ilvRect);
        this.transformerChanged(null);
    }

    public void setNtwZoom(double d) {
        this.ntwZoom = d;
        this.transformerChanged(null);
    }

    public void setNodeZoom(double d) {
        this.nodeZoom *= d;
        this.transformerChanged(null);
    }

    @Override
    public boolean isZoomLevelVisible() {
        return this.zoomVisibility;
    }

    public boolean isSideDomainInActivePath() {
        return this.sideDomainInActivePath;
    }

    public List<IFvSideModel> getOtherSides() {
        return this.otherSides;
    }

    public void setSideDomainInActivePath(boolean bl) {
        this.sideDomainInActivePath = bl;
    }

    public static enum GraphBound {
        MIN_X,
        MIN_Y,
        MAX_X,
        MAX_Y;


        public int getIndex() {
            return this.ordinal();
        }
    }

    public class MyViewDomainListener
    implements ManagerSelectionListener {
        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
            IlvGraphic ilvGraphic = managerSelectionChangedEvent.getGraphic();
            IlvManager ilvManager = managerSelectionChangedEvent.getManager();
        }
    }

    public class Pair<X, Y> {
        private X x;
        private Y y;

        public Pair(X x, Y y) {
            this.x = x;
            this.y = y;
        }

        public Y getY() {
            return this.y;
        }

        public X getX() {
            return this.x;
        }
    }
}

