/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvOptLinkModel;
import cerent.cms.fv.IFvPSMModuleModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.fv.IFvSideModel;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.ViewDwdmSide;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.helper.FunctDebug;

public class ViewInternalLink {
    public static final int NO_SIDE = -10000;
    protected IFvSideModel from;
    protected IFvSideModel to;
    private IFvOptLinkModel link;
    protected ViewManager vm = null;
    protected boolean inited = false;
    protected boolean istxp = false;
    protected boolean isPSM = false;
    protected IFvPortModel isDirLessLineIO = null;

    public ViewInternalLink(ISvgParams iSvgParams) {
        this.vm = iSvgParams.getViewManager();
        this.link = iSvgParams.getLinkModel();
    }

    public int getSideFrom() {
        if (this.from == null) {
            return -10000;
        }
        return ViewDwdmSide.getSideLabelFromId(this.from.getId());
    }

    public int getSideTo() {
        if (this.to == null) {
            return -10000;
        }
        return ViewDwdmSide.getSideLabelFromId(this.to.getId());
    }

    public IFvSideModel getSideFromModel() {
        return this.from;
    }

    public IFvOptLinkModel getLink() {
        return this.link;
    }

    public IFvSideModel getSideToModel() {
        return this.to;
    }

    public boolean isTXPLnk() {
        return this.from == null || this.to == null;
    }

    public boolean isPSMLnk() {
        try {
            IFvCardModel iFvCardModel = this.link.getFromPortModel().getCardModel();
            IFvCardModel iFvCardModel2 = this.link.getToPortModel().getCardModel();
            return iFvCardModel instanceof IFvPSMModuleModel || iFvCardModel2 instanceof IFvPSMModuleModel;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return false;
        }
    }

    public IFvPortModel isDirLessIOLnk() {
        try {
            if (this.isTXPLnk()) {
                return null;
            }
            IFvPortModel iFvPortModel = this.link.getFromPortModel();
            IFvPortModel iFvPortModel2 = this.link.getToPortModel();
            IFvCardModel iFvCardModel = iFvPortModel.getCardModel();
            IFvCardModel iFvCardModel2 = iFvPortModel2.getCardModel();
            int n = this.getSideTo();
            int n2 = this.getSideFrom();
            if (n == -10000 && n != n2) {
                return iFvPortModel2;
            }
            if (n2 == -10000) {
                if (n != n2) {
                    return iFvPortModel;
                }
                if (iFvCardModel.getEqType() == 311 || iFvCardModel.getEqType() == 313 || iFvCardModel.getEqType() == 314) {
                    return iFvPortModel2;
                }
                if (iFvCardModel2.getEqType() == 311 || iFvCardModel2.getEqType() == 313 || iFvCardModel2.getEqType() == 314) {
                    return iFvPortModel;
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return null;
        }
        return null;
    }

    public IFvPortModel getDwdmPort() {
        return null;
    }

    public IFvPortModel getOptPort() {
        return null;
    }

    public IFvPortModel getNotOptPort() {
        return null;
    }

    public int getLinkWaveLength() {
        return -10000;
    }

    public boolean isPassiveLnk() {
        try {
            IFvCardModel iFvCardModel = this.link.getFromPortModel().getCardModel();
            IFvCardModel iFvCardModel2 = this.link.getToPortModel().getCardModel();
            return iFvCardModel.isPassiveModule() || iFvCardModel2.isPassiveModule();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            FunctDebug.printStackTrace(abstractCmsNoSuchEntityException);
            return false;
        }
    }

    public boolean isPassivePPmashLnk() {
        try {
            IFvCardModel iFvCardModel = this.link.getFromPortModel().getCardModel();
            IFvCardModel iFvCardModel2 = this.link.getToPortModel().getCardModel();
            return iFvCardModel.getEqType() == 314 || iFvCardModel.getEqType() == 313 || iFvCardModel.getEqType() == 311 || iFvCardModel2.getEqType() == 314 || iFvCardModel2.getEqType() == 313 || iFvCardModel2.getEqType() == 311;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            abstractCmsNoSuchEntityException.printStackTrace();
            return false;
        }
    }

    public boolean isOfSide(int n) {
        if (this.isPassiveLnk() && (this.getSideFrom() == n || this.getSideTo() == n)) {
            return true;
        }
        if (!this.isTXPLnk()) {
            if (this.getSideFrom() == -10000 && this.getSideTo() == -10000 && n == 0) {
                return true;
            }
            return this.getSideFrom() == this.getSideTo() && this.getSideFrom() == n;
        }
        if (this.isTXPLnk() && this.isPSMLnk()) {
            return true;
        }
        if (this.from == null) {
            return this.getSideTo() == n || n == 0 && this.getSideTo() == -10000;
        }
        return this.getSideFrom() == n || n == 0 && this.getSideFrom() == -10000;
    }

    public boolean isCrossSide() {
        return this.getSideFrom() != this.getSideTo();
    }

    public int getIndex() {
        return this.link.getIndex();
    }

    public int getLinkSide() {
        int n = this.getSideFrom();
        if (n < 0) {
            n = this.getSideTo();
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof ViewInternalLink) {
            ViewInternalLink viewInternalLink = (ViewInternalLink)object;
            bl &= this.link != null ? this.link.equals(viewInternalLink.link) : viewInternalLink.link == null;
            bl &= this.from != null ? this.from.equals(viewInternalLink.from) : viewInternalLink.from == null;
            bl &= this.to != null ? this.to.equals(viewInternalLink.to) : viewInternalLink.to == null;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.link == null ? 0 : this.link.hashCode();
        n = 13 * n + (this.from == null ? 0 : this.from.hashCode());
        n = 13 * n + (this.to == null ? 0 : this.to.hashCode());
        return n;
    }

    public boolean isTxpOrPsmtxpLnk() {
        boolean bl = this.isTXPLnk();
        try {
            IFvPSMModuleModel iFvPSMModuleModel;
            IFvEntityModel iFvEntityModel = this.link.getFromPortModel().getParentModel();
            IFvEntityModel iFvEntityModel2 = this.link.getToPortModel().getParentModel();
            if (iFvEntityModel instanceof IFvPSMModuleModel) {
                iFvPSMModuleModel = (IFvPSMModuleModel)iFvEntityModel;
            } else if (iFvEntityModel2 instanceof IFvPSMModuleModel) {
                iFvPSMModuleModel = (IFvPSMModuleModel)iFvEntityModel2;
            } else {
                return bl;
            }
            return iFvPSMModuleModel.getPSMType() == 1;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return bl;
        }
    }

    public String toString() {
        if (this.link != null) {
            return this.link.toString();
        }
        return super.toString();
    }
}

