/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.util.IFvDebug;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.helper.FunctDebug;
import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import java.awt.geom.Rectangle2D;

public class ViewShapeInfo
implements IViewShapeInfo {
    private static final double DEG_NINETY = 90.0;
    private static final double DEG_TO_UND = 270.0;
    private static final double INFO_ZERO = 0.0;
    private static final boolean FLIP_ZERO = false;
    private double X = 0.0;
    private double Y = 0.0;
    private double cX = 0.0;
    private double cY = 0.0;
    private double height = 0.0;
    private double width = 0.0;
    private double angle = 0.0;
    private boolean flipH = false;
    private boolean flipV = false;
    private String side = "UNK";
    private int key = 0;
    private IlvRect box;
    private static final IFvDebug db = FunctDebug.instance().addChild("ViewShapeInfo", " View Shape Info");

    public static Rectangle2D graphRectToRectangle(Object object) {
        if (object instanceof IlvGraphic) {
            return ((IlvGraphic)object).boundingBox().getBounds2D();
        }
        return null;
    }

    public ViewShapeInfo(int n) {
        this.key = n;
    }

    public ViewShapeInfo(Object object, int n) {
        this(ViewShapeInfo.graphRectToRectangle(object), n);
    }

    public ViewShapeInfo(Rectangle2D rectangle2D, int n) {
        this(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getHeight(), rectangle2D.getWidth(), 0.0, n);
        this.box = new IlvRect();
    }

    public ViewShapeInfo(ViewGrapher viewGrapher, int n) {
        this((Rectangle2D)viewGrapher.boundingBox(), n);
    }

    public ViewShapeInfo(double d, double d2, double d3, double d4, double d5, int n) {
        this(d, d2, d5, n);
        this.height = d3;
        this.width = d4;
    }

    public ViewShapeInfo(double d, double d2, double d3, int n) {
        this(d, d2, d3);
        this.key = n;
    }

    public ViewShapeInfo(double d, double d2, double d3) {
        this.X = d;
        this.Y = d2;
        this.angle = d3;
        if (db.on()) {
            db.println("viewShapeInfo: x=" + d + " y=" + d2 + " angle=" + d3);
        }
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setAngle(double d) {
        if (this.angle != d) {
            this.angle = d;
        }
    }

    @Override
    public double getCenterX() {
        return this.cX;
    }

    @Override
    public void setCenterX(double d) {
        this.cX = d;
    }

    @Override
    public double getCenterY() {
        return this.cY;
    }

    @Override
    public void setCenterY(double d) {
        this.cY = d;
    }

    public void incAngle() {
        this.angle = this.angle < 270.0 ? (this.angle += 90.0) : 0.0;
    }

    public void decAngle() {
        this.angle = this.angle > -270.0 ? (this.angle -= 90.0) : 0.0;
    }

    public void flipH() {
        this.flipH = !this.flipH;
    }

    public void flipV() {
        this.flipV = !this.flipV;
    }

    @Override
    public void setFlipH(boolean bl) {
        this.flipH = bl;
    }

    @Override
    public void setFlipV(boolean bl) {
        this.flipV = bl;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getMaxW() {
        return this.box.getMaxX();
    }

    @Override
    public double getMaxH() {
        return this.box.getMaxY();
    }

    @Override
    public double getMinW() {
        return this.box.getMinX();
    }

    @Override
    public double getMinH() {
        return this.box.getMinY();
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public void setX(double d) {
        if (db.on()) {
            db.println("FunctShapeInfo: " + this.X + "->" + d);
        }
        this.X = d;
    }

    @Override
    public void setY(double d) {
        if (db.on()) {
            db.println("FunctShapeInfo: " + this.Y + "->" + d);
        }
        this.Y = d;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public boolean getFlipH() {
        return this.flipH;
    }

    @Override
    public boolean getFlipV() {
        return this.flipV;
    }

    @Override
    public String getSide() {
        return this.side;
    }

    @Override
    public void setSide(String string) {
        this.side = string;
    }
}

