/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.xml;

import cerent.cms.model.CTCUserException;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.xml.AbstractDOMParser;
import cerent.util.xml.DOMUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XercesDOMParser
extends AbstractDOMParser
implements EntityResolver {
    static Class[] ExceptionCtorParmTypes = new Class[]{String.class};
    protected static final boolean doJaxp = Preferences.instance().getBoolean("ctc", "xml.jaxp", false);
    protected static final String DEFAULT_SCHEMA_FILE = "CTCSchema.xsd";
    protected static final String NO_NS_SCHEMA_LOCATION_ATTR = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected byte[] schemaBytes;
    protected URL schemaUrl;
    protected static final KDebug db = new KDebug("XercesDOMParser", false);

    public static XercesDOMParser instance(String string, URL uRL, Class clazz) throws CTCUserException {
        return XercesDOMParser.instance(string, uRL, null, clazz);
    }

    public static XercesDOMParser instance(URL uRL, Class clazz) throws CTCUserException {
        return XercesDOMParser.instance(uRL, null, clazz);
    }

    public static XercesDOMParser instance(String string, URL uRL) throws CTCUserException {
        return XercesDOMParser.instance(uRL);
    }

    public static XercesDOMParser instance(URL uRL) throws CTCUserException {
        return XercesDOMParser.instance(uRL, null, null);
    }

    public static XercesDOMParser instance(String string, URL uRL, KDebug kDebug, Class clazz) throws CTCUserException {
        return XercesDOMParser.instance(uRL, kDebug, clazz);
    }

    public static XercesDOMParser instance(URL uRL, KDebug kDebug, Class clazz) throws CTCUserException {
        XercesDOMParser xercesDOMParser;
        block12: {
            Constructor constructor = XercesDOMParser.getCtor(clazz);
            xercesDOMParser = null;
            try {
                if (constructor == null) {
                    xercesDOMParser = new XercesDOMParser(uRL, kDebug);
                    break block12;
                }
                Exception exception = null;
                try {
                    constructor.setAccessible(true);
                    xercesDOMParser = (XercesDOMParser)constructor.newInstance(uRL, kDebug);
                }
                catch (InstantiationException instantiationException) {
                    exception = instantiationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    exception = invocationTargetException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exception = illegalArgumentException;
                }
                if (exception != null) {
                    throw new CTCUserException("creating XercesDOMParser subclass instance failed", exception);
                }
            }
            catch (RuntimeException runtimeException) {
                try {
                    String string = "(" + uRL + ") " + runtimeException.getMessage();
                    Constructor<?> constructor2 = runtimeException.getClass().getDeclaredConstructor(ExceptionCtorParmTypes);
                    RuntimeException runtimeException2 = (RuntimeException)constructor2.newInstance(string);
                    throw runtimeException2;
                }
                catch (Exception exception) {
                    throw runtimeException;
                }
            }
        }
        if (kDebug != null && kDebug.on()) {
            kDebug.println("parser class: " + xercesDOMParser.getClass().getName());
        }
        return xercesDOMParser;
    }

    public static XercesDOMParser instance(String string, URL uRL, KDebug kDebug) throws CTCUserException {
        return XercesDOMParser.instance(uRL, kDebug);
    }

    public static XercesDOMParser instance(URL uRL, KDebug kDebug) throws CTCUserException {
        return XercesDOMParser.instance(uRL, kDebug, null);
    }

    protected XercesDOMParser(URL uRL, KDebug kDebug) throws CTCUserException {
        super(uRL, kDebug);
    }

    protected void enableSchema(boolean bl) {
        block2: {
            try {
                this.factory.setAttribute("http://apache.org/xml/features/validation/schema", bl ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (db == null || !db.on()) break block2;
                KDebug.printStackTrace((Throwable)illegalArgumentException);
            }
        }
    }

    protected void enableSchema() {
        this.enableSchema(true);
    }

    @Override
    protected void disableSchema() {
        this.enableSchema(false);
    }

    protected static URL getSchemaURL(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = null;
        File file = new File(string);
        try {
            uRL = file.exists() ? new URL("file", "", string.replace('\\', '/')) : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            KDebug.printStackTrace((Throwable)malformedURLException);
        }
        return uRL;
    }

    protected void setSchemaProp(String string) {
        block2: {
            try {
                this.factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                this.factory.setAttribute(NO_NS_SCHEMA_LOCATION_ATTR, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (db == null || !db.on()) break block2;
                KDebug.printStackTrace((Throwable)illegalArgumentException);
            }
        }
    }

    protected String getSchemaProp() {
        return (String)this.factory.getAttribute(NO_NS_SCHEMA_LOCATION_ATTR);
    }

    @Override
    public String getSchema() {
        return this.schemaUrl == null ? null : this.schemaUrl.toExternalForm();
    }

    public URL getSchemaURL() {
        return this.schemaUrl;
    }

    protected void setSchema(URL uRL) throws CTCUserException {
        if (uRL == null) {
            this.setSchema((String)null);
        } else {
            this.setSchema(uRL.getPath());
        }
    }

    protected void setSchema(String string) throws CTCUserException {
        this.setSchema(string, null);
    }

    @Override
    protected void setSchema(String string, KDebug kDebug) throws CTCUserException {
        String string2;
        String string3 = string2 = string == null ? DEFAULT_SCHEMA_FILE : string;
        if (doJaxp) {
            this.setJaxpSchema(string2, kDebug);
        } else {
            this.setXercesSchema(string2, kDebug);
        }
    }

    protected void setJaxpSchema(String string, KDebug kDebug) throws CTCUserException {
        if (kDebug != null) {
            kDebug.println("NOT support until the updated JAXP API is available in JDK 1.5");
        }
    }

    protected void setXercesSchema(String string, KDebug kDebug) throws CTCUserException {
        try {
            this.enableSchema();
            if (kDebug != null) {
                kDebug.println("Using explicit schema url");
            } else {
                System.out.println("Using explicit schema url: " + string);
            }
            this.setSchemaProp(string);
            BufferedInputStream bufferedInputStream = null;
            try {
                this.schemaUrl = !string.startsWith("file:") && !string.startsWith("http:") ? new URL("file", "", string) : new URL(string);
                this.schemaBytes = new byte[this.schemaUrl.openConnection().getContentLength()];
                bufferedInputStream = new BufferedInputStream(this.schemaUrl.openStream());
                int n = bufferedInputStream.read(this.schemaBytes, 0, this.schemaBytes.length);
            }
            catch (IOException iOException) {
                throw new CTCUserException("(" + this.schemaUrl + ") IOException in XercesDOMParser constructor trying to read schema: " + iOException.getMessage());
            }
            catch (Exception exception) {
                throw new CTCUserException("Exception in XercesDOMParser constructor trying to read schema: " + exception.getMessage() + "\n" + "Check that the " + DEFAULT_SCHEMA_FILE + " file is in a schema directory " + "in the classpath.");
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            if (kDebug != null) {
                kDebug.println("error in setting up parser feature");
            }
            throw new CTCUserException("Error in setting up parser: " + exception.toString());
        }
    }

    protected void setEntityResolver(String string) throws CTCUserException {
        this.setEntityResolver();
    }

    @Override
    protected void setEntityResolver() throws CTCUserException {
        this.parser.setEntityResolver(this);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (db.on()) {
            db.println("Resolving Entity System ID: " + string2 + " Public ID: " + string);
        }
        return new InputSource(new ByteArrayInputStream(this.schemaBytes));
    }

    protected static Constructor getCtor(Class clazz) {
        Constructor constructor;
        block3: {
            if (clazz == null) {
                return null;
            }
            constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(URL.class, KDebug.class);
            }
            catch (Exception exception) {
                if (db == null) break block3;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return constructor;
    }

    public static KDebug getDebug() {
        return db;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("usage: " + XercesDOMParser.class.getName() + " <XML filename> <[schema-to-validate-against]>");
        }
        String string = stringArray[0];
        URL uRL = null;
        try {
            Object object;
            if (stringArray.length > 1) {
                object = stringArray[1];
                if (!((String)object).startsWith("file:")) {
                    object = "file://" + (String)object;
                }
                uRL = new URL((String)object);
                System.out.println("validating using schema: " + (String)object);
            }
            object = XercesDOMParser.instance(uRL, (KDebug)null);
            Document document = ((AbstractDOMParser)object).parse(string);
            String string2 = DOMUtil.nodeToString(document, 2, false);
            System.out.println(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

