/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener {
    private boolean _showPopupDuringSearching = true;

    public ComboBoxSearchable(JComboBox jComboBox) {
        super(jComboBox);
        jComboBox.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
                return -1;
            }
        });
        jComboBox.getModel().addListDataListener(this);
        jComboBox.addPropertyChangeListener("model", this);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSearching(boolean bl) {
        this._showPopupDuringSearching = bl;
    }

    protected void setSelectedIndex(int n, boolean bl) {
        if (this.isShowPopupDuringSearching()) {
            try {
                if (!((JComboBox)this._component).isPopupVisible()) {
                    ((JComboBox)this._component).showPopup();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        if (((JComboBox)this._component).getSelectedIndex() != n) {
            ((JComboBox)this._component).setSelectedIndex(n);
        }
    }

    protected int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    protected Object getElementAt(int n) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(n);
    }

    protected int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getIndex0() != -1 || listDataEvent.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.hidePopup();
            if (propertyChangeEvent.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
        }
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }
}

