/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;

public class HeavyweightWrapper
extends Panel {
    private Component _component;
    private boolean _heavyweight;

    public HeavyweightWrapper(Component component, boolean bl) {
        this._component = component;
        ((JComponent)this._component).putClientProperty("HeavyweightWrapper", this);
        if (this._component != null) {
            this._component.addComponentListener(new ComponentListener(){

                public void componentResized(ComponentEvent componentEvent) {
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentShown(ComponentEvent componentEvent) {
                    HeavyweightWrapper.this.setVisible(true);
                }

                public void componentHidden(ComponentEvent componentEvent) {
                    HeavyweightWrapper.this.setVisible(false);
                }
            });
        }
        this.setLayout(new BorderLayout());
        this._heavyweight = bl;
    }

    public HeavyweightWrapper(Component component) {
        this(component, false);
    }

    public boolean isHeavyweight() {
        return this._heavyweight;
    }

    public void setHeavyweight(boolean bl) {
        this._heavyweight = bl;
    }

    public void delegateAdd(Container container, Object object) {
        if (this.isHeavyweight()) {
            if (this._component.getParent() != this) {
                this.add(this._component);
            }
            if (this.getParent() != container) {
                container.add((Component)this, object);
            }
        } else {
            container.add(this._component, object);
        }
    }

    public void delegateRemove(Container container) {
        if (this.isHeavyweight()) {
            this.remove(this._component);
            container.remove(this);
        } else {
            container.remove(this._component);
        }
    }

    public void delegateSetVisible(boolean bl) {
        if (this.isHeavyweight()) {
            this.setVisible(bl);
            this._component.setVisible(bl);
        } else {
            this._component.setVisible(bl);
        }
    }

    public void delegateSetBounds(Rectangle rectangle) {
        if (this.isHeavyweight()) {
            this.setBounds(rectangle);
            this._component.setBounds(0, 0, rectangle.width, rectangle.height);
        } else {
            this._component.setBounds(rectangle);
        }
    }

    public void delegateSetBounds(int n, int n2, int n3, int n4) {
        if (this.isHeavyweight()) {
            this.setBounds(n, n2, n3, n4);
            this._component.setBounds(0, 0, n3, n4);
        } else {
            this._component.setBounds(n, n2, n3, n4);
        }
    }

    public void delegateSetLocation(int n, int n2) {
        if (this.isHeavyweight()) {
            this.setLocation(n, n2);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(n, n2);
        }
    }

    public void delegateSetLocation(Point point) {
        if (this.isHeavyweight()) {
            this.setLocation(point);
            this._component.setLocation(0, 0);
        } else {
            this._component.setLocation(point);
        }
    }

    public void delegateSetCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    public void delegateSetNull() {
        ((JComponent)this._component).putClientProperty("HeavyweightWrapper", null);
        this._component = null;
    }

    public Container delegateGetParent() {
        if (this.isHeavyweight()) {
            return this.getParent();
        }
        return this._component.getParent();
    }

    public boolean delegateIsVisible() {
        if (this.isHeavyweight()) {
            return this.isVisible();
        }
        return this._component.isVisible();
    }

    public Rectangle delegateGetBounds() {
        if (this.isHeavyweight()) {
            return this.getBounds();
        }
        return this._component.getBounds();
    }

    public void delegateRepaint() {
        if (this.isHeavyweight()) {
            this.repaint();
            this._component.repaint();
        } else {
            this._component.repaint();
        }
    }

    public Component getComponent() {
        return this._component;
    }

    public void setComponent(Component component) {
        this._component = component;
    }
}

