/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JideMenu
extends JMenu
implements Alignable {
    private int _preferredPopupHorizontalAlignment = 2;
    private int _preferredPopupVerticalAlignment = 3;
    private MenuCreator _menuCreator;
    private PopupMenuCustomizer _customizer;
    private PopupMenuOriginCalculator _originCalculator;
    public static int DELAY = 400;
    private int _orientation;
    private static JideMenu _pendingMenu;
    private static HideTimer _timer;
    private static final boolean DISABLE_TIMER = true;

    public JideMenu() {
        this.initMenu();
    }

    public JideMenu(String string) {
        super(string);
        this.initMenu();
    }

    public JideMenu(Action action) {
        super(action);
        this.initMenu();
    }

    public JideMenu(String string, boolean bl) {
        super(string, bl);
        this.initMenu();
    }

    protected void initMenu() {
        this.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                PopupMenuCustomizer popupMenuCustomizer;
                MenuCreator menuCreator = JideMenu.this.getMenuCreator();
                if (menuCreator != null) {
                    menuCreator.createMenu();
                    if (JideMenu.this.getPopupMenu().getComponentCount() == 0) {
                        return;
                    }
                }
                if ((popupMenuCustomizer = JideMenu.this.getPopupMenuCustomizer()) != null) {
                    popupMenuCustomizer.customize(JideMenu.this.getPopupMenu());
                }
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    public boolean isTopLevelMenu() {
        return this.getParent() == null || !(this.getParent() instanceof JPopupMenu);
    }

    public PopupMenuOriginCalculator getOriginCalculator() {
        return this._originCalculator;
    }

    public void setOriginCalculator(PopupMenuOriginCalculator popupMenuOriginCalculator) {
        this._originCalculator = popupMenuOriginCalculator;
    }

    @Deprecated
    public MenuCreator getMenuCreator() {
        return this._menuCreator;
    }

    @Deprecated
    public void setMenuCreator(MenuCreator menuCreator) {
        this._menuCreator = menuCreator;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this._customizer;
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer popupMenuCustomizer) {
        this._customizer = popupMenuCustomizer;
    }

    protected Point getPopupMenuOrigin() {
        int n;
        GraphicsDevice[] graphicsDeviceArray;
        if (this._originCalculator != null) {
            return this._originCalculator.getPopupMenuOrigin(this);
        }
        int n2 = 0;
        int n3 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = this.getSize();
        Dimension dimension2 = jPopupMenu.getPreferredSize();
        Point point = this.getLocationOnScreen();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object object = graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n4 = ((GraphicsDevice[])object).length;
        for (n = 0; n < n4; ++n) {
            GraphicsConfiguration graphicsConfiguration2;
            GraphicsDevice graphicsDevice = object[n];
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            object = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= Math.abs(object.left + object.right);
            rectangle.height -= Math.abs(object.top + object.bottom);
            point.x -= Math.abs(object.left);
            point.y -= Math.abs(object.top);
        }
        if ((object = this.getParent()) instanceof JPopupMenu) {
            n4 = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetX");
            n = UIDefaultsLookup.getInt("Menu.submenuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    n2 = dimension.width + n4;
                    if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                        n2 = 0 - n4 - dimension2.width;
                    }
                } else {
                    n2 = dimension.width + n4;
                    if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                        n2 = 0 - n4 - dimension2.width;
                    }
                }
            } else {
                n2 = 0 - n4 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = dimension.width + n4;
                }
            }
            if (point.y + (n3 = n) + dimension2.height >= rectangle.height + rectangle.y && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n3 = dimension.height - n - dimension2.height;
            }
        } else {
            n4 = UIDefaultsLookup.getInt("Menu.menuPopupOffsetX");
            n = UIDefaultsLookup.getInt("Menu.menuPopupOffsetY");
            if (this.getComponentOrientation().isLeftToRight()) {
                if (JideSwingUtilities.getOrientationOf(this) == 0) {
                    if (this.getPreferredPopupHorizontalAlignment() == 2) {
                        n2 = n4;
                        if (point.x + n2 + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                            n2 = dimension.width - n4 - dimension2.width;
                        }
                    } else {
                        n2 = -dimension2.width + n4 + dimension.width;
                        if (point.x + n2 < rectangle.x) {
                            n2 = rectangle.x - point.x;
                        }
                    }
                } else {
                    n2 = 1 - n4 - dimension2.width;
                    if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                        n2 = dimension.width + n4 - 1;
                    }
                }
            } else {
                n2 = dimension.width - n4 - dimension2.width;
                if (point.x + n2 < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n2 = n4;
                }
            }
            if (JideSwingUtilities.getOrientationOf(this) == 0) {
                n3 = dimension.height + n - 1;
                if (this.getPreferredPopupVerticalAlignment() == 1 || point.y + n3 + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                    n3 = 1 - n - dimension2.height;
                }
            } else {
                n3 = -n;
                if (point.y + n3 + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                    n3 = 0 - n - dimension2.height;
                }
            }
        }
        return new Point(n2, n3);
    }

    public boolean isOpaque() {
        if (this.isTopLevelMenu()) {
            return false;
        }
        return super.isOpaque();
    }

    public boolean originalIsOpaque() {
        return super.isOpaque();
    }

    protected void hideMenu() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        menuSelectionManager.clearSelectedPath();
    }

    public int getPreferredPopupHorizontalAlignment() {
        return this._preferredPopupHorizontalAlignment;
    }

    public void setPreferredPopupHorizontalAlignment(int n) {
        this._preferredPopupHorizontalAlignment = n;
    }

    public int getPreferredPopupVerticalAlignment() {
        return this._preferredPopupVerticalAlignment;
    }

    public void setPreferredPopupVerticalAlignment(int n) {
        this._preferredPopupVerticalAlignment = n;
    }

    public boolean supportVerticalOrientation() {
        return true;
    }

    public boolean supportHorizontalOrientation() {
        return true;
    }

    public void setOrientation(int n) {
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setPopupMenuVisible(boolean bl) {
        if (bl && this.getPopupMenu().getComponentCount() == 0) {
            return;
        }
        this.setPopupMenuVisibleImmediately(bl);
    }

    void setPopupMenuVisibleImmediately(boolean bl) {
        super.setPopupMenuVisible(bl);
    }

    private void startTimer() {
        if (_timer != null) {
            this.stopTimer();
        }
        _pendingMenu = this;
        _timer = new HideTimer();
        _timer.start();
    }

    private void stopTimer() {
        if (_timer != null) {
            if (_pendingMenu != null) {
                _pendingMenu.setPopupMenuVisibleImmediately(false);
                _pendingMenu = null;
            }
            _timer.stop();
            _timer = null;
        }
    }

    private class HideTimer
    extends Timer
    implements ActionListener {
        public HideTimer() {
            super(DELAY + 300, null);
            this.addActionListener(this);
            this.setRepeats(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JideMenu.this.stopTimer();
        }
    }

    @Deprecated
    public static interface MenuCreator {
        public void createMenu();
    }

    public static interface PopupMenuCustomizer {
        public void customize(JPopupMenu var1);
    }

    public static interface PopupMenuOriginCalculator {
        public Point getPopupMenuOrigin(JideMenu var1);
    }
}

