/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SecurityUtils;
import java.util.Locale;

public final class SystemInfo {
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000 = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsVista = false;
    private static boolean _isWindows2003 = false;
    private static boolean _isClassicWindows = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;

    private SystemInfo() {
    }

    public static String getJavaVersion() {
        return SecurityUtils.getProperty("java.version", "1.4.2");
    }

    public static String getJavaVendor() {
        return SecurityUtils.getProperty("java.vendor", "");
    }

    public static String getJavaClassVerion() {
        return SecurityUtils.getProperty("java.class.version", "");
    }

    public static String getOS() {
        return SecurityUtils.getProperty("os.name", "Windows XP");
    }

    public static String getOSVersion() {
        return SecurityUtils.getProperty("os.version", "");
    }

    public static String getOSArchitecture() {
        return SecurityUtils.getProperty("os.arch", "");
    }

    public static String getCurrentDirectory() {
        return SecurityUtils.getProperty("user.dir", "");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static void setSupportsTray(boolean bl) {
        _supportsTray = bl;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isClassicWindows() {
        return _isClassicWindows;
    }

    public static boolean isWindowsNTor2000() {
        return _isWindowsNTor2000;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindows2003() {
        return _isWindows2003;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    public static boolean isJdk13Above() {
        String string = SystemInfo.getJavaVersion();
        String string2 = string.substring(0, 3);
        try {
            double d2 = Double.parseDouble(string2);
            return d2 >= 1.3;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk142Above() {
        String string = SystemInfo.getJavaVersion();
        String string2 = string.substring(0, 5);
        return string2.compareTo("1.4.2") >= 0;
    }

    public static boolean isJdk14Above() {
        String string = SystemInfo.getJavaVersion();
        String string2 = string.substring(0, 3);
        try {
            double d2 = Double.parseDouble(string2);
            return d2 >= 1.4;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk15Above() {
        String string = SystemInfo.getJavaVersion();
        String string2 = string.substring(0, 3);
        try {
            double d2 = Double.parseDouble(string2);
            return d2 >= 1.5;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk6Above() {
        String string = SystemInfo.getJavaVersion();
        String string2 = string.substring(0, 3);
        try {
            double d2 = Double.parseDouble(string2);
            return d2 >= 1.6;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isJdk7Above() {
        String string = SystemInfo.getJavaVersion();
        String string2 = string.substring(0, 3);
        try {
            double d2 = Double.parseDouble(string2);
            return d2 >= 1.7;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isCJKLocale() {
        return SystemInfo.isCJKLocale(Locale.getDefault());
    }

    public static boolean isCJKLocale(Locale locale) {
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    static {
        String string = SecurityUtils.getProperty("os.name", "Windows XP");
        _isWindows = string.indexOf("Windows") != -1;
        try {
            String string2 = SecurityUtils.getProperty("os.version", "5.0");
            Float f2 = Float.valueOf(string2);
            _isClassicWindows = (double)f2.floatValue() <= 4.0;
        }
        catch (NumberFormatException numberFormatException) {
            _isClassicWindows = false;
        }
        if (string.indexOf("Windows XP") != -1 || string.indexOf("Windows NT") != -1 || string.indexOf("Windows 2000") != -1) {
            _isWindowsNTor2000 = true;
        }
        if (string.indexOf("Windows XP") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows Vista") != -1) {
            _isWindowsVista = true;
        }
        if (string.indexOf("Windows 2003") != -1) {
            _isWindows2003 = true;
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("Windows 98") != -1) {
            _isWindows98 = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = string.indexOf("Solaris") != -1 || string.indexOf("SunOS") != -1;
        boolean bl = _isLinux = string.indexOf("Linux") != -1;
        if (string.startsWith("Mac OS")) {
            if (string.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }
}

