/*
 * Decompiled with CFR 0.152.
 */
package com.smardec.mousegestures;

import com.smardec.mousegestures.MouseGesturesListener;
import com.smardec.mousegestures.MouseGesturesRecognizer;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class MouseGestures {
    private AWTEventListener mouseGesturesEventListener = null;
    private MouseGesturesRecognizer mouseGesturesRecognizer = new MouseGesturesRecognizer(this);
    private Vector listeners = new Vector();
    private int mouseButton = 4;

    public void start() {
        if (this.mouseGesturesEventListener == null) {
            this.mouseGesturesEventListener = new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    if (event instanceof MouseEvent) {
                        MouseEvent mouseEvent = (MouseEvent)event;
                        if ((mouseEvent.getModifiers() & MouseGestures.this.mouseButton) == MouseGestures.this.mouseButton) {
                            MouseGestures.this.mouseGesturesRecognizer.processMouseEvent(mouseEvent);
                        }
                        if ((mouseEvent.getID() == 502 || mouseEvent.getID() == 500) && (mouseEvent.getModifiers() & MouseGestures.this.mouseButton) == MouseGestures.this.mouseButton) {
                            if (MouseGestures.this.mouseGesturesRecognizer.isGestureRecognized()) {
                                mouseEvent.consume();
                                String gesture = MouseGestures.this.mouseGesturesRecognizer.getGesture();
                                MouseGestures.this.mouseGesturesRecognizer.clearTemporaryInfo();
                                MouseGestures.this.fireProcessMouseGesture(gesture);
                            } else {
                                MouseGestures.this.mouseGesturesRecognizer.clearTemporaryInfo();
                            }
                        }
                    }
                }
            };
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseGesturesEventListener, 48L);
    }

    public void stop() {
        if (this.mouseGesturesEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseGesturesEventListener);
        }
    }

    public int getGridSize() {
        return this.mouseGesturesRecognizer.getGridSize();
    }

    public void setGridSize(int gridSize) {
        this.mouseGesturesRecognizer.setGridSize(gridSize);
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    public void setMouseButton(int mouseButton) {
        this.mouseButton = mouseButton;
    }

    public void addMouseGesturesListener(MouseGesturesListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeMouseGesturesListener(MouseGesturesListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireProcessMouseGesture(String gesture) {
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            ((MouseGesturesListener)this.listeners.get(i2)).processGesture(gesture);
            ++i2;
        }
    }

    void fireGestureMovementRecognized(String gesture) {
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            ((MouseGesturesListener)this.listeners.get(i2)).gestureMovementRecognized(gesture);
            ++i2;
        }
    }
}

