/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CWICustomClassLoader;
import com.cisco.hfr.cwi.installer.CompatibilityDirectory;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.NoMainClassAttributeException;
import com.cisco.hfr.cwi.installer.Preferences;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;

public class Bootstrap {
    public static void main(String[] args) {
        try {
            System.out.println("In BootStrap");
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.begin(args);
        }
        catch (NoMainClassAttributeException nmcae) {
            System.err.println(nmcae);
            nmcae.printStackTrace();
            Bootstrap.fatal("'Main-Class:' missing from JAR manifest");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(cnfe);
            cnfe.printStackTrace();
            Bootstrap.fatal("Load class failed to load a class..." + cnfe);
        }
        catch (IllegalAccessException iae) {
            System.err.println(iae);
            iae.printStackTrace();
            Bootstrap.fatal("cannot access the 'main(String[])' method");
        }
        catch (InstantiationException ie) {
            System.err.println(ie);
            ie.printStackTrace();
            Bootstrap.fatal("failed to instantiate a class loader");
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(nsme + ": " + nsme.getMessage());
            nsme.printStackTrace();
            Bootstrap.fatal("'setParent(CmsClassLoader)' not in ElementFactory OR 'main(String[])' not in class tagged as Main-Class");
        }
        catch (InvocationTargetException ite) {
            ite.getTargetException().printStackTrace();
            Bootstrap.fatal("failed to invoke 'main(String[])'");
        }
        catch (MalformedURLException mue) {
            System.err.println(mue);
            mue.printStackTrace();
            Bootstrap.fatal("invalid URL parts on command line");
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            ioe.printStackTrace();
            Bootstrap.fatal("I/O error while caching JAR");
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            Bootstrap.fatal("Error starting CWI");
        }
    }

    private Bootstrap() {
    }

    private void begin(String[] args) throws NoMainClassAttributeException, Exception {
        if (args.length > 0) {
            String prefsFilename = InstallerUtil.getCWIPreferenceFileName();
            System.out.println("Preferences filename : " + prefsFilename);
            Preferences prefs = Preferences.getPreferenceInstance(prefsFilename);
            prefs.init();
            String compatibilityString = InstallerUtil.getCompatibilityString(args[0]);
            System.out.println("Compatibility String : " + compatibilityString);
            String homeDir = prefs.getProperty("cwi", "home", "");
            System.out.println("CWI home directory : " + homeDir);
            String compatibilityPathname = homeDir + File.separator + "versions" + File.separator + compatibilityString;
            System.out.println("Compatibility pathname : " + compatibilityPathname);
            File compatibility = new File(compatibilityPathname);
            CompatibilityDirectory compDirectory = new CompatibilityDirectory(compatibility);
            System.out.println("Compatibility dir : ");
            compDirectory.print();
            File ifFile = new File(compatibilityPathname + File.separator + "cwi_if.jar");
            String desktopFileVersion = ((Object)compDirectory.getVersions("cwi_desktop.jar")[0]).toString();
            System.out.println("Desktop file version : " + desktopFileVersion);
            File desktopFile = new File(compatibilityPathname + File.separator + desktopFileVersion + File.separator + "cwi_desktop.jar");
            if (!ifFile.exists()) {
                throw new Exception("Unable to find CWI Component - cwi_if.jar in the cache.");
            }
            if (!desktopFile.exists()) {
                throw new Exception("Unable to find CWI Components - cwi_desktop.jar in the cache.");
            }
            CWICustomClassLoader ifClassLoader = new CWICustomClassLoader(ifFile.getCanonicalPath(), this.getClass().getClassLoader());
            CWICustomClassLoader desktopClassLoader = new CWICustomClassLoader(desktopFile.getCanonicalPath(), (ClassLoader)ifClassLoader);
            desktopClassLoader.invokeMain(args);
        } else {
            Bootstrap.fatal("Incorrect generated launch file or jar locations messed up.");
        }
    }

    private static void fatal(String msg) {
        System.err.println(msg);
        System.err.flush();
        System.exit(1);
    }
}

