/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.IProgressObserver;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadUpdate
implements Observer {
    private Log mLog = LogFactory.getLog(DownloadUpdate.class);
    JProgressBar mProgressBar;

    public DownloadUpdate(JProgressBar progressBar) {
        this.mProgressBar = progressBar;
    }

    private void update(long cur, long max) {
        Double value = new Double(cur * 100L / max);
        this.mProgressBar.setValue(value.intValue());
    }

    private void doUpdate(IProgressObserver observer) {
        long max = observer.getMaximum();
        long cur = observer.getCurrent();
        if (cur < max) {
            this.update(cur, max);
        }
    }

    public void update(Observable o, Object arg) {
        UpdateDisplay u = new UpdateDisplay((IProgressObserver)((Object)o));
        try {
            SwingUtilities.invokeAndWait(u);
        }
        catch (Exception ex) {
            this.mLog.warn("Exception while updating progress info", ex);
        }
    }

    private class UpdateDisplay
    implements Runnable {
        IProgressObserver mObserver;

        UpdateDisplay(IProgressObserver observer) {
            this.mObserver = observer;
        }

        public void run() {
            DownloadUpdate.this.doUpdate(this.mObserver);
        }
    }
}

