/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GridBagPanel
extends JPanel {
    public static boolean debug = true;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();

    public GridBagPanel() {
        this.setLayout(this.gbl);
    }

    public void fillHorizontal() {
        this.fill(2);
    }

    public void fillNone() {
        this.fill(0);
    }

    public void anchorNorth() {
        this.anchor(11);
    }

    public void anchorEast() {
        this.anchor(13);
    }

    public void anchorSouth() {
        this.anchor(15);
    }

    public void anchorWest() {
        this.anchor(17);
    }

    public void anchorCenter() {
        this.anchor(10);
    }

    public void fillVertical() {
        this.fill(3);
    }

    public void fillBoth() {
        this.fill(1);
    }

    public void fillBoth(int percentX, int percentY) {
        if (percentX < 0) {
            percentX = 0;
        } else if (percentX > 100) {
            percentX = 100;
        }
        if (percentY < 0) {
            percentY = 0;
        } else if (percentY > 100) {
            percentY = 100;
        }
        this.gbc.fill = 1;
        this.gbc.weightx = percentX;
        this.gbc.weighty = percentY;
    }

    public void add(Component c, int x, int y, int w, int h) {
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.gridwidth = w;
        this.gbc.gridheight = h;
        this.add(c, this.gbc);
        this.gbc.ipady = 0;
        this.gbc.ipadx = 0;
    }

    public void addRemainder(Component c, int x, int y) {
        this.gbc.gridx = x;
        this.gbc.gridy = y;
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 1;
        this.gbl.setConstraints(c, this.gbc);
        this.add(c);
    }

    public void add(Component c, int x, int y) {
        this.add(c, x, y, 1, 1);
    }

    public void add(String s, int x, int y) {
        this.add((Component)new JLabel(s), x, y);
    }

    public void pad(int x, int y) {
        this.gbc.ipady = x;
        this.gbc.ipadx = y;
    }

    public void inset(int w, int h) {
        this.gbc.insets = new Insets(h, w, h, w);
    }

    public void inset(int top, int left, int bottom, int right) {
        this.gbc.insets = new Insets(top, left, bottom, right);
    }

    public void inset() {
        this.gbc.insets = new Insets(0, 0, 0, 0);
    }

    public void align(int alignment) {
        this.anchor(alignment);
    }

    public void anchor(int alignment) {
        this.gbc.anchor = alignment;
    }

    public void fill(int filler) {
        this.fill(filler, 100);
    }

    public void fill(int filler, int percent) {
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        switch (filler) {
            case 2: {
                this.gbc.fill = filler;
                this.gbc.weightx = percent;
                break;
            }
            case 3: {
                this.gbc.fill = filler;
                this.gbc.weighty = percent;
                break;
            }
            case 1: {
                this.gbc.fill = filler;
                this.gbc.weightx = percent;
                this.gbc.weighty = percent;
                break;
            }
            case 0: {
                this.gbc.fill = filler;
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 0.0;
                break;
            }
        }
    }
}

