/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.Colorizer;
import com.sshtools.daemon.terminal.Terminal;
import com.sshtools.daemon.terminal.TerminalIO;

public abstract class BasicTerminal
implements Terminal {
    protected Colorizer myColorizer = Colorizer.getReference();

    public int translateControlCharacter(int c) {
        switch (c) {
            case 127: {
                return 1302;
            }
            case 8: {
                return 1303;
            }
            case 9: {
                return 1301;
            }
            case 27: {
                return 1200;
            }
            case 1: {
                return 1304;
            }
            case 4: {
                return 1306;
            }
        }
        return c;
    }

    public int translateEscapeSequence(int[] buffer) {
        try {
            if (buffer[0] == 91) {
                switch (buffer[1]) {
                    case 65: {
                        return 1001;
                    }
                    case 66: {
                        return 1002;
                    }
                    case 67: {
                        return 1003;
                    }
                    case 68: {
                        return 1004;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1201;
        }
        return 1202;
    }

    public byte[] getCursorMoveSequence(int direction, int times) {
        byte[] sequence = null;
        sequence = times == 1 ? new byte[3] : new byte[times * 3];
        for (int g = 0; g < times * 3; ++g) {
            sequence[g] = 27;
            sequence[g + 1] = 91;
            switch (direction) {
                case 1001: {
                    sequence[g + 2] = 65;
                    break;
                }
                case 1002: {
                    sequence[g + 2] = 66;
                    break;
                }
                case 1003: {
                    sequence[g + 2] = 67;
                    break;
                }
                case 1004: {
                    sequence[g + 2] = 68;
                    break;
                }
            }
            g += 2;
        }
        return sequence;
    }

    public byte[] getCursorPositioningSequence(int[] pos) {
        byte[] sequence = null;
        if (pos == TerminalIO.HOME) {
            sequence = new byte[]{27, 91, 72};
        } else {
            byte[] rowdigits = this.translateIntToDigitCodes(pos[0]);
            byte[] columndigits = this.translateIntToDigitCodes(pos[1]);
            int offset = 0;
            sequence = new byte[4 + rowdigits.length + columndigits.length];
            sequence[0] = 27;
            sequence[1] = 91;
            System.arraycopy(rowdigits, 0, sequence, 2, rowdigits.length);
            offset = 2 + rowdigits.length;
            sequence[offset] = 59;
            System.arraycopy(columndigits, 0, sequence, ++offset, columndigits.length);
            sequence[offset += columndigits.length] = 72;
        }
        return sequence;
    }

    public byte[] getEraseSequence(int eraseFunc) {
        byte[] sequence = null;
        switch (eraseFunc) {
            case 1100: {
                sequence = new byte[]{27, 91, 75};
                break;
            }
            case 1101: {
                sequence = new byte[]{27, 91, 49, 75};
                break;
            }
            case 1103: {
                sequence = new byte[]{27, 91, 50, 75};
                break;
            }
            case 1104: {
                sequence = new byte[]{27, 91, 74};
                break;
            }
            case 1105: {
                sequence = new byte[]{27, 91, 49, 74};
                break;
            }
            case 1106: {
                sequence = new byte[]{27, 91, 50, 74};
                break;
            }
        }
        return sequence;
    }

    public byte[] getSpecialSequence(int function) {
        byte[] sequence = null;
        switch (function) {
            case 1051: {
                sequence = new byte[]{27, 55};
                break;
            }
            case 1052: {
                sequence = new byte[]{27, 56};
            }
        }
        return sequence;
    }

    public byte[] getGRSequence(int type, int param) {
        byte[] sequence = new byte[]{};
        int offset = 0;
        switch (type) {
            case 10001: 
            case 10002: {
                byte[] color = this.translateIntToDigitCodes(param);
                sequence = new byte[3 + color.length];
                sequence[0] = 27;
                sequence[1] = 91;
                System.arraycopy(color, 0, sequence, 2, color.length);
                offset = 2 + color.length;
                sequence[offset] = 109;
                break;
            }
            case 10003: {
                byte[] style = this.translateIntToDigitCodes(param);
                sequence = new byte[3 + style.length];
                sequence[0] = 27;
                sequence[1] = 91;
                System.arraycopy(style, 0, sequence, 2, style.length);
                offset = 2 + style.length;
                sequence[offset] = 109;
                break;
            }
            case 10004: {
                sequence = new byte[]{27, 91, 52, 56, 109};
            }
        }
        return sequence;
    }

    public byte[] getScrollMarginsSequence(int topmargin, int bottommargin) {
        byte[] sequence = new byte[]{};
        if (this.supportsScrolling()) {
            byte[] topdigits = this.translateIntToDigitCodes(topmargin);
            byte[] bottomdigits = this.translateIntToDigitCodes(bottommargin);
            int offset = 0;
            sequence = new byte[4 + topdigits.length + bottomdigits.length];
            sequence[0] = 27;
            sequence[1] = 91;
            System.arraycopy(topdigits, 0, sequence, 2, topdigits.length);
            offset = 2 + topdigits.length;
            sequence[offset] = 59;
            System.arraycopy(bottomdigits, 0, sequence, ++offset, bottomdigits.length);
            sequence[offset += bottomdigits.length] = 114;
        }
        return sequence;
    }

    public String format(String str) {
        return this.myColorizer.colorize(str, this.supportsSGR());
    }

    public byte[] getInitSequence() {
        byte[] sequence = new byte[]{};
        return sequence;
    }

    public int getAtomicSequenceLength() {
        return 2;
    }

    public byte[] translateIntToDigitCodes(int in) {
        return Integer.toString(in).getBytes();
    }

    public abstract boolean supportsSGR();

    public abstract boolean supportsScrolling();
}

