/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhInit;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhReply;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DhGroup1Sha1
extends SshKeyExchange {
    private static Log log = LogFactory.getLog(DhGroup1Sha1.class);
    private static BigInteger g = new BigInteger("2");
    private static BigInteger p = new BigInteger(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1});
    private BigInteger e = null;
    private BigInteger f = null;
    private BigInteger x = null;
    private BigInteger y = null;
    private String clientId;
    private String serverId;
    private byte[] clientKexInit;
    private byte[] serverKexInit;
    private KeyPairGenerator dhKeyPairGen;
    private KeyAgreement dhKeyAgreement;

    protected void onInit() throws IOException {
        this.transport.getMessageStore().registerMessage(30, SshMsgKexDhInit.class);
        this.transport.getMessageStore().registerMessage(31, SshMsgKexDhReply.class);
        try {
            this.dhKeyPairGen = KeyPairGenerator.getInstance("DH");
            this.dhKeyAgreement = KeyAgreement.getInstance("DH");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AlgorithmNotSupportedException(ex.getMessage());
        }
    }

    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        log.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        try {
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, g);
            this.dhKeyPairGen.initialize(dhSkipParamSpec);
            KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
            this.dhKeyAgreement.init(dhKeyPair.getPrivate());
            this.x = ((DHPrivateKey)dhKeyPair.getPrivate()).getX();
            this.e = ((DHPublicKey)dhKeyPair.getPublic()).getY();
        }
        catch (InvalidKeyException ex) {
            throw new AlgorithmOperationException("Failed to generate DH value");
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new AlgorithmOperationException("Failed to generate DH value");
        }
        SshMsgKexDhInit msg = new SshMsgKexDhInit(this.e);
        try {
            this.transport.sendMessage(msg, this);
        }
        catch (SshException tpe) {
            throw new KeyExchangeException("Failed to send key exchange initailaztion message");
        }
        int[] messageId = new int[]{31};
        SshMsgKexDhReply reply = (SshMsgKexDhReply)this.transport.readMessage(messageId);
        this.hostKey = reply.getHostKey();
        this.signature = reply.getSignature();
        this.f = reply.getF();
        this.secret = this.f.modPow(this.x, p);
        this.calculateExchangeHash();
    }

    public void performServerExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvKey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        try {
            this.clientId = clientId;
            this.serverId = serverId;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            try {
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                this.y = ((DHPrivateKey)dhKeyPair.getPrivate()).getX();
                this.f = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            }
            catch (InvalidKeyException ex) {
                throw new AlgorithmOperationException("Failed to generate DH y value");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new AlgorithmOperationException("Failed to generate DH y value");
            }
            int[] messageId = new int[]{30};
            SshMsgKexDhInit msg = (SshMsgKexDhInit)this.transport.readMessage(messageId);
            if (firstPacketFollows && !useFirstPacket) {
                msg = (SshMsgKexDhInit)this.transport.readMessage(messageId);
            }
            this.e = msg.getE();
            this.secret = this.e.modPow(this.y, p);
            this.hostKey = prvKey.getPublicKey().getEncoded();
            this.calculateExchangeHash();
            this.signature = prvKey.generateSignature(this.exchangeHash);
            SshMsgKexDhReply reply = new SshMsgKexDhReply(this.hostKey, this.f, this.signature);
            this.transport.sendMessage(reply, this);
        }
        catch (SshException e) {
            throw new KeyExchangeException(e.getMessage());
        }
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        Hash hash;
        try {
            hash = new Hash("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }
}

