/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyFormatConversion;
import com.sshtools.j2ssh.util.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Base64EncodedFileFormat
implements SshKeyFormatConversion {
    protected String begin;
    protected String end;
    private Map headers = new HashMap();
    private int MAX_LINE_LENGTH = 70;

    protected Base64EncodedFileFormat(String begin, String end) {
        this.begin = begin;
        this.end = end;
    }

    public String getFormatType() {
        return "Base64Encoded";
    }

    public boolean isFormatted(byte[] formattedKey) {
        String test = new String(formattedKey);
        return test.indexOf(this.begin) >= 0 && test.indexOf(this.end) > 0;
    }

    public void setHeaderValue(String headerTag, String headerValue) {
        this.headers.put(headerTag, headerValue);
    }

    public String getHeaderValue(String headerTag) {
        return (String)this.headers.get(headerTag);
    }

    public byte[] getKeyBlob(byte[] formattedKey) throws InvalidSshKeyException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(formattedKey)));
        String blob = "";
        try {
            String line;
            do {
                if ((line = reader.readLine()) != null) continue;
                throw new InvalidSshKeyException("Incorrect file format!");
            } while (!line.endsWith(this.begin));
            while (true) {
                if ((line = reader.readLine()) == null) {
                    throw new InvalidSshKeyException("Incorrect file format!");
                }
                int index = line.indexOf(": ");
                if (index <= 0) break;
                while (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                    String tmp = reader.readLine();
                    if (tmp == null) {
                        throw new InvalidSshKeyException("Incorrect file format!");
                    }
                    line = line + tmp;
                }
                String headerTag = line.substring(0, index);
                String headerValue = line.substring(index + 2);
                this.headers.put(headerTag, headerValue);
            }
            ByteArrayWriter baw = new ByteArrayWriter();
            do {
                blob = blob + line;
                line = reader.readLine();
                if (line != null) continue;
                throw new InvalidSshKeyException("Invalid file format!");
            } while (!line.endsWith(this.end));
            return Base64.decode(blob);
        }
        catch (IOException ioe) {
            throw new InvalidSshKeyException();
        }
    }

    public byte[] formatKey(byte[] keyblob) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(this.begin.getBytes());
            out.write(10);
            Set tags = this.headers.keySet();
            for (String headerTag : tags) {
                String headerValue = (String)this.headers.get(headerTag);
                String header = headerTag + ": " + headerValue;
                for (int pos = 0; pos < header.length(); pos += this.MAX_LINE_LENGTH) {
                    String line = header.substring(pos, pos + this.MAX_LINE_LENGTH < header.length() ? pos + this.MAX_LINE_LENGTH : header.length()) + (pos + this.MAX_LINE_LENGTH < header.length() ? "\\" : "");
                    out.write(line.getBytes());
                    out.write(10);
                }
            }
            String encoded = Base64.encodeBytes(keyblob, false);
            out.write(encoded.getBytes());
            out.write(10);
            out.write(this.end.getBytes());
            out.write(10);
            return out.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

