/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionClassLoader
extends ClassLoader {
    private static Log log = LogFactory.getLog(ExtensionClassLoader.class);
    Vector classpath = new Vector();
    private Hashtable cache = new Hashtable();
    private HashMap packages = new HashMap();

    public ExtensionClassLoader() {
    }

    public ExtensionClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void add(String file) {
        this.add(new File(file));
    }

    public void add(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.add(files[i]);
        }
    }

    public void add(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Classpath " + file.getAbsolutePath() + " doesn't exist!");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Don't have read access for file " + file.getAbsolutePath());
        }
        if (!file.isDirectory() && !this.isJarArchive(file)) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or jar file" + " or if it's a jar file then it is corrupted.");
        }
        log.info("Adding " + file.getAbsolutePath() + " to the extension classpath");
        this.classpath.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isJarArchive(File file) {
        boolean isArchive = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var6_4 = null;
        if (zipFile == null) return isArchive;
        try {
            zipFile.close();
            return isArchive;
        }
        catch (IOException ignored) {}
        return isArchive;
        {
            catch (ZipException zipCurrupted) {
                isArchive = false;
                Object var6_5 = null;
                if (zipFile == null) return isArchive;
                try {
                    zipFile.close();
                    return isArchive;
                }
                catch (IOException ignored) {}
                return isArchive;
            }
            catch (IOException anyIOError) {
                isArchive = false;
                Object var6_6 = null;
                if (zipFile == null) return isArchive;
                try {
                    zipFile.close();
                    return isArchive;
                }
                catch (IOException ignored) {}
                return isArchive;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public URL getResource(String name, File location) {
        if (this.isJarArchive(location)) {
            return this.findResourceInZipfile(location, name);
        }
        return this.findResourceInDirectory(location, name);
    }

    protected URL findResource(String name) {
        URL url = null;
        for (File file : this.classpath) {
            url = file.isDirectory() ? this.findResourceInDirectory(file, name) : this.findResourceInZipfile(file, name);
            if (url != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found resource " + url.toExternalForm());
                }
                return url;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Could not find resource " + name);
        }
        return null;
    }

    protected Enumeration findResources(String name) {
        HashSet<URL> resources = new HashSet<URL>();
        URL url = null;
        for (File file : this.classpath) {
            url = file.isDirectory() ? this.findResourceInDirectory(file, name) : this.findResourceInZipfile(file, name);
            if (url == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found resource " + url.toExternalForm());
            }
            resources.add(url);
        }
        return new ResourceEnumeration(resources);
    }

    public byte[] loadClassData(String name) throws ClassNotFoundException {
        Iterator it = this.classpath.iterator();
        ClassCacheEntry classCache = new ClassCacheEntry();
        while (it.hasNext()) {
            byte[] classData;
            File file = (File)it.next();
            try {
                classData = file.isDirectory() ? this.loadClassFromDirectory(file, name, null) : this.loadClassFromZipfile(file, name, null);
            }
            catch (IOException ioe) {
                classData = null;
            }
            if (classData == null) continue;
            return classData;
        }
        throw new ClassNotFoundException(name);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = null;
        ClassCacheEntry entry = (ClassCacheEntry)this.cache.get(name);
        if (entry != null) {
            if (log.isDebugEnabled()) {
                log.debug("Loaded " + name + " from cache");
            }
            c = entry.loadedClass;
            this.resolveClass(c);
            return c;
        }
        Iterator it = this.classpath.iterator();
        ClassCacheEntry classCache = new ClassCacheEntry();
        while (it.hasNext()) {
            byte[] classData;
            File file = (File)it.next();
            try {
                classData = file.isDirectory() ? this.loadClassFromDirectory(file, name, classCache) : this.loadClassFromZipfile(file, name, classCache);
            }
            catch (IOException ioe) {
                classData = null;
            }
            if (classData == null) continue;
            String packageName = "";
            if (name.lastIndexOf(".") > 0) {
                packageName = name.substring(0, name.lastIndexOf("."));
            }
            if (!packageName.equals("") && !this.packages.containsKey(packageName)) {
                this.packages.put(packageName, this.definePackage(packageName, "", "", "", "", "", "", null));
            }
            classCache.loadedClass = c = this.defineClass(name, classData, 0, classData.length);
            classCache.lastModified = classCache.origin.lastModified();
            this.cache.put(name, classCache);
            this.resolveClass(c);
            if (log.isDebugEnabled()) {
                log.debug("Loaded " + name + " adding to cache and returning");
            }
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    private byte[] loadBytesFromStream(InputStream in, int length) throws IOException {
        int nRead;
        byte[] buf = new byte[length];
        int count = 0;
        while (length > 0 && (nRead = in.read(buf, count, length)) != -1) {
            count += nRead;
            length -= nRead;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File dir, String name, ClassCacheEntry cache) throws IOException {
        File classFile;
        String classFileName = name.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(classFileName.charAt(0))) {
            int start = 1;
            while (!Character.isJavaIdentifierStart(classFileName.charAt(start++))) {
            }
            classFileName = classFileName.substring(start);
        }
        if ((classFile = new File(dir, classFileName)).exists()) {
            byte[] byArray;
            if (cache != null) {
                cache.origin = classFile;
            }
            FileInputStream in = new FileInputStream(classFile);
            try {
                byArray = this.loadBytesFromStream(in, (int)classFile.length());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String name, ClassCacheEntry cache) throws IOException {
        ZipFile zipfile;
        block4: {
            byte[] byArray;
            String classFileName = name.replace('.', '/') + ".class";
            zipfile = new ZipFile(file);
            try {
                ZipEntry entry = zipfile.getEntry(classFileName);
                if (entry == null) break block4;
                if (cache != null) {
                    cache.origin = file;
                }
                byArray = this.loadBytesFromStream(zipfile.getInputStream(entry), (int)entry.getSize());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                zipfile.close();
                throw throwable;
            }
            zipfile.close();
            return byArray;
        }
        byte[] byArray = null;
        Object var9_10 = null;
        zipfile.close();
        return byArray;
    }

    private InputStream loadResourceFromDirectory(File dir, String name) {
        String fileName = name.replace('/', File.separatorChar);
        File resFile = new File(dir, fileName);
        if (resFile.exists()) {
            try {
                return new FileInputStream(resFile);
            }
            catch (FileNotFoundException shouldnothappen) {
                return null;
            }
        }
        return null;
    }

    private URL findResourceInDirectory(File dir, String name) {
        String fileName = name.replace('/', File.separatorChar);
        File resFile = new File(dir, fileName);
        if (resFile.exists()) {
            try {
                return resFile.toURL();
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    private URL findResourceInZipfile(File file, String name) {
        try {
            ZipFile zipfile = new ZipFile(file);
            ZipEntry entry = zipfile.getEntry(name);
            if (entry != null) {
                return new URL("jar:" + file.toURL() + "!" + (name.startsWith("/") ? "" : "/") + name);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private InputStream loadResourceFromZipfile(File file, String name) {
        try {
            ZipFile zipfile = new ZipFile(file);
            ZipEntry entry = zipfile.getEntry(name);
            if (entry != null) {
                return zipfile.getInputStream(entry);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }

    private class ResourceEnumeration
    implements Enumeration {
        Set resources;
        Iterator it;

        ResourceEnumeration(Set resources) {
            this.resources = resources;
            this.it = resources.iterator();
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }
}

