/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import com.cisco.hfr.mgbl.model.IConnectionParams;
import com.cisco.hfr.mgbl.model.IConnectionParams2;
import de.mud.jta.CliSessionProxy;
import de.mud.jta.HostUnreachableException;
import de.mud.jta.ICliSession;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CliSessionFactory {
    private static Log log = LogFactory.getLog(CliSessionFactory.class);
    private static int mLastGoodSessionType = -1;
    private static final int PORT_REESTABLISH_DELAY = 1500;

    private CliSessionFactory() {
    }

    public static ICliSession getCliSession(IConnectionParams connParams, HashMap properties, int reqSessionType) throws HostUnreachableException {
        IConnectionParams2 connParams2;
        String neName = connParams.getNetworkElementName();
        if (connParams instanceof IConnectionParams2 && (connParams2 = (IConnectionParams2)connParams).getConnectionCategory() == 3) {
            neName = neName.substring(0, neName.indexOf("("));
        }
        return CliSessionFactory.getCliSession(neName, connParams.getUserName(), connParams.getPassword(), connParams, properties, reqSessionType);
    }

    public static ICliSession getCliSession(String hostname, String userName, String password, int reqSessionType) throws HostUnreachableException {
        return CliSessionFactory.getCliSession(hostname, userName, password, null, reqSessionType);
    }

    public static ICliSession getCliSession(String hostname, String userName, String password, HashMap properties, int reqSessionType) throws HostUnreachableException {
        return CliSessionFactory.getCliSession(hostname, userName, password, null, properties, reqSessionType);
    }

    private static ICliSession getCliSession(String hostname, String userName, String password, IConnectionParams connParams, HashMap properties, int reqSessionType) throws HostUnreachableException {
        ICliSession cliSession = null;
        log.debug("Last good session type : " + mLastGoodSessionType);
        log.debug("Requested session type : " + reqSessionType);
        int sessionType = reqSessionType;
        if (sessionType == -1) {
            sessionType = mLastGoodSessionType;
        }
        try {
            cliSession = CliSessionFactory.establishSession(hostname, userName, password, connParams, properties, sessionType);
        }
        catch (HostUnreachableException hue) {
            log.warn("Unable to establish connection with protocol : " + sessionType, hue);
            mLastGoodSessionType = -1;
            if (reqSessionType == -1 && sessionType != -1) {
                CliSessionFactory.connectPause();
                cliSession = CliSessionFactory.establishSession(hostname, userName, password, connParams, properties, -1);
            }
            throw hue;
        }
        return cliSession;
    }

    private static ICliSession establishSession(String hostname, String userName, String password, IConnectionParams connParams, HashMap properties, int sessionType) throws HostUnreachableException {
        CliSessionProxy cliSession = null;
        if (sessionType == -1) {
            try {
                log.debug("Trying SSHv2...");
                cliSession = new CliSessionProxy(0, hostname, userName, password, connParams, properties);
            }
            catch (HostUnreachableException ex) {
                log.warn("Unable to connect with SSHv2...", ex);
            }
            if (cliSession != null) {
                mLastGoodSessionType = 0;
            } else {
                CliSessionFactory.connectPause();
                try {
                    log.debug("Trying SSHv1...");
                    cliSession = new CliSessionProxy(1, hostname, userName, password, connParams, properties);
                }
                catch (HostUnreachableException ex) {
                    log.warn("Unable to connect with SSHv1...", ex);
                }
                if (cliSession != null) {
                    mLastGoodSessionType = 1;
                } else {
                    CliSessionFactory.connectPause();
                    log.debug("Trying telnet...");
                    cliSession = new CliSessionProxy(2, hostname, userName, password, connParams, properties);
                    if (cliSession != null) {
                        mLastGoodSessionType = 2;
                    }
                }
            }
        } else {
            log.debug("Trying session type : " + sessionType);
            cliSession = new CliSessionProxy(sessionType, hostname, userName, password, connParams, properties);
        }
        return cliSession;
    }

    private static void connectPause() {
        try {
            log.debug("Before creating session, sleep for 1500 ms");
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static ICliSession createSerialSession(String hostname, String userName, String password, HashMap properties) throws HostUnreachableException {
        return new CliSessionProxy(3, hostname, userName, password, properties);
    }
}

