/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostUnreachableException
extends IOException {
    public static final String CAUSE_UNKNOWN_ERROR = "Unknown Error.";
    public static final String CAUSE_LOGIN_ERROR = "Wrong UserName/Password combination.";
    public static final String SUGGESTION_LOGIN_ERROR = "Login with correct UserName and Password.";
    public static final String CAUSE_TELNET_SERVER_ERROR = "Unable to establish a %TYPE% session with %HOST%.";
    public static final String SUGGESTION_TELNET_SERVER_ERROR = "Please verify connectivity and ensure that Telnet/SSH is enabled";
    public static final String CAUSE_HOST_ERROR = "Device unreachable.";
    public static final String SUGGESTION_HOST_ERROR = "Please verify device connectivity and configuration.";
    public static final String CAUSE_HOST_CLOSE_ERROR = "Connection closed by foreign host.";
    public static final String SUGGESTION_HOST_CLOSE_ERROR = "Please verify device connectivity and configuration.";
    public static final String CAUSE_SHOW_CRAFT_FAIL_ERROR = "Unable to determine which plug-in to use for this device.";
    public static final String SUGGESTION_SHOW_CRAFT_FAIL_ERROR = "Use Lite Mode to connect.";
    public static final String CAUSE_UNKNOWN_HOST_ERROR = "No route to host %HOST%.";
    public static final String SUGGESTION_UNKNOWN_HOST_ERROR = "Verify that hostname/IP address is correct.";
    private String mProbableCause = "";
    private String mSuggestion = "";

    public HostUnreachableException(String probableCause) {
        this(probableCause, "");
    }

    public HostUnreachableException(String probableCause, String suggestion) {
        if (probableCause != null) {
            this.mProbableCause = probableCause;
            this.mSuggestion = suggestion;
        } else {
            this.mProbableCause = CAUSE_UNKNOWN_ERROR;
        }
    }

    public String getProbableCause() {
        return this.mProbableCause;
    }

    public String getSuggestion() {
        return this.mSuggestion;
    }

    @Override
    public String getMessage() {
        return this.mProbableCause + "\n" + this.mSuggestion;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public static String getParametrizedMessage(String msg, HashMap<String, String> params) {
        for (String s : params.keySet()) {
            msg = msg.replaceAll(s, params.get(s));
        }
        return msg;
    }
}

