/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.LocalEchoRequest;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TerminalTypeRequest;
import de.mud.jta.event.WindowSizeRequest;
import de.mud.ssh.SshIO;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class SSH
extends Plugin
implements FilterPlugin,
VisualPlugin {
    protected FilterPlugin source;
    protected SshIO handler;
    protected String user;
    protected String pass;
    private static final int debug = 0;
    private boolean auth = false;
    private byte[] buffer;
    private int pos;

    public SSH(final PluginBus bus, final String id) {
        super(bus, id);
        this.handler = new SshIO(){

            public String getTerminalType() {
                return (String)bus.broadcast(new TerminalTypeRequest());
            }

            public Dimension getWindowSize() {
                return (Dimension)bus.broadcast(new WindowSizeRequest());
            }

            public void setLocalEcho(boolean echo) {
                bus.broadcast(new LocalEchoRequest(echo));
            }

            public void write(byte[] b) throws IOException {
                SSH.this.source.write(b);
            }
        };
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                SSH.this.user = config.getProperty("SSH", id, "user");
                SSH.this.pass = config.getProperty("SSH", id, "password");
            }
        });
        bus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                SSH.this.handler.setLogin(SSH.this.user);
                SSH.this.handler.setPassword(SSH.this.pass);
                SSH.this.auth = true;
            }

            public void offline() {
                SSH.this.handler.disconnect();
                SSH.this.auth = false;
            }
        });
    }

    public void setAuthenticationInfo(String userName, String password) {
        this.user = userName;
        this.pass = password;
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] b) throws IOException {
        while (!this.auth) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.buffer != null) {
            int amount = this.buffer.length - this.pos <= b.length ? this.buffer.length - this.pos : b.length;
            System.arraycopy(this.buffer, this.pos, b, 0, amount);
            if (this.pos + amount < this.buffer.length) {
                this.pos += amount;
            } else {
                this.buffer = null;
            }
            return amount;
        }
        int n = this.source.read(b);
        if (n > 0) {
            byte[] tmp = new byte[n];
            System.arraycopy(b, 0, tmp, 0, n);
            this.pos = 0;
            this.buffer = this.handler.handleSSH(tmp);
            if (this.buffer != null && this.buffer.length > 0) {
                int amount = this.buffer.length <= b.length ? this.buffer.length : b.length;
                System.arraycopy(this.buffer, 0, b, 0, amount);
                this.pos = n = amount;
                if (amount == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        if (!this.auth) {
            return;
        }
        for (int i = 0; i < b.length; ++i) {
            switch (b[i]) {
                case 10: {
                    b[i] = 13;
                }
            }
        }
        this.handler.sendData(new String(b));
    }

    public JComponent getPluginVisual() {
        return null;
    }

    public JMenu getPluginMenu() {
        return null;
    }
}

