/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.FocusStatus;
import de.mud.jta.event.LocalEchoListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusListener;
import de.mud.jta.event.SoundRequest;
import de.mud.jta.event.TelnetCommandRequest;
import de.mud.jta.event.TerminalTypeListener;
import de.mud.jta.event.WindowSizeListener;
import de.mud.terminal.SwingTerminal;
import de.mud.terminal.vt320;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class Terminal
extends Plugin
implements FilterPlugin,
VisualTransferPlugin,
ClipboardOwner,
Runnable {
    private static final boolean personalJava = false;
    private static final int debug = 0;
    protected SwingTerminal terminal;
    protected vt320 emulation;
    protected String encoding = "latin1";
    protected SoundRequest audioBeep = null;
    protected JPanel tPanel;
    protected JMenu menu;
    private Thread reader = null;
    private Hashtable colors = new Hashtable();
    private boolean localecho_overridden = false;
    protected FilterPlugin source;

    private Color codeToColor(String code) {
        if (this.colors.get(code) != null) {
            return (Color)this.colors.get(code);
        }
        try {
            if (Color.getColor(code) != null) {
                return Color.getColor(code);
            }
            return Color.decode(code);
        }
        catch (Exception e) {
            this.error("ignoring unknown color code: " + code);
            return null;
        }
    }

    public Terminal(final PluginBus bus, String id) {
        super(bus, id);
        JMenuItem item;
        this.emulation = new vt320(){

            public void write(byte[] b) {
                try {
                    Terminal.this.write(b);
                }
                catch (IOException e) {
                    Terminal.this.reader = null;
                }
            }

            public void beep() {
                if (Terminal.this.audioBeep != null) {
                    bus.broadcast(Terminal.this.audioBeep);
                }
            }

            public void sendTelnetCommand(byte cmd) {
                bus.broadcast(new TelnetCommandRequest(cmd));
            }
        };
        this.terminal = new SwingTerminal(this.emulation);
        this.colors.put("black", Color.black);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("blue", Color.blue);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("orange", Color.orange);
        this.colors.put("pink", Color.pink);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("white", Color.white);
        this.colors.put("gray", Color.gray);
        this.colors.put("darkgray", Color.darkGray);
        this.menu = new JMenu("Terminal");
        JMenu fgm = new JMenu("Foreground");
        JMenu bgm = new JMenu("Background");
        Enumeration cols = this.colors.keys();
        ActionListener fgl = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal.this.terminal.setForeground((Color)Terminal.this.colors.get(e.getActionCommand()));
                Terminal.this.tPanel.repaint();
            }
        };
        ActionListener bgl = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal.this.terminal.setBackground((Color)Terminal.this.colors.get(e.getActionCommand()));
                Terminal.this.tPanel.repaint();
            }
        };
        while (cols.hasMoreElements()) {
            String color = (String)cols.nextElement();
            item = new JMenuItem(color);
            fgm.add(item);
            item.addActionListener(fgl);
            item = new JMenuItem(color);
            bgm.add(item);
            item.addActionListener(bgl);
        }
        this.menu.add(fgm);
        this.menu.add(bgm);
        item = new JMenuItem("Smaller Font");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() - 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container parent = Terminal.this.tPanel;
                    while ((parent = parent.getParent()) != null && !(parent instanceof JFrame)) {
                    }
                    if (parent instanceof JFrame) {
                        ((Frame)parent).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        item = new JMenuItem("Larger Font");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font font = Terminal.this.terminal.getFont();
                Terminal.this.terminal.setFont(new Font(font.getName(), font.getStyle(), font.getSize() + 1));
                if (Terminal.this.tPanel.getParent() != null) {
                    Container parent = Terminal.this.tPanel;
                    while ((parent = parent.getParent()) != null && !(parent instanceof JFrame)) {
                    }
                    if (parent instanceof JFrame) {
                        ((Frame)parent).pack();
                    }
                    Terminal.this.tPanel.getParent().doLayout();
                    Terminal.this.tPanel.getParent().validate();
                }
            }
        });
        item = new JMenuItem("Buffer +50");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal.this.emulation.setBufferSize(Terminal.this.emulation.getBufferSize() + 50);
            }
        });
        item = new JMenuItem("Buffer -50");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal.this.emulation.setBufferSize(Terminal.this.emulation.getBufferSize() - 50);
            }
        });
        this.menu.addSeparator();
        item = new JMenuItem("Reset Terminal");
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Terminal.this.emulation.reset();
            }
        });
        this.tPanel = new JPanel(new BorderLayout()){

            public void update(Graphics g) {
                this.paint(g);
            }

            public void print(Graphics g) {
                Terminal.this.terminal.print(g);
            }
        };
        this.tPanel.add("Center", this.terminal);
        this.terminal.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                Terminal.this.terminal.setCursor(Cursor.getPredefinedCursor(2));
                bus.broadcast(new FocusStatus(Terminal.this, evt));
            }

            public void focusLost(FocusEvent evt) {
                Terminal.this.terminal.setCursor(Cursor.getDefaultCursor());
                bus.broadcast(new FocusStatus(Terminal.this, evt));
            }
        });
        bus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                if (Terminal.this.reader == null) {
                    Terminal.this.reader = new Thread(Terminal.this);
                    Terminal.this.reader.start();
                }
            }

            public void offline() {
                if (Terminal.this.reader != null) {
                    Terminal.this.reader = null;
                }
            }
        });
        bus.registerPluginListener(new TerminalTypeListener(){

            public String getTerminalType() {
                return Terminal.this.emulation.getTerminalID();
            }
        });
        bus.registerPluginListener(new WindowSizeListener(){

            public Dimension getWindowSize() {
                return new Dimension(Terminal.this.emulation.getColumns(), Terminal.this.emulation.getRows());
            }
        });
        bus.registerPluginListener(new LocalEchoListener(){

            public void setLocalEcho(boolean echo) {
                if (!Terminal.this.localecho_overridden) {
                    Terminal.this.emulation.setLocalEcho(echo);
                }
            }
        });
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                Terminal.this.configure(config);
            }
        });
        bus.registerPluginListener(new ReturnFocusListener(){

            public void returnFocus() {
                Terminal.this.terminal.requestFocus();
            }
        });
    }

    private void configure(PluginConfig cfg) {
        String direction;
        String tmp = cfg.getProperty("Terminal", this.id, "foreground");
        if (tmp != null) {
            this.terminal.setForeground(Color.decode(tmp));
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "background")) != null) {
            this.terminal.setBackground(Color.decode(tmp));
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "print.color")) != null) {
            try {
                this.terminal.setColorPrinting(Boolean.valueOf(tmp));
            }
            catch (Exception e) {
                this.error("Terminal.color.print: must be either true or false, not " + tmp);
            }
        }
        System.err.print("colorSet: ");
        tmp = cfg.getProperty("Terminal", this.id, "colorSet");
        if (tmp != null) {
            System.err.println(tmp);
            Properties colorSet = new Properties();
            try {
                colorSet.load(this.getClass().getResourceAsStream(tmp));
            }
            catch (Exception e) {
                try {
                    colorSet.load(new URL(tmp).openStream());
                }
                catch (Exception ue) {
                    this.error("cannot find colorSet: " + tmp);
                    this.error("resource access failed: " + e);
                    this.error("URL access failed: " + ue);
                    colorSet = null;
                }
            }
            if (colorSet != null) {
                Color[] set = this.terminal.getColorSet();
                Color color = null;
                for (int i = 0; i < 8; ++i) {
                    tmp = colorSet.getProperty("color" + i);
                    if (tmp == null || (color = this.codeToColor(tmp)) == null) continue;
                    set[i] = color;
                }
                tmp = colorSet.getProperty("bold");
                if (tmp != null && (color = this.codeToColor(tmp)) != null) {
                    set[8] = color;
                }
                if ((tmp = colorSet.getProperty("invert")) != null && (color = this.codeToColor(tmp)) != null) {
                    set[9] = color;
                }
                this.terminal.setColorSet(set);
            }
        }
        String cFG = cfg.getProperty("Terminal", this.id, "cursor.foreground");
        String cBG = cfg.getProperty("Terminal", this.id, "cursor.background");
        if (cFG != null || cBG != null) {
            try {
                Color fg;
                Color color = cFG == null ? this.terminal.getBackground() : (fg = Color.getColor(cFG) != null ? Color.getColor(cFG) : Color.decode(cFG));
                Color bg = cBG == null ? this.terminal.getForeground() : (Color.getColor(cBG) != null ? Color.getColor(cBG) : Color.decode(cBG));
                this.terminal.setCursorColors(fg, bg);
            }
            catch (Exception e) {
                this.error("ignoring unknown cursor color code: " + tmp);
            }
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "border")) != null) {
            String size = tmp;
            boolean raised = false;
            tmp = cfg.getProperty("Terminal", this.id, "borderRaised");
            if (tmp != null) {
                raised = Boolean.valueOf(tmp);
            }
            this.terminal.setBorder(Integer.parseInt(size), raised);
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "localecho")) != null) {
            this.emulation.setLocalEcho(Boolean.valueOf(tmp));
            this.localecho_overridden = true;
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "scrollBar")) != null && !(direction = tmp).equals("none")) {
            if (!direction.equals("East") && !direction.equals("West")) {
                direction = "East";
            }
            JScrollBar scrollBar = new JScrollBar();
            this.tPanel.add(direction, scrollBar);
            this.terminal.setScrollbar(scrollBar);
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "id")) != null) {
            this.emulation.setTerminalID(tmp);
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "answerback")) != null) {
            this.emulation.setAnswerBack(tmp);
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "buffer")) != null) {
            this.emulation.setBufferSize(Integer.parseInt(tmp));
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "size")) != null) {
            try {
                int idx = tmp.indexOf(44);
                int width = Integer.parseInt(tmp.substring(1, idx).trim());
                int height = Integer.parseInt(tmp.substring(idx + 1, tmp.length() - 1).trim());
                this.emulation.setScreenSize(width, height);
            }
            catch (Exception e) {
                this.error("screen size is wrong: " + tmp);
                this.error("error: " + e);
            }
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "resize")) != null) {
            if (tmp.equals("font")) {
                this.terminal.setResizeStrategy(1);
            } else if (tmp.equals("screen")) {
                this.terminal.setResizeStrategy(2);
            } else {
                this.terminal.setResizeStrategy(0);
            }
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "font")) != null) {
            String fontStyle;
            String font = tmp;
            int style = 0;
            int fsize = 12;
            tmp = cfg.getProperty("Terminal", this.id, "fontSize");
            if (tmp != null) {
                fsize = Integer.parseInt(tmp);
            }
            if ((fontStyle = cfg.getProperty("Terminal", this.id, "fontStyle")) == null || fontStyle.equals("plain")) {
                style = 0;
            } else if (fontStyle.equals("bold")) {
                style = 1;
            } else if (fontStyle.equals("italic")) {
                style = 2;
            } else if (fontStyle.equals("bold+italic")) {
                style = 3;
            }
            this.terminal.setFont(new Font(font, style, fsize));
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "keyCodes")) != null) {
            Properties keyCodes = new Properties();
            try {
                keyCodes.load(this.getClass().getResourceAsStream(tmp));
            }
            catch (Exception e) {
                try {
                    keyCodes.load(new URL(tmp).openStream());
                }
                catch (Exception ue) {
                    this.error("cannot find keyCodes: " + tmp);
                    this.error("resource access failed: " + e);
                    this.error("URL access failed: " + ue);
                    keyCodes = null;
                }
            }
            if (keyCodes != null) {
                this.emulation.setKeyCodes(keyCodes);
            }
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "VMS")) != null) {
            this.emulation.setVMS(Boolean.valueOf(tmp));
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "IBM")) != null) {
            this.emulation.setIBMCharset(Boolean.valueOf(tmp));
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "encoding")) != null) {
            this.encoding = tmp;
        }
        if ((tmp = cfg.getProperty("Terminal", this.id, "beep")) != null) {
            try {
                this.audioBeep = new SoundRequest(new URL(tmp));
            }
            catch (MalformedURLException e) {
                this.error("incorrect URL for audio ping: " + e);
            }
        }
        this.tPanel.setBackground(this.terminal.getBackground());
    }

    public void run() {
        byte[] b = new byte[256];
        int n = 0;
        while (n >= 0) {
            try {
                n = this.read(b);
                if (n > 0) {
                    this.emulation.putString(new String(b, 0, n, this.encoding));
                }
                this.tPanel.repaint();
            }
            catch (IOException e) {
                this.reader = null;
                break;
            }
        }
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] b) throws IOException {
        return this.source.read(b);
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }

    public JComponent getPluginVisual() {
        return this.tPanel;
    }

    public JMenu getPluginMenu() {
        return this.menu;
    }

    public void copy(Clipboard clipboard) {
        String data = this.terminal.getSelection();
        if (data == null) {
            return;
        }
        StringSelection selection = new StringSelection(data);
        clipboard.setContents(selection, this);
    }

    public void paste(Clipboard clipboard) {
        if (clipboard == null) {
            return;
        }
        Transferable t = clipboard.getContents(this);
        try {
            byte[] buffer = ((String)t.getTransferData(DataFlavor.stringFlavor)).getBytes();
            try {
                this.write(buffer);
            }
            catch (IOException e) {
                this.reader = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.terminal.clearSelection();
    }
}

