/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.Optics.PM_OPTICS_UNDEFINED;
import cerent.cms.idl.OpticsTopology.eDwdmIO;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.idl.OpticsTopology.eNodeSide;
import cerent.cms.idl.OpticsTopology.eParamCategory;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.eSpectrumGranularity;
import cerent.cms.idl.OpticsTopology.eSystemType;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sParameterValue;
import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.IANSElement;
import cerent.cms.model.ANS.IANSNode;
import cerent.cms.model.ANS.NeANSModel;
import cerent.cms.model.ANS.NodeANS;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.launcher.CmsClassLoader;
import cerent.util.BuildInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SortableProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.TreeMap;

public class ANSManager
extends Model
implements PM_OPTICS_UNDEFINED {
    private static int B_SIZE = 40;
    private static final String MY_DEBUG_KEY = "ANSManager";
    private static final String UNKNOWN = "UNKNOWN";
    private static final boolean MP_USE_STRING = true;
    private boolean ishubEchanged = false;
    private boolean ishubWchanged = false;
    private static ModelSingletonCollection ansSingletons;
    private boolean inited = false;
    private NodeModelDelegate node;
    private NeANSModel neANSModel;
    private IANSNode rootNode = null;
    private static ModelSingletonCollection ansManagerSingletons;

    private ANSManager(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.node = nodeModelDelegate;
        this.index = 0;
        this.db = new ANSManagerDebug(nodeModelDelegate.getDebug());
    }

    public static synchronized ANSManager getInstance(NodeModelDelegate nodeModelDelegate) {
        ANSManager aNSManager;
        if (ansManagerSingletons == null) {
            ansManagerSingletons = ModelSingletonCollection.getMSCInstanceByName(MY_DEBUG_KEY);
        }
        if ((aNSManager = (ANSManager)ansManagerSingletons.get(nodeModelDelegate)) == null) {
            aNSManager = new ANSManager(nodeModelDelegate);
            ansManagerSingletons.add(nodeModelDelegate, aNSManager);
        }
        return aNSManager;
    }

    public NeANSModel getNeANSModel() {
        return this.neANSModel;
    }

    private String[] getLastLevel(String string) {
        if (string == "") {
            return null;
        }
        String[] stringArray = new String[2];
        int n = string.lastIndexOf(".");
        stringArray[0] = string.substring(n + 1);
        stringArray[1] = string.substring(0, n);
        if (this.db.on()) {
            this.db.println("lastlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
        }
        return stringArray;
    }

    private String[] getFirstLevel(String string) {
        String[] stringArray = new String[2];
        if (string == null || string == "") {
            if (this.db.on()) {
                this.db.println("firstlevel:anystring was null or empty");
            }
            stringArray[0] = null;
            stringArray[1] = null;
        } else {
            int n = string.indexOf(".");
            if (n < 0) {
                if (this.db.on()) {
                    this.db.println("firstlevel:Hit End of Line....str = " + string);
                }
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
                if (this.db.on()) {
                    this.db.println("firstlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
                }
            }
        }
        return stringArray;
    }

    private ANSNode childExistsAlready(ANSNode aNSNode, String string) {
        ANSNode[] aNSNodeArray = (ANSNode[])aNSNode.getChildren();
        if (aNSNodeArray == null) {
            if (this.db.on()) {
                this.db.println("childExistsAlready:children == null");
            }
            return null;
        }
        if (aNSNodeArray.length == 0) {
            if (this.db.on()) {
                this.db.println("childExistsAlready:children length == 0");
            }
            return null;
        }
        for (int i = 0; i < aNSNodeArray.length; ++i) {
            if (!aNSNodeArray[i].getName().equals(string)) continue;
            if (this.db.on()) {
                this.db.println("childExistsAlready:found child of name - " + string);
            }
            return aNSNodeArray[i];
        }
        if (this.db.on()) {
            this.db.println("childExistsAlready:didnt find child of name - " + string);
        }
        return null;
    }

    private void makeElementPath(ANSNode aNSNode, String string, ANSElement aNSElement) {
        if (string == null) {
            if (this.db.on()) {
                this.db.println("makeElementPath:end of line...added child " + aNSElement.getName());
            }
            aNSNode.addChild(aNSElement);
            aNSElement.setParent(aNSNode);
            return;
        }
        String[] stringArray = this.getFirstLevel(string);
        ANSNode aNSNode2 = this.childExistsAlready(aNSNode, stringArray[0]);
        if (aNSNode2 == null) {
            aNSNode2 = new ANSNode(stringArray[0]);
            if (this.db.on()) {
                this.db.println("makeElementPath:created new child " + stringArray[0]);
            }
            aNSNode.addChild(aNSNode2);
        }
        this.makeElementPath(aNSNode2, stringArray[1], aNSElement);
    }

    private String getTimeNotation(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        string = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        string2 = n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3);
        return string + ":" + string2;
    }

    private boolean stringToBool(String string) {
        return string.equals("TRUE");
    }

    private String boolToString(boolean bl) {
        String string = "FALSE";
        if (bl) {
            string = "TRUE";
        }
        return string;
    }

    private void makeTreeWithInfo(ANSNode aNSNode, ANSElement aNSElement) {
        this.makeElementPath(aNSNode, aNSElement.getFullName(), aNSElement);
    }

    public IANSNode getDefaultsTree() throws Exception {
        return this.getDefaultsAnsTree();
    }

    public IANSNode getDefaultsAnsTree() throws Exception {
        Object var1_1 = null;
        ANSNode aNSNode = new ANSNode(this.node.getName() + " (" + this.node.getNodeTypeStr() + ")");
        ArrayList arrayList = this.getSortedAnsElem();
        ANSElement aNSElement = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            aNSElement = (ANSElement)iterator.next();
            this.makeTreeWithInfo(aNSNode, aNSElement);
        }
        if (this.db.on()) {
            this.db.println("defaultsList.length = " + NodeANS.defaultsList.length);
        }
        return aNSNode;
    }

    private void printKey(sParameterKey sParameterKey2) {
        this.db.println("--------------------------------------------------");
        this.db.print("sParameterKey= [");
        this.db.print(new Integer(sParameterKey2.side.value()).toString());
        this.db.print("-");
        this.db.print(new Integer(sParameterKey2.cat.value()).toString());
        this.db.print("-");
        this.db.print(new Integer(sParameterKey2.type.value()).toString());
        this.db.print("-");
        this.db.print(new Integer(sParameterKey2.spectrum.value()).toString());
        this.db.print("-");
        this.db.print(new Integer(sParameterKey2.spectrumIndex).toString());
        this.db.println("]");
    }

    private ArrayList getSortedAnsElem() {
        ArrayList<IANSElement> arrayList = new ArrayList<IANSElement>();
        List<AnsParamModel> list = Arrays.asList(this.neANSModel.getAnsParamList());
        AnsParamModel ansParamModel = null;
        IANSElement iANSElement = null;
        String string = "";
        int n = 0;
        Iterator<AnsParamModel> iterator = list.iterator();
        while (iterator.hasNext()) {
            ansParamModel = iterator.next();
            n = this.getKeyIdxLike(ansParamModel.getParamInfo().key);
            if (n < 0) continue;
            iANSElement = this.makeElementWithInfo(n, ansParamModel.getParamInfo().key);
            try {
                sParameterValue sParameterValue2 = ansParamModel.getParamInfo().value;
                string = this.unMapTCCValue(n, sParameterValue2.currentValue);
                iANSElement.initValue(string);
                iANSElement.setReadOnly(sParameterValue2.isReadOnly);
                arrayList.add(iANSElement);
            }
            catch (ProvisionError provisionError) {
                this.db.println("getAnsElemList ProvisionError");
            }
        }
        Collections.sort(arrayList, new keyComparator());
        return arrayList;
    }

    private String unMapTCCValue(int n, int n2) {
        String string = Integer.toString(-1000000);
        int n3 = Integer.decode((String)NodeANS.defaultsList[n][9]);
        switch (n3) {
            case 2: {
                string = (String)this.getEnumVAlues(n, n3).get(n2);
                break;
            }
            case 0: {
                string = Float.toString((float)n2 / 10.0f);
                break;
            }
        }
        return string;
    }

    private String mapMPValue(int n, int n2) {
        String string = Integer.toString(-1000000);
        int n3 = Integer.decode((String)NodeANS.defaultsList[n][9]);
        switch (n3) {
            case 2: {
                string = (String)this.getEnumVAlues(n, n3).get(n2);
                break;
            }
            case 0: {
                string = Float.toString((float)n2 / 10.0f);
                break;
            }
        }
        return string;
    }

    private String unMapMPValue(int n, String string) {
        String string2 = Integer.toString(-1000000);
        int n2 = Integer.decode((String)NodeANS.defaultsList[n][9]);
        switch (n2) {
            case 2: {
                string2 = string;
                break;
            }
            case 0: {
                string2 = string;
                break;
            }
        }
        return string2;
    }

    private IANSElement makeElementWithInfo(int n, sParameterKey sParameterKey2) {
        StringBuffer stringBuffer = new StringBuffer((String)NodeANS.defaultsList[n][6]);
        int n2 = Integer.decode((String)NodeANS.defaultsList[n][9]);
        if (eNodeSide.SIDE_EAST.equals(sParameterKey2.side)) {
            this.substitute(stringBuffer, "%", "East");
        } else if (eNodeSide.SIDE_WEST.equals(sParameterKey2.side)) {
            this.substitute(stringBuffer, "%", "West");
        } else if (eNodeSide.SIDE_UNKNOWN.equals(sParameterKey2.side)) {
            this.substitute(stringBuffer, "%", "");
        }
        if (eDwdmIO.IO_RX.equals(sParameterKey2.dwdmIO)) {
            this.substitute(stringBuffer, "$", "Rx");
        } else if (eDwdmIO.IO_TX.equals(sParameterKey2.dwdmIO)) {
            this.substitute(stringBuffer, "$", "Tx");
        } else if (eDwdmIO.IO_UNKNOWN.equals(sParameterKey2.dwdmIO)) {
            this.substitute(stringBuffer, "$", "");
        }
        if (sParameterKey2.spectrumIndex > 0) {
            this.substitute(stringBuffer, "@", Integer.toString((sParameterKey2.spectrumIndex - 1) / 4 + 1));
            this.substitute(stringBuffer, "#", Integer.toString(sParameterKey2.spectrumIndex));
        }
        this.substitute(stringBuffer, "dwdm.", "");
        return new ANSElement(stringBuffer.toString(), sParameterKey2, this.makeKeyString(sParameterKey2), n, (String)NodeANS.defaultsList[n][8], n2, this.getEnumVAlues(n, n2));
    }

    private String makeKeyString(sParameterKey sParameterKey2) {
        char c = '-';
        StringBuffer stringBuffer = new StringBuffer(17);
        stringBuffer.append(Integer.toString(sParameterKey2.side.value()));
        stringBuffer.append(c);
        stringBuffer.append(Integer.toString(sParameterKey2.dwdmIO.value()));
        stringBuffer.append(c);
        stringBuffer.append(Integer.toString(sParameterKey2.cat.value()));
        stringBuffer.append(c);
        stringBuffer.append(Integer.toString(sParameterKey2.type.value()));
        stringBuffer.append(c);
        stringBuffer.append(Integer.toString(sParameterKey2.spectrum.value()));
        stringBuffer.append(c);
        stringBuffer.append(Integer.toString(sParameterKey2.spectrumIndex).toString());
        if (this.db.on) {
            this.db.println("makeKeyString:" + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private ArrayList getEnumVAlues(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n2) {
            case 2: {
                for (int i = 10; i < NodeANS.defaultsList[n].length; ++i) {
                    arrayList.add((String)NodeANS.defaultsList[n][i]);
                }
                break;
            }
            case 0: {
                arrayList.add((String)NodeANS.defaultsList[n][10]);
                arrayList.add((String)NodeANS.defaultsList[n][11]);
                break;
            }
            default: {
                arrayList.add(UNKNOWN);
            }
        }
        return arrayList;
    }

    private void substitute(StringBuffer stringBuffer, String string, String string2) {
        int n = stringBuffer.indexOf(string);
        if (n >= 0) {
            stringBuffer.replace(n, n + string.length(), string2);
        }
    }

    private int getKeyIdxLike(sParameterKey sParameterKey2) {
        int n = -1000000;
        for (int i = 0; i < NodeANS.defaultsList.length; ++i) {
            sParameterKey sParameterKey3 = this.getParameterKey(i);
            if (!this.itemLike(sParameterKey3, sParameterKey2)) continue;
            n = i;
            break;
        }
        return n;
    }

    private sParameterKey getParameterKey(int n) {
        sParameterKey sParameterKey2 = new sParameterKey();
        sParameterKey2.side = (eNodeSide)NodeANS.defaultsList[n][0];
        sParameterKey2.dwdmIO = (eDwdmIO)NodeANS.defaultsList[n][1];
        sParameterKey2.cat = (eParamCategory)NodeANS.defaultsList[n][2];
        sParameterKey2.type = (eParamType)NodeANS.defaultsList[n][3];
        sParameterKey2.spectrum = (eSpectrumGranularity)NodeANS.defaultsList[n][4];
        sParameterKey2.spectrumIndex = (Integer)NodeANS.defaultsList[n][5];
        return sParameterKey2;
    }

    private void getParamKeyCopy(int n, sParameterKey sParameterKey2) {
        sParameterKey2.side = (eNodeSide)NodeANS.defaultsList[n][0];
        sParameterKey2.dwdmIO = (eDwdmIO)NodeANS.defaultsList[n][1];
        sParameterKey2.cat = (eParamCategory)NodeANS.defaultsList[n][2];
        sParameterKey2.type = (eParamType)NodeANS.defaultsList[n][3];
        sParameterKey2.spectrum = (eSpectrumGranularity)NodeANS.defaultsList[n][4];
        sParameterKey2.spectrumIndex = (Integer)NodeANS.defaultsList[n][5];
    }

    private boolean itemLike(sParameterKey sParameterKey2, sParameterKey sParameterKey3) {
        return this.itemLike(sParameterKey2.side.value(), sParameterKey3.side.value()) && this.itemLike(sParameterKey2.dwdmIO.value(), sParameterKey3.dwdmIO.value()) && this.itemLike(sParameterKey2.cat.value(), sParameterKey3.cat.value()) && this.itemLike(sParameterKey2.type.value(), sParameterKey3.type.value()) && this.itemLike(sParameterKey2.spectrum.value(), sParameterKey3.spectrum.value()) && this.itemLike(sParameterKey2.spectrumIndex, sParameterKey3.spectrumIndex);
    }

    private boolean itemLike(int n, int n2) {
        if (n == 0) {
            return true;
        }
        return n == n2;
    }

    public IANSElement getElement(IANSNode iANSNode, String string) {
        String string2;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        IANSNode iANSNode2 = null;
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            IANSNode iANSNode3 = iANSNodeArray[i];
            if (!iANSNode3.getName().equals(string2)) continue;
            iANSNode2 = iANSNode3;
            break;
        }
        if (iANSNode2 == null) {
            return null;
        }
        if (string != null) {
            return this.getElement(iANSNode2, string);
        }
        if (iANSNode2 instanceof IANSElement) {
            return (IANSElement)iANSNode2;
        }
        return null;
    }

    public void analyzeTree(ANSNode aNSNode) {
        IANSNode[] iANSNodeArray;
        if (aNSNode == null) {
            this.db.severe("Error!! ansNode == null");
        }
        if (((iANSNodeArray = aNSNode.getChildren()) == null || iANSNodeArray.length == 0) && this.db.on()) {
            this.db.println(((ANSElement)aNSNode).getFullName() + " -> " + ((ANSElement)aNSNode).getValue());
        }
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            this.analyzeTree((ANSNode)iANSNodeArray[i]);
        }
    }

    private void handleNode(IANSNode[] iANSNodeArray) throws Exception {
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            String string = "";
            String string2 = iANSNodeArray[i].getName();
            if (string2.equals("common") || string2.equals("hub_site") || string2.equals("oadm_site")) continue;
            this.db.severe("Unknown general level " + string2);
        }
    }

    public void resetFromNode(IANSNode iANSNode) throws Exception {
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            String string = iANSNodeArray[i].getName();
            if (string.equals("dwdm")) {
                this.handleNode(iANSNodeArray[i].getChildren());
                continue;
            }
            this.db.severe("Unknown general level " + string);
        }
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public void updateLocal() {
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void applyToNode(IANSNode iANSNode) throws Exception {
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        if (this.db.on()) {
            this.db.println("Starting applyToNode..children = " + iANSNodeArray.length);
        }
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            if (iANSNodeArray[i] instanceof ANSElement) {
                this.applyToDwdm((ANSElement)iANSNodeArray[i]);
                continue;
            }
            this.applyToNode(iANSNodeArray[i]);
        }
    }

    public void importParameter(sParameterKey sParameterKey2, String string) {
        this.neANSModel.importParameter(sParameterKey2, string);
    }

    private void applyToDwdm(ANSElement aNSElement) throws Exception {
        if (aNSElement.isDirty()) {
            if (this.db.on()) {
                this.db.println("applyToDwdm: elem name = " + aNSElement.getName());
                this.db.println("applyToDwdm: value =" + aNSElement.getIntValue());
            }
            sParameterKey sParameterKey2 = (sParameterKey)aNSElement.getKey();
            this.neANSModel.setParam(sParameterKey2, aNSElement.getIntValue());
            aNSElement.makeClean();
        }
    }

    private eDwdmRingType stringToRingType(String string) {
        eDwdmRingType eDwdmRingType2 = null;
        if (string.equals("Metro-Access")) {
            eDwdmRingType2 = eDwdmRingType.METRO_ACCESS;
        } else if (string.equals("Metro-Core")) {
            eDwdmRingType2 = eDwdmRingType.METRO_CORE;
        }
        return eDwdmRingType2;
    }

    private eSystemType stringToSystemType(String string) {
        return eSystemType.from_int(Integer.parseInt(string));
    }

    public void init() {
        if (this.db.on()) {
            this.db.info("Initing ANSManager " + this.toString());
        }
        if (!this.inited) {
            super.init0();
            this.neANSModel = new NeANSModel(this.node);
            this.neANSModel.init();
            this.neANSModel.addObserver(this);
            this.inited = true;
        }
    }

    public void delete() {
        if (this.db.on()) {
            this.db.info("Deleting ANSManager " + this.toString());
        }
        this.dispose();
    }

    public void destroy() {
        if (this.inited) {
            if (this.db.on()) {
                this.db.info("Destroying ANSManager " + this.toString());
            }
            super.destroy();
            this.neANSModel.destroy();
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.info("Disposing ANSManager " + this.toString());
        }
        if (this.inited) {
            this.neANSModel.deleteObserver(this);
            this.neANSModel.destroy();
            this.neANSModel = null;
            this.inited = false;
        }
        super.dispose();
    }

    public boolean importDefaults(String string) throws CTCUserException {
        HashMap hashMap = this.importAnsDefaults(string, null);
        int n = -1000000;
        ANSElement aNSElement = null;
        sParameterKey sParameterKey2 = null;
        Object var6_6 = null;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            aNSElement = (ANSElement)hashMap.get(iterator.next());
            sParameterKey2 = (sParameterKey)aNSElement.getKey();
            n = aNSElement.getIntValue();
            try {
                this.importParameter(sParameterKey2, new Integer(n).toString());
            }
            catch (Exception exception) {
                this.db.println("importDefaults error:" + exception);
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importDefaults(String var1_1, IValidity var2_2) throws CTCUserException {
        block17: {
            block16: {
                var3_3 = new File(var1_1);
                var4_4 = null;
                var5_5 = null;
                try {
                    try {
                        var6_6 = new Properties();
                        var4_4 = new FileInputStream(var3_3);
                        var6_6.load(var4_4);
                        var7_9 = new LinkedList<E>();
                        var8_10 = new HashMap<K, V>();
                        var5_5 = this.parseProperties(var6_6, var8_10, var7_9);
                        if (!var7_9.isEmpty()) {
                            if (var2_2 == null) {
                                throw new CTCUserException(ANSManager.getWarningsText(var7_9));
                            }
                            if (var2_2.doCancel(var7_9)) {
                                var9_11 = false;
                                var15_14 = null;
                                if (var4_4 == null) return var9_11;
                                break block16;
                            }
                        }
                        var9_12 = var8_10.keySet().iterator();
                        while (var9_12.hasNext()) {
                            var10_20 = (String)var9_12.next();
                            var11_21 = var6_6.getProperty(var10_20);
                            var12_22 = (IANSElement)var8_10.get(var10_20);
                            try {
                                var12_22.setValue(var11_21);
                            }
                            catch (ProvisionError var13_23) {}
                        }
                        this.applyToNode(var5_5);
                        var9_13 = true;
                        break block17;
                    }
                    catch (IOException var6_7) {
                        throw new CTCUserException("Cannot load file " + var3_3.getAbsolutePath() + ":" + var6_7.getMessage(), (Throwable)var6_7);
                    }
                    catch (Exception var6_8) {
                        throw new CTCUserException("Cannot load properties from the node:" + var6_8.getMessage(), (Throwable)var6_8);
                    }
                }
                catch (Throwable var14_24) {
                    var15_16 = null;
                    if (var4_4 == null) throw var14_24;
                    try {
                        var4_4.close();
                        throw var14_24;
                    }
                    catch (Exception var16_19) {
                        throw var14_24;
                    }
                }
            }
            ** try [egrp 3[TRYBLOCK] [8 : 300->308)] { 
lbl50:
            // 1 sources

            var4_4.close();
            return var9_11;
lbl52:
            // 1 sources

            catch (Exception var16_17) {
                // empty catch block
            }
            return var9_11;
        }
        var15_15 = null;
        if (var4_4 == null) return var9_13;
        try {}
        catch (Exception var16_18) {
            // empty catch block
            return var9_13;
        }
        var4_4.close();
        return var9_13;
    }

    public ANSElement getAnsElem(String string, String string2) throws ProvisionError {
        sParameterKey sParameterKey2 = new sParameterKey();
        int n = this.parseParam(string, sParameterKey2);
        if (this.db.on()) {
            this.db.println("analizeParam:" + string);
            this.printKey(sParameterKey2);
        }
        int n2 = Integer.decode((String)NodeANS.defaultsList[n][9]);
        ANSElement aNSElement = new ANSElement(string, sParameterKey2, this.makeKeyString(sParameterKey2), n, "", n2, this.getEnumVAlues(n, n2));
        String string3 = this.unMapMPValue(n, string2);
        aNSElement.checkValue(string3);
        aNSElement.initValue(string3);
        return aNSElement;
    }

    public int parseParam(String string, sParameterKey sParameterKey2) throws ProvisionError {
        int n = -1;
        String[] stringArray = string.split("\\.");
        boolean bl = false;
        for (n = 0; n < NodeANS.defaultsList.length; ++n) {
            String[] stringArray2 = ((String)NodeANS.defaultsList[n][7]).split("\\.");
            if (stringArray2.length != stringArray.length) continue;
            this.getParamKeyCopy(n, sParameterKey2);
            for (int i = 0; i < stringArray.length && (bl = this.checkParField(stringArray[i], stringArray2[i], sParameterKey2)); ++i) {
            }
            if (bl) break;
        }
        if (!bl) {
            throw new ProvisionError("Parmeter " + string + " Not Found");
        }
        return n;
    }

    private boolean checkParField(String string, String string2, sParameterKey sParameterKey2) {
        boolean bl = false;
        if (string.length() < string2.length()) {
            return false;
        }
        if (string.equals(string2)) {
            bl = true;
        } else {
            int n = this.findNextToken(string2, 0);
            if (!string2.substring(0, n).equals(string.substring(0, n))) {
                bl = false;
            } else {
                int n2 = string2.length();
                while (n < n2) {
                    switch (string2.substring(n, n + 1).charAt(0)) {
                        case '$': {
                            boolean bl2 = bl = (string.charAt(0) == 't' || string.charAt(0) == 'r') && string.charAt(1) == 'x';
                            if (!bl) break;
                            sParameterKey2.dwdmIO = string.charAt(0) == 't' ? eDwdmIO.IO_TX : eDwdmIO.IO_RX;
                            break;
                        }
                        case '&': {
                            bl = true;
                            break;
                        }
                        case '#': {
                            Integer n3;
                            boolean bl3 = bl = string.charAt(n) >= '0' && string.charAt(n) <= '9';
                            if (!bl) break;
                            if (string.charAt(n + 1) >= '0' && string.charAt(n + 1) <= '9') {
                                n3 = Integer.valueOf(string.substring(n, n + 2));
                                if (n3 > 0 && n3 < 33) {
                                    sParameterKey2.spectrumIndex = n3;
                                    break;
                                }
                            } else {
                                n3 = Integer.valueOf(string.substring(n, n + 1));
                                if (n3 > 0 && n3 < 10) {
                                    sParameterKey2.spectrumIndex = n3;
                                    break;
                                }
                            }
                            bl = false;
                            break;
                        }
                        case '%': {
                            boolean bl4 = bl = string.charAt(string.length() - 1) == 'E' || string.charAt(string.length() - 1) == 'W';
                            if (!bl) break;
                            sParameterKey2.side = string.charAt(string.length() - 1) == 'E' ? eNodeSide.SIDE_EAST : eNodeSide.SIDE_WEST;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (!bl) break;
                    n = this.findNextToken(string2, n + 1);
                }
            }
        }
        return bl;
    }

    private int findNextToken(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && string.charAt(n2) - 37 != 0 && string.charAt(n2) - 36 != 0 && string.charAt(n2) - 38 != 0 && string.charAt(n2) - 35 != 0; ++n2) {
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap importAnsDefaults(String string, IValidity iValidity) throws CTCUserException {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        Object var5_5 = null;
        HashMap<String, ANSElement> hashMap = new HashMap<String, ANSElement>();
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            try {
                Properties properties = new Properties();
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                String string2 = (String)properties.get("dwdm.version");
                if (string2 == null) throw new CTCUserException("Wrong file version");
                if (new Float(Float.parseFloat(string2)).intValue() != 2) {
                    throw new CTCUserException("Wrong file version");
                }
                properties.remove("dwdm.version");
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = properties.getProperty(string3);
                    try {
                        ANSElement aNSElement = this.getAnsElem(string3, string4);
                        hashMap.put(string3, aNSElement);
                        if (!this.db.on()) continue;
                        this.db.println("ele done key=" + string3 + " val=" + string4);
                    }
                    catch (ProvisionError provisionError) {
                        linkedList.add(provisionError.getMessage() + ": " + string3);
                    }
                }
                Object var15_17 = null;
                if (fileInputStream == null) return hashMap;
            }
            catch (IOException iOException) {
                throw new CTCUserException("Cannot load file " + file.getAbsolutePath() + ":" + iOException.getMessage(), (Throwable)iOException);
            }
            catch (Exception exception) {
                throw new CTCUserException("Cannot load properties from the node:" + exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        fileInputStream.close();
        return hashMap;
    }

    protected static String getWarningsText(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string + "; ");
        }
        return stringBuffer.toString();
    }

    private IANSNode parseProperties(Properties properties, HashMap hashMap, LinkedList linkedList) throws Exception {
        String string;
        Object object;
        IANSNode iANSNode = this.getDefaultsTree();
        Object object2 = properties.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            string = properties.getProperty((String)object);
            IANSElement iANSElement = this.getElement(iANSNode, (String)object);
            if (iANSElement == null) {
                linkedList.add("unknown default: " + (String)object);
                continue;
            }
            try {
                iANSElement.checkValue(string);
                hashMap.put(object, iANSElement);
            }
            catch (ProvisionError provisionError) {
                linkedList.add(provisionError.getMessage() + ": " + (String)object);
            }
        }
        object2 = new TreeMap();
        this.fillMap((Map)object2, iANSNode);
        object = ((TreeMap)object2).keySet().iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            if (properties.containsKey(string)) continue;
            linkedList.add("missing default: " + string);
        }
        return iANSNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportDefaults(String string) throws CTCUserException {
        boolean bl;
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                Properties properties = this.getDefaultsProperties();
                properties.put("dwdm.version", "2.0");
                ClassLoader classLoader = this.getClass().getClassLoader();
                String string2 = "unknown";
                if (classLoader instanceof CmsClassLoader) {
                    string2 = BuildInfo.sanitize(((CmsClassLoader)classLoader).getSwVersion());
                }
                String string3 = "ANS NE Init from build=" + string2;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, string3);
                    bl = true;
                }
                catch (Exception exception) {
                    throw new CTCUserException("Cannot save defaults to file " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
                }
                Object var10_11 = null;
                if (fileOutputStream == null) return bl;
            }
            catch (Exception exception2) {
                throw new CTCUserException("Cannot load default properties from the node:" + exception2.getMessage(), (Throwable)exception2);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception3) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        fileOutputStream.close();
        return bl;
    }

    public void fillMapProperties(Map map, IANSNode iANSNode) {
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            ANSNode aNSNode = (ANSNode)iANSNodeArray[i];
            if (aNSNode instanceof ANSElement) {
                String string = this.decodePropertyKey((ANSElement)aNSNode);
                if (this.db.on) {
                    this.db.print(i + ") ");
                    this.db.println("key=" + string + " value=" + ((ANSElement)aNSNode).getIntValue());
                }
                map.put(string, this.mapMPValue(((ANSElement)aNSNode).getIndex(), ((ANSElement)aNSNode).getIntValue()));
                continue;
            }
            this.fillMapProperties(map, aNSNode);
        }
    }

    private String decodePropertyKey(ANSElement aNSElement) {
        int n = aNSElement.getIndex();
        sParameterKey sParameterKey2 = (sParameterKey)aNSElement.getKey();
        StringBuffer stringBuffer = new StringBuffer((String)NodeANS.defaultsList[n][7]);
        if (eNodeSide.SIDE_EAST.equals(sParameterKey2.side)) {
            this.substitute(stringBuffer, "%", "E");
        } else if (eNodeSide.SIDE_WEST.equals(sParameterKey2.side)) {
            this.substitute(stringBuffer, "%", "W");
        }
        if (eDwdmIO.IO_RX.equals(sParameterKey2.dwdmIO)) {
            this.substitute(stringBuffer, "$", "rx");
        } else if (eDwdmIO.IO_TX.equals(sParameterKey2.dwdmIO)) {
            this.substitute(stringBuffer, "$", "tx");
        }
        if (sParameterKey2.spectrumIndex > 0) {
            this.substitute(stringBuffer, "#", Integer.toString(sParameterKey2.spectrumIndex));
        }
        return stringBuffer.toString();
    }

    public Properties getDefaultsProperties() throws Exception {
        SortableProperties sortableProperties = new SortableProperties(new Properties());
        HashMap hashMap = new HashMap();
        this.fillMapProperties(hashMap, this.getDefaultsTree());
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            sortableProperties.setProperty(string, string2);
        }
        sortableProperties.setSortedKeys(true);
        return sortableProperties;
    }

    private void fillMap(Map map, IANSNode iANSNode) {
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        for (int i = 0; i < iANSNodeArray.length; ++i) {
            IANSNode iANSNode2 = iANSNodeArray[i];
            if (iANSNode2 instanceof IANSElement) {
                map.put(((IANSElement)iANSNode2).getFullName(), iANSNode2);
                continue;
            }
            this.fillMap(map, iANSNode2);
        }
    }

    class keyComparator
    implements Comparator {
        keyComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ANSElement && object2 instanceof ANSElement) {
                ANSElement aNSElement = (ANSElement)object;
                sParameterKey sParameterKey2 = (sParameterKey)aNSElement.getKey();
                eParamCategory eParamCategory2 = sParameterKey2.cat;
                ANSElement aNSElement2 = (ANSElement)object2;
                sParameterKey sParameterKey3 = (sParameterKey)aNSElement2.getKey();
                eParamCategory eParamCategory3 = sParameterKey3.cat;
                if (!eParamCategory2.equals(eParamCategory.CAT_UNKNOWN) || !eParamCategory2.equals(eParamCategory.CAT_UNKNOWN)) {
                    if (eParamCategory2.equals(eParamCategory.CAT_AMPLI) && (eParamCategory3.equals(eParamCategory.CAT_POWER) || eParamCategory3.equals(eParamCategory.CAT_THRESHOLD))) {
                        return -1;
                    }
                    if (eParamCategory3.equals(eParamCategory.CAT_AMPLI) && (eParamCategory2.equals(eParamCategory.CAT_POWER) || eParamCategory2.equals(eParamCategory.CAT_THRESHOLD))) {
                        return 1;
                    }
                    if (eParamCategory2.equals(eParamCategory.CAT_POWER) && eParamCategory3.equals(eParamCategory.CAT_THRESHOLD)) {
                        return -1;
                    }
                    if (eParamCategory3.equals(eParamCategory.CAT_POWER) && eParamCategory2.equals(eParamCategory.CAT_THRESHOLD)) {
                        return 1;
                    }
                }
                if (sParameterKey2.spectrumIndex > 0 && sParameterKey3.spectrumIndex > 0) {
                    return sParameterKey2.spectrumIndex > sParameterKey3.spectrumIndex ? 1 : -1;
                }
                return aNSElement.getKeyStr().compareTo(aNSElement2.getKeyStr());
            }
            return 1;
        }
    }

    public class ANSManagerDebug
    extends SDebug {
        ANSManagerDebug(KDebug kDebug) {
            super(kDebug, ANSManager.MY_DEBUG_KEY);
        }

        public final void getTree() {
            try {
                ANSManager.this.getDefaultsTree();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final void setTree() {
            try {
                ANSManager.this.applyToNode(ANSManager.this.rootNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface IValidity {
        public boolean doCancel(List var1);
    }
}

