/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.idl.Security.sActiveUserInfo;
import cerent.cms.model.IActiveUserInfoModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NodeModelDelegate;
import java.util.Arrays;

public class ActiveUserInfoModel
implements IActiveUserInfoModel {
    private String userId;
    private eSecurityLevel securityLevel;
    private IIpAddr clientIp;

    public ActiveUserInfoModel(NodeModelDelegate nodeModelDelegate, sActiveUserInfo sActiveUserInfo2) {
        this.userId = sActiveUserInfo2.userId;
        this.securityLevel = eSecurityLevel.from_int(sActiveUserInfo2.securityLevel.value());
        this.clientIp = IpAddrFactory.getIIpAddr(sActiveUserInfo2.clientIpAddress);
    }

    public String getUserId() {
        return this.userId;
    }

    public int getPermissionLevel() {
        return this.securityLevel.value();
    }

    public eSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public IIpAddr getClientIpAddress() {
        return this.clientIp;
    }

    public String toString() {
        return this.userId;
    }

    public boolean equals(Object object) {
        if (object instanceof ActiveUserInfoModel) {
            ActiveUserInfoModel activeUserInfoModel = (ActiveUserInfoModel)object;
            byte[] byArray = this.clientIp.getAddr();
            byte[] byArray2 = activeUserInfoModel.getClientIpAddress().getAddr();
            return activeUserInfoModel.getUserId().equals(this.userId) && activeUserInfoModel.getPermissionLevel() == this.getPermissionLevel() && Arrays.equals(byArray, byArray2);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object instanceof IActiveUserInfoModel) {
            IActiveUserInfoModel iActiveUserInfoModel = (IActiveUserInfoModel)object;
            return this.userId.compareTo(iActiveUserInfoModel.getUserId());
        }
        return -1;
    }

    public int hashCode() {
        return this.userId.hashCode();
    }
}

