/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapEtherPortModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.AsapPosPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class AsapModuleModel
extends PluggableCarrierModel {
    public AsapModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, new SDebug("AsapModuleModel"));
    }

    public InterfaceModel[] getLineInterfaces() {
        return this.getTdmLines();
    }

    public TdmLineModel[] getTdmLines() {
        return this.getAllTdmLines();
    }

    public AsapEtherLineModel[] getEtherLineModels() {
        AsapEtherPortModel[] asapEtherPortModelArray = this.getEtherPortModels();
        AsapEtherLineModel[] asapEtherLineModelArray = new AsapEtherLineModel[asapEtherPortModelArray.length];
        for (int i = 0; i < asapEtherPortModelArray.length; ++i) {
            asapEtherLineModelArray[i] = (AsapEtherLineModel)asapEtherPortModelArray[i].getInterfaceModel();
        }
        this.db.fine("Returning " + asapEtherLineModelArray.length + " EtherLineModels");
        return asapEtherLineModelArray;
    }

    public AsapEtherPortModel[] getEtherPortModels() {
        return this.getAllEtherPortModels().toArray(new AsapEtherPortModel[0]);
    }

    public TdmPortModel[] getTdmPorts() {
        return this.getAllTdmPorts();
    }

    public AsapPosPortModel[] getPosPortModels() {
        return this.getAllPosPortModels().toArray(new AsapPosPortModel[0]);
    }

    public AsapPosLineModel[] getPosLineModels() {
        AsapPosPortModel[] asapPosPortModelArray = this.getPosPortModels();
        AsapPosLineModel[] asapPosLineModelArray = new AsapPosLineModel[asapPosPortModelArray.length];
        for (int i = 0; i < asapPosPortModelArray.length; ++i) {
            asapPosLineModelArray[i] = (AsapPosLineModel)asapPosPortModelArray[i].getInterfaceModel();
            this.db.fine("getting line " + asapPosLineModelArray[i]);
        }
        return asapPosLineModelArray;
    }

    protected TdmLineModel[] getAllTdmLines() {
        TdmLineModel[] tdmLineModelArray = null;
        TdmPortModel[] tdmPortModelArray = null;
        try {
            tdmPortModelArray = this.getAllTdmPorts();
            tdmLineModelArray = new TdmLineModel[tdmPortModelArray.length];
            for (int i = 0; i < tdmPortModelArray.length; ++i) {
                tdmLineModelArray[i] = tdmPortModelArray[i].getTdmLineModel();
            }
        }
        catch (Exception exception) {
            this.db.println("Error in getting ASAP TDM line interfaces" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return tdmLineModelArray;
    }

    protected TdmLineModel[] getTdmLinesOfType(eEqType eEqType2) {
        TdmPortModel[] tdmPortModelArray = null;
        TdmLineModel[] tdmLineModelArray = null;
        try {
            tdmPortModelArray = this.getTdmPortsOfType(eEqType2).toArray(new TdmPortModel[0]);
            tdmLineModelArray = new TdmLineModel[tdmPortModelArray.length];
            for (int i = 0; i < tdmPortModelArray.length; ++i) {
                tdmLineModelArray[i] = tdmPortModelArray[i].getTdmLineModel();
            }
        }
        catch (Exception exception) {
            this.db.println("Error in getting interface lines" + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return tdmLineModelArray;
    }

    protected TdmPortModel[] getAllTdmPorts() {
        TreeSet treeSet = new TreeSet(new EntityModel.EntityModelComparator());
        List list = null;
        list = this.getTdmPortsOfType(eEqType.OC3_PORT);
        treeSet.addAll(list);
        list = this.getTdmPortsOfType(eEqType.OC12_PORT);
        treeSet.addAll(list);
        list = this.getTdmPortsOfType(eEqType.OC48_PORT);
        treeSet.addAll(list);
        if (this.db.on()) {
            this.db.println("Total number of ASAP TDM ports " + treeSet.size());
        }
        return treeSet.toArray(new TdmPortModel[treeSet.size()]);
    }

    protected List getTdmPortsOfType(eEqType eEqType2) {
        List list = null;
        list = this.getDescendantsOfType(eEqType2);
        if (this.db.on()) {
            this.db.println("Number of TDM ports of eqType= " + eEqType2.value() + ", num= " + list.size());
        }
        return list;
    }

    protected List getAllEtherPortModels() {
        return this.getDescendantsOfType(eEqType.L1P_ETHER_PORT);
    }

    protected List getAllPosPortModels() {
        return this.getDescendantsOfType(eEqType.L1P_POS_PORT);
    }

    public List getAvailablePimSlots() {
        ArrayList<PluggableSlotModel> arrayList = new ArrayList<PluggableSlotModel>();
        PluggableSlotModel[] pluggableSlotModelArray = this.getPimSlots();
        for (int i = 0; i < pluggableSlotModelArray.length; ++i) {
            if (pluggableSlotModelArray[i].getChildren().isEmpty()) {
                arrayList.add(pluggableSlotModelArray[i]);
                continue;
            }
            PimModel pimModel = (PimModel)pluggableSlotModelArray[i].getChildren().get(0);
            if (pimModel.getState() != eEqState.DELETED || this.getState() == eEqState.DELETED) continue;
            arrayList.add(pluggableSlotModelArray[i]);
        }
        return arrayList;
    }

    public List getAvailablePimSlotNumbers() {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        List list = this.getAvailablePimSlots();
        for (int i = 0; i < list.size(); ++i) {
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)list.get(i);
            int[] nArray = pluggableSlotModel.getHierarchyNums();
            arrayList.add(nArray);
        }
        return arrayList;
    }
}

